/*
 * Decompiled with CFR 0.152.
 */
package maqetta.zazl;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import maqetta.zazl.HTMLParser;
import maqetta.zazl.MaqettaOSGiResourceLoader;

public class MaqettaHTMLFilter
implements Filter {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String PRAGMA = "Pragma";
    private static final String EXPIRES = "Expires";
    private static Logger logger = Logger.getLogger("maqetta.zazl");
    private StringBuffer configScriptTag = null;
    private MaqettaOSGiResourceLoader resourceLoader = null;

    public MaqettaHTMLFilter(MaqettaOSGiResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.configScriptTag = new StringBuffer();
        this.configScriptTag.append("<script type=\"text/javascript\">\n");
        this.configScriptTag.append("var dojoConfig = __DOJOCONFIG__;\n");
        this.configScriptTag.append("var zazlConfig = {\n");
        this.configScriptTag.append("\tdirectInject: true,\n");
        this.configScriptTag.append("\twarmupLoader: '__URLPREFIX__/dojo/dojo.js',\n");
        this.configScriptTag.append("\tinjectUrl: '__CONTEXT_PATH__/_javascript',\n");
        this.configScriptTag.append("\tpackages:[\n");
        this.configScriptTag.append("\t\t{'name':'dojo','location':'__URLPREFIX__/dojo'},\n");
        this.configScriptTag.append("\t\t{'name':'dijit','location':'__URLPREFIX__/dijit'},\n");
        this.configScriptTag.append("\t\t{'name':'dojox','location':'__URLPREFIX__/dojox'}\n");
        this.configScriptTag.append("\t],\n\tpaths: {\n__PATHS__\n\t}\n");
        this.configScriptTag.append("};\n");
        this.configScriptTag.append("dojoConfig.baseUrl='__CONTEXT_PATH__./';\n");
        this.configScriptTag.append("dojoConfig.packages = zazlConfig.packages;\n");
        this.configScriptTag.append("dojoConfig.paths = zazlConfig.paths;\n");
        this.configScriptTag.append("</script>\n");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.resourceLoader.contextPathSet()) {
            this.resourceLoader.setContextPath(((HttpServletRequest)request).getContextPath());
        }
        String pathInfo = ((HttpServletRequest)request).getPathInfo();
        boolean isZazlRequest = false;
        String strIsZazlRequest = request.getParameter("zazl");
        if (strIsZazlRequest != null && strIsZazlRequest.equals("true")) {
            isZazlRequest = true;
        }
        if (isZazlRequest && pathInfo.endsWith(".html") && pathInfo.startsWith("/user")) {
            HttpServletResponse resp = (HttpServletResponse)response;
            if (resp.containsHeader(EXPIRES)) {
                resp.setDateHeader(EXPIRES, 0L);
                resp.setHeader(CACHE_CONTROL, "no-cache");
                resp.setHeader(PRAGMA, "no-cache");
            }
            PrintWriter out = response.getWriter();
            ((HttpServletRequest)request).getRequestURI();
            RequestWrapper requestWrapper = new RequestWrapper((HttpServletRequest)request);
            ResponseWrapper responseWrapper = new ResponseWrapper((HttpServletResponse)response);
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            String responseText = responseWrapper.toString();
            if (responseText != null && responseText.length() > 0) {
                String result = responseText;
                CharArrayWriter caw = new CharArrayWriter();
                HTMLParser parser = new HTMLParser(caw, "UTF-8", this.configScriptTag.toString().replace("__CONTEXT_PATH__", request.getServletContext().getContextPath()), pathInfo);
                parser.parse(responseText);
                result = caw.toString();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.logp(Level.FINEST, this.getClass().getName(), "doFilter", "filter response : " + result);
                }
                response.setContentLength(result.length());
                out.write(result);
                out.close();
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    public class RequestWrapper
    extends HttpServletRequestWrapper {
        public RequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getHeader(String name) {
            logger.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "getHeader", "getting header with name [" + name + "]");
            if (name.equalsIgnoreCase("If-None-Match") || name.equalsIgnoreCase("If-Modified-Since") || name.equalsIgnoreCase("If-Match")) {
                logger.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "getHeader", "Skipping adding header [" + name + "]");
                return null;
            }
            return super.getHeader(name);
        }

        public Enumeration getHeaderNames() {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            ArrayList<String> headerNamelist = new ArrayList<String>();
            Enumeration e = request.getHeaderNames();
            while (e.hasMoreElements()) {
                String headerName = (String)e.nextElement();
                if (!(headerName.equalsIgnoreCase("If-None-Match") || headerName.equalsIgnoreCase("If-Modified-Since") || headerName.equalsIgnoreCase("If-Match"))) {
                    headerNamelist.add(headerName);
                    continue;
                }
                logger.logp(Level.FINE, ((Object)((Object)this)).getClass().getName(), "getHeader", "Skipping adding header [" + headerName + "]");
            }
            return Collections.enumeration(headerNamelist);
        }
    }

    public class ResponseWrapper
    extends HttpServletResponseWrapper {
        private CharArrayWriter writer;
        private PrintWriter pw;
        private ServletOutputStreamWrapper stream;
        private int status;
        private String charset;

        public ResponseWrapper(HttpServletResponse response) {
            super(response);
            this.writer = null;
            this.pw = null;
            this.stream = null;
            this.charset = null;
            this.charset = response.getCharacterEncoding();
        }

        public PrintWriter getWriter() {
            if (this.stream != null) {
                throw new IllegalStateException("Cannot call getWriter() after getOutputStream()");
            }
            if (this.writer == null) {
                this.writer = new CharArrayWriter();
                this.pw = new PrintWriter(this.writer);
            }
            return this.pw;
        }

        public ServletOutputStream getOutputStream() {
            if (this.writer != null) {
                throw new IllegalStateException("Cannot call getOutputStream() after getWriter()");
            }
            if (this.stream == null) {
                this.stream = new ServletOutputStreamWrapper();
            }
            return this.stream;
        }

        public String toString() {
            if (this.writer != null) {
                return this.writer.toString();
            }
            if (this.stream != null) {
                return this.stream.toString(this.charset);
            }
            return null;
        }

        public void setStatus(int sc) {
            super.setStatus(sc);
            this.status = sc;
        }

        public void setStatus(int sc, String sm) {
            super.setStatus(sc, sm);
            this.status = sc;
        }

        public int getStatus() {
            return this.status;
        }

        public void setCharacterEncoding(String charset) {
            super.setCharacterEncoding(charset);
            this.charset = charset;
        }

        public void setHeader(String name, String value) {
        }

        public void addHeader(String name, String value) {
        }
    }

    public class ServletOutputStreamWrapper
    extends ServletOutputStream {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
        private DataOutputStream stream = new DataOutputStream(this.baos);

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        /*
         * Loose catch block
         */
        public String toString(String encoding) {
            String string;
            GZIPInputStream gzipis;
            block23: {
                block21: {
                    String string2;
                    block22: {
                        byte[] bytes;
                        block19: {
                            block20: {
                                gzipis = null;
                                bytes = this.baos.toByteArray();
                                if (bytes.length >= 1) break block19;
                                if (gzipis == null) break block20;
                                try {
                                    gzipis.close();
                                }
                                catch (IOException iOException) {}
                            }
                            return "";
                        }
                        if ((bytes[0] & 0xFF) != 31 || (bytes[1] & 0xFF) != 139 || (bytes[2] & 0xFF) != 8) break block21;
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.logp(Level.FINEST, ((Object)((Object)this)).getClass().getName(), "toString", "response content is gzipped");
                        }
                        gzipis = new GZIPInputStream(new ByteArrayInputStream(bytes));
                        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)gzipis, encoding));
                        StringBuffer sb = new StringBuffer();
                        String s = null;
                        while ((s = br.readLine()) != null) {
                            sb.append(s);
                            sb.append("\n");
                        }
                        string2 = sb.toString();
                        if (gzipis == null) break block22;
                        try {
                            gzipis.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return string2;
                }
                string = this.baos.toString(encoding);
                if (gzipis == null) break block23;
                try {
                    gzipis.close();
                }
                catch (IOException iOException) {}
            }
            return string;
            catch (IOException e) {
                block24: {
                    try {
                        e.printStackTrace();
                        if (gzipis == null) break block24;
                    }
                    catch (Throwable throwable) {
                        if (gzipis != null) {
                            try {
                                gzipis.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    try {
                        gzipis.close();
                    }
                    catch (IOException iOException) {}
                }
                return null;
            }
        }
    }
}

