/*
 * Decompiled with CFR 0.152.
 */
package maqetta.server.orion;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import maqetta.server.orion.VOrionProjectStorage;
import maqetta.server.orion.VOrionStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.orion.internal.server.servlets.workspace.WebProject;
import org.eclipse.orion.internal.server.servlets.workspace.WebWorkspace;
import org.eclipse.orion.internal.server.servlets.workspace.WorkspaceResourceHandler;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.maqetta.server.IStorage;

public class VOrionWorkspaceStorage
extends VOrionProjectStorage {
    WebWorkspace webWorkspace = null;
    String PROJECT_NODE_NAME = "Project";
    String userName = null;

    public VOrionWorkspaceStorage(WebWorkspace webWorkspace, String userName) {
        super(".", null, null);
        this.webWorkspace = webWorkspace;
    }

    @Override
    public IStorage newInstance(String name) {
        Path path = new Path(name);
        String seg1 = path.segment(0);
        WebProject project = this.webWorkspace.getProjectByName(seg1);
        if (project == null) {
            return new IStorage(){

                public boolean exists() {
                    return false;
                }

                public String getAbsolutePath() {
                    return null;
                }

                public boolean mkdirs() {
                    return false;
                }

                public IStorage[] listFiles() {
                    return null;
                }

                public boolean isDirectory() {
                    return true;
                }

                public URI toURI() {
                    return null;
                }

                public IStorage getParentFile() {
                    return null;
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }

                public InputStream getInputStream() throws IOException {
                    return null;
                }

                public boolean delete() {
                    return false;
                }

                public void createNewFile() throws IOException {
                }

                public String getPath() {
                    return null;
                }

                public String getName() {
                    return null;
                }

                public void mkdir() throws IOException {
                }

                public void renameTo(IStorage file) throws IOException {
                }

                public IStorage newInstance(String name) {
                    return null;
                }

                public IStorage newInstance(IStorage parent, String name) {
                    return null;
                }

                public IStorage newInstance(URI uri) {
                    return null;
                }

                public IStorage create(String path) {
                    return null;
                }

                public Collection<?> findFiles(IStorage parentFolder, String pathStr, boolean ignoreCase) {
                    return null;
                }

                public boolean isFile() {
                    return false;
                }

                public String[] list() {
                    return null;
                }
            };
        }
        return super.newInstance(name);
    }

    @Override
    public IStorage newInstance(IStorage parent, String name) {
        if (parent instanceof VOrionWorkspaceStorage) {
            return parent.newInstance(name);
        }
        return super.newInstance(parent, name);
    }

    @Override
    public String getPath() {
        return this.name;
    }

    @Override
    public IStorage create(String name) {
        Path path = new Path(name);
        VOrionStorage parent = (VOrionStorage)this.createProject(path.segment(0));
        if (path.segmentCount() > 1) {
            return parent.create(path.removeFirstSegments(1).toString());
        }
        return parent;
    }

    @Override
    public void mkdir() throws IOException {
    }

    @Override
    public boolean mkdirs() {
        return true;
    }

    @Override
    public boolean exists() {
        return true;
    }

    public IStorage createProject(String name) {
        IStorage existing = this.get(name);
        if (existing != null) {
            return existing;
        }
        String id = WebProject.nextProjectId();
        WebProject project = WebProject.fromId((String)id);
        project.setName(name);
        try {
            DummyRequest req = new DummyRequest(this.userName);
            WorkspaceResourceHandler.computeProjectLocation((HttpServletRequest)req, (WebProject)project, null, (boolean)true);
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        try {
            WorkspaceResourceHandler.addProject((String)this.userName, (WebWorkspace)this.webWorkspace, (WebProject)project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        try {
            return new VOrionProjectStorage(name, project.getProjectStore(), project, this);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public IStorage get(String name) {
        IStorage[] projects = this.listFiles();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getName().compareTo(name) == 0) {
                return projects[i];
            }
            ++i;
        }
        return null;
    }

    public void removeProject(WebProject webProject) {
        this.webWorkspace.removeProject(webProject);
        try {
            this.webWorkspace.save();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IStorage[] listFiles() {
        Vector<VOrionProjectStorage> projects = new Vector<VOrionProjectStorage>();
        try {
            JSONArray allProjects = this.webWorkspace.getProjectsJSON();
            int i = 0;
            while (i < allProjects.length()) {
                JSONObject projObj = (JSONObject)allProjects.opt(i);
                String id = projObj.getString("Id");
                WebProject result = WebProject.fromId((String)id);
                String name = result.getName();
                try {
                    projects.add(new VOrionProjectStorage(name, result.getProjectStore(), result, this));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        catch (JSONException jSONException) {
            JSONArray allProjects = new JSONArray();
        }
        return projects.toArray(new VOrionProjectStorage[projects.size()]);
    }

    private class DummyRequest
    implements HttpServletRequest {
        private String remoteUser;

        DummyRequest(String user) {
            this.remoteUser = user;
        }

        public AsyncContext getAsyncContext() {
            return null;
        }

        public Object getAttribute(String arg0) {
            return null;
        }

        public Enumeration<String> getAttributeNames() {
            return null;
        }

        public String getCharacterEncoding() {
            return null;
        }

        public int getContentLength() {
            return 0;
        }

        public String getContentType() {
            return null;
        }

        public DispatcherType getDispatcherType() {
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            return null;
        }

        public String getLocalAddr() {
            return null;
        }

        public String getLocalName() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration<Locale> getLocales() {
            return null;
        }

        public String getParameter(String arg0) {
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return null;
        }

        public Enumeration<String> getParameterNames() {
            return null;
        }

        public String[] getParameterValues(String arg0) {
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public BufferedReader getReader() throws IOException {
            return null;
        }

        public String getRealPath(String arg0) {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public RequestDispatcher getRequestDispatcher(String arg0) {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 0;
        }

        public ServletContext getServletContext() {
            return null;
        }

        public boolean isAsyncStarted() {
            return false;
        }

        public boolean isAsyncSupported() {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public void removeAttribute(String arg0) {
        }

        public void setAttribute(String arg0, Object arg1) {
        }

        public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        }

        public AsyncContext startAsync() throws IllegalStateException {
            return null;
        }

        public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) throws IllegalStateException {
            return null;
        }

        public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
            return false;
        }

        public String getAuthType() {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public Cookie[] getCookies() {
            return null;
        }

        public long getDateHeader(String arg0) {
            return 0L;
        }

        public String getHeader(String arg0) {
            return null;
        }

        public Enumeration<String> getHeaderNames() {
            return null;
        }

        public Enumeration<String> getHeaders(String arg0) {
            return null;
        }

        public int getIntHeader(String arg0) {
            return 0;
        }

        public String getMethod() {
            return null;
        }

        public Part getPart(String arg0) throws IOException, ServletException {
            return null;
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            return null;
        }

        public String getPathInfo() {
            return null;
        }

        public String getPathTranslated() {
            return null;
        }

        public String getQueryString() {
            return null;
        }

        public String getRemoteUser() {
            return this.remoteUser;
        }

        public String getRequestURI() {
            return null;
        }

        public StringBuffer getRequestURL() {
            return null;
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getServletPath() {
            return null;
        }

        public HttpSession getSession() {
            return null;
        }

        public HttpSession getSession(boolean arg0) {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isUserInRole(String arg0) {
            return false;
        }

        public void login(String arg0, String arg1) throws ServletException {
        }

        public void logout() throws ServletException {
        }
    }
}

