/*
 * Decompiled with CFR 0.152.
 */
package maqetta.core.server.user.manager;

import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import maqetta.core.server.user.User;
import maqetta.core.server.util.VResourceUtils;
import org.davinci.server.user.IPerson;
import org.davinci.server.user.IPersonManager;
import org.davinci.server.user.IUser;
import org.davinci.server.user.IUserManager;
import org.davinci.server.user.UserException;
import org.maqetta.server.IStorage;
import org.maqetta.server.ServerManager;

public class UserManagerImpl
implements IUserManager {
    private static final Logger theLogger = Logger.getLogger(UserManagerImpl.class.getName());
    private static IUser localUser;
    protected static UserManagerImpl theUserManager;
    protected IStorage baseDirectory;
    protected IPersonManager personManager;
    protected int maxUsers = 0;
    protected int usersCount;

    public UserManagerImpl() {
        ServerManager serverManger = ServerManager.getServerManager();
        this.initWorkspace();
        String maxUsersStr = serverManger.getDavinciProperty("maqetta.maxUsers");
        if (maxUsersStr != null && maxUsersStr.length() > 0) {
            this.maxUsers = Integer.valueOf(maxUsersStr);
        }
        this.personManager = ServerManager.getServerManager().getPersonManager();
    }

    protected void initWorkspace() {
        this.baseDirectory = ServerManager.getServerManager().getBaseDirectory();
        this.usersCount = this.baseDirectory.list().length;
        theLogger.info("Setting [user space] to: " + this.baseDirectory.getAbsolutePath());
    }

    public boolean hasPermisions(IUser owner, IUser requester, String resource) {
        return resource != "";
    }

    public IUser newUser(IPerson person, IStorage baseDirectory) throws UserException, IOException {
        return new User(person, baseDirectory);
    }

    public IUser getUser(String userName) throws UserException, IOException {
        if (ServerManager.LOCAL_INSTALL && "maqettaUser".equals(userName)) {
            return this.getSingleUser();
        }
        if (this.checkUserExists(userName)) {
            IPerson person = this.personManager.getPerson(userName);
            return this.newUser(person, this.baseDirectory.newInstance(this.baseDirectory, userName));
        }
        return null;
    }

    public IUser addUser(String userName, String password, String email) throws UserException, IOException {
        if (this.checkUserExists(userName)) {
            throw new UserException("User already exists");
        }
        if (this.maxUsers > 0 && this.usersCount >= this.maxUsers) {
            throw new UserException("Maximum number of Maqetta users exceded");
        }
        IPerson person = this.personManager.addPerson(userName, password, email);
        if (person != null) {
            IUser user = this.newUser(person, this.baseDirectory.newInstance(this.baseDirectory, userName));
            try {
                user.createProject("project1");
            }
            catch (IOException e) {
                throw new UserException(e);
            }
            ++this.usersCount;
            return user;
        }
        return null;
    }

    public void removeUser(String userName) throws UserException, IOException {
        if (!this.checkUserExists(userName)) {
            return;
        }
        IStorage userDir = this.baseDirectory.newInstance(this.baseDirectory, userName);
        VResourceUtils.deleteDir(userDir);
        --this.usersCount;
    }

    public IUser login(String userName, String password) throws UserException, IOException {
        if (!this.checkUserExists(userName)) {
            return null;
        }
        IPerson person = this.personManager.login(userName, password);
        if (person != null) {
            return this.newUser(person, this.baseDirectory.newInstance(this.baseDirectory, userName));
        }
        return null;
    }

    protected boolean checkUserExists(String userName) {
        IStorage userDir = this.baseDirectory.newInstance(this.baseDirectory, userName);
        return userDir.exists();
    }

    public boolean isValidUser(String userName) throws UserException, IOException {
        if (ServerManager.LOCAL_INSTALL && "maqettaUser".equals(userName)) {
            return true;
        }
        IUser user = this.getUser(userName);
        return user != null;
    }

    public boolean isValidUserByEmail(String email) throws UserException {
        throw new Error("NOT IMPLEMENTED");
    }

    public IUser getSingleUser() {
        if (localUser == null) {
            try {
                IStorage userDir = this.baseDirectory;
                userDir.mkdir();
                class LocalPerson
                implements IPerson {
                    LocalPerson() {
                    }

                    public String getEmail() {
                        return "";
                    }

                    public String getUserID() {
                        return "maqettaUser";
                    }

                    public String getDisplayName() {
                        return "";
                    }
                }
                localUser = new User(new LocalPerson(), userDir);
                IStorage settingsDir = this.baseDirectory.newInstance(userDir, ".settings");
                if (!settingsDir.exists()) {
                    settingsDir.mkdir();
                    localUser.createProject("project1");
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return localUser;
    }

    public IUser getUser(HttpServletRequest req) {
        if (ServerManager.LOCAL_INSTALL) {
            return this.getSingleUser();
        }
        return (IUser)req.getSession().getAttribute("MAQETTA.USER");
    }
}

