/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.server.util;

public class JSONWriter {
    StringBuffer sb = new StringBuffer();
    boolean[] wasOne = new boolean[100];
    int stackPtr = 0;
    boolean isArray;

    public JSONWriter(boolean isArray) {
        this.isArray = isArray;
        if (isArray) {
            this.startArray();
        } else {
            this.sb.append("{");
        }
    }

    public JSONWriter startObject() {
        if (this.wasOne[this.stackPtr]) {
            this.sb.append(", ");
        }
        this.wasOne[this.stackPtr] = true;
        this.wasOne[++this.stackPtr] = false;
        this.sb.append("{");
        return this;
    }

    public JSONWriter startArray() {
        this.wasOne[++this.stackPtr] = false;
        this.sb.append("[");
        return this;
    }

    public JSONWriter endObject() {
        this.sb.append("}");
        --this.stackPtr;
        return this;
    }

    public JSONWriter endArray() {
        this.sb.append("]");
        --this.stackPtr;
        return this;
    }

    public JSONWriter addFieldName(String name) {
        if (this.wasOne[this.stackPtr]) {
            this.sb.append(", ");
        }
        this.sb.append('\"').append(name).append('\"').append(" : ");
        this.wasOne[this.stackPtr] = true;
        return this;
    }

    public JSONWriter addField(String name, boolean value) {
        this.addFieldName(name);
        this.sb.append(value);
        return this;
    }

    public JSONWriter addField(String name, int value) {
        this.addFieldName(name);
        this.sb.append(value);
        return this;
    }

    public JSONWriter addField(String name, String val) {
        char c;
        this.addFieldName(name);
        String value = val == null ? "" : val;
        this.sb.append('\"');
        char[] chars = null;
        int i = 0;
        block18: while (i < value.length()) {
            c = value.charAt(i);
            switch (c) {
                case '\"': {
                    chars = value.toCharArray();
                    this.sb.append(chars, 0, i);
                    this.sb.append("\\\"");
                    break block18;
                }
                case '\\': {
                    chars = value.toCharArray();
                    this.sb.append(chars, 0, i);
                    this.sb.append("\\\\");
                    break block18;
                }
                case '\n': {
                    chars = value.toCharArray();
                    this.sb.append(chars, 0, i);
                    this.sb.append("\\n");
                    break block18;
                }
                case '\r': {
                    chars = value.toCharArray();
                    this.sb.append(chars, 0, i);
                    this.sb.append("\\r");
                    break block18;
                }
                case '\t': {
                    chars = value.toCharArray();
                    this.sb.append(chars, 0, i);
                    this.sb.append("\\t");
                    break block18;
                }
                case '\f': {
                    chars = value.toCharArray();
                    this.sb.append(chars, 0, i);
                    this.sb.append("\\f");
                    break block18;
                }
                case '\b': {
                    chars = value.toCharArray();
                    this.sb.append(chars, 0, i);
                    this.sb.append("\\b");
                    break block18;
                }
                default: {
                    ++i;
                }
            }
        }
        if (chars == null) {
            this.sb.append(value);
        } else {
            ++i;
            while (i < value.length()) {
                c = value.charAt(i);
                switch (c) {
                    case '\"': {
                        this.sb.append("\\\"");
                        break;
                    }
                    case '\\': {
                        this.sb.append("\\\\");
                        break;
                    }
                    case '\n': {
                        this.sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        this.sb.append("\\r");
                        break;
                    }
                    case '\t': {
                        this.sb.append("\\t");
                        break;
                    }
                    case '\f': {
                        this.sb.append("\\f");
                        break;
                    }
                    case '\b': {
                        this.sb.append("\\b");
                        break;
                    }
                    default: {
                        this.sb.append(c);
                    }
                }
                ++i;
            }
        }
        this.sb.append('\"');
        return this;
    }

    public JSONWriter addField(String name, String[] array) {
        this.addFieldName(name);
        int ll = 0;
        while (ll < array.length) {
            char c;
            if (ll > 0) {
                this.sb.append(",");
            }
            this.sb.append("[");
            String value = array[ll];
            this.sb.append('\"');
            char[] chars = null;
            int i = 0;
            block19: while (i < value.length()) {
                c = value.charAt(i);
                switch (c) {
                    case '\"': {
                        chars = value.toCharArray();
                        this.sb.append(chars, 0, i);
                        this.sb.append("\\\"");
                        break block19;
                    }
                    case '\\': {
                        chars = value.toCharArray();
                        this.sb.append(chars, 0, i);
                        this.sb.append("\\\\");
                        break block19;
                    }
                    case '\n': {
                        chars = value.toCharArray();
                        this.sb.append(chars, 0, i);
                        this.sb.append("\\n");
                        break block19;
                    }
                    case '\r': {
                        chars = value.toCharArray();
                        this.sb.append(chars, 0, i);
                        this.sb.append("\\r");
                        break block19;
                    }
                    case '\t': {
                        chars = value.toCharArray();
                        this.sb.append(chars, 0, i);
                        this.sb.append("\\t");
                        break block19;
                    }
                    case '\f': {
                        chars = value.toCharArray();
                        this.sb.append(chars, 0, i);
                        this.sb.append("\\f");
                        break block19;
                    }
                    case '\b': {
                        chars = value.toCharArray();
                        this.sb.append(chars, 0, i);
                        this.sb.append("\\b");
                        break block19;
                    }
                    default: {
                        ++i;
                    }
                }
            }
            if (chars == null) {
                this.sb.append(value);
            } else {
                ++i;
                while (i < value.length()) {
                    c = value.charAt(i);
                    switch (c) {
                        case '\"': {
                            this.sb.append("\\\"");
                            break;
                        }
                        case '\\': {
                            this.sb.append("\\\\");
                            break;
                        }
                        case '\n': {
                            this.sb.append("\\n");
                            break;
                        }
                        case '\r': {
                            this.sb.append("\\r");
                            break;
                        }
                        case '\t': {
                            this.sb.append("\\t");
                            break;
                        }
                        case '\f': {
                            this.sb.append("\\f");
                            break;
                        }
                        case '\b': {
                            this.sb.append("\\b");
                            break;
                        }
                        default: {
                            this.sb.append(c);
                        }
                    }
                    ++i;
                }
            }
            this.sb.append('\"');
            this.sb.append("]");
            ++ll;
        }
        return this;
    }

    public String getJSON() {
        if (this.isArray) {
            this.endArray();
        } else {
            this.sb.append("}");
        }
        return this.sb.toString();
    }

    public String toString() {
        if (this.sb == null) {
            return "EMPTY";
        }
        return this.sb.toString();
    }

    public boolean isEmpty() {
        int ptr = this.stackPtr;
        while (ptr >= 0) {
            if (!this.wasOne[ptr--]) continue;
            return false;
        }
        return true;
    }
}

