/*
 * Decompiled with CFR 0.152.
 */
package org.davinci.server.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLElement {
    HashMap tags = new HashMap();
    HashMap clazzes = new HashMap();

    protected abstract String getElementTag();

    protected abstract String[] getAttributeNames();

    protected abstract Object createObject(Element var1, String[] var2, String[] var3);

    protected abstract String getAttributeValue(String var1, Object var2);

    protected void saveElementAddition(Element element, Object value) {
    }

    public ArrayList load(Element parentElement) {
        ArrayList<Object> objects = new ArrayList<Object>();
        String elementTag = this.getElementTag();
        NodeList userElements = parentElement.getElementsByTagName(elementTag);
        int i = 0;
        while (i < userElements.getLength()) {
            Element userElement = (Element)userElements.item(i);
            objects.add(this.loadElement(userElement));
            ++i;
        }
        return objects;
    }

    public Object loadElement(Element userElement) {
        NamedNodeMap map = userElement.getAttributes();
        String[] attributeNames = new String[map.getLength()];
        String[] values = new String[attributeNames.length];
        int i = 0;
        while (i < map.getLength()) {
            Node item = map.item(i);
            attributeNames[i] = item.getNodeName();
            values[i] = item.getNodeValue();
            ++i;
        }
        return this.createObject(userElement, attributeNames, values);
    }

    public ArrayList loadAny(Element parentElement) {
        ArrayList<Object> objects = new ArrayList<Object>();
        NodeList nodeList = parentElement.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element;
            String name;
            XMLElement xmlElement;
            Node item = nodeList.item(i);
            if (item.getNodeType() == 1 && (xmlElement = (XMLElement)this.tags.get(name = (element = (Element)item).getLocalName())) != null) {
                objects.add(xmlElement.loadElement(element));
            }
            ++i;
        }
        return objects;
    }

    public void saveElement(Element parentElement, Object value) {
        String elementTag = this.getElementTag();
        String[] attributeNames = this.getAttributeNames();
        String[] attrValues = new String[attributeNames.length];
        int i = 0;
        while (i < attributeNames.length) {
            attrValues[i] = this.getAttributeValue(attributeNames[i], value);
            ++i;
        }
        Document document = parentElement.getOwnerDocument();
        Element element = document.createElement(elementTag);
        int i2 = 0;
        while (i2 < attrValues.length) {
            if (attrValues[i2] != null) {
                element.setAttribute(attributeNames[i2], attrValues[i2]);
            }
            ++i2;
        }
        parentElement.appendChild(element);
        this.saveElementAddition(element, value);
    }

    public void save(Element parentElement, Collection values) {
        for (Object value : values) {
            this.saveElement(parentElement, value);
        }
    }

    public void saveAny(Element parentElement, Object[] values) {
        int i = 0;
        while (i < values.length) {
            Object value = values[i];
            XMLElement element = (XMLElement)this.clazzes.get(value.getClass());
            if (element != null) {
                element.saveElement(parentElement, value);
            }
            ++i;
        }
    }

    public void addTag(XMLElement element, Class forClass) {
        this.tags.put(element.getElementTag(), element);
        this.clazzes.put(forClass, element);
    }
}

