/*
 * Decompiled with CFR 0.152.
 */
package org.maqetta.server;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.davinci.server.user.IPerson;
import org.davinci.server.user.IUser;
import org.eclipse.core.runtime.Path;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.maqetta.server.IProjectTemplatesManager;
import org.maqetta.server.IStorage;
import org.maqetta.server.ServerManager;

public class ProjectTemplatesManager
implements IProjectTemplatesManager {
    private IStorage projectTemplatesDirectory = null;
    private IStorage projectTemplatesIndexIStorage = null;
    private JSONObject projectTemplatesIndex = null;
    private static final Logger theLogger = Logger.getLogger(ServerManager.class.getName());
    private Boolean enableProjectSharingAll = true;

    public ProjectTemplatesManager() {
        String enableProjectSharingAllString = ServerManager.getServerManager().getDavinciProperty("maqetta.projecttemplates.sharing.all.enabled");
        this.enableProjectSharingAll = enableProjectSharingAllString == null || enableProjectSharingAllString.equals("true");
    }

    private JSONObject _getProjectTemplatesIndex() throws IOException {
        if (this.projectTemplatesIndex != null) {
            return this.projectTemplatesIndex;
        }
        IStorage indexFile = this.getProjectTemplatesIndexIStorage();
        try {
            if (!indexFile.exists()) {
                this.projectTemplatesIndex = new JSONObject();
                JSONArray templates = new JSONArray();
                this.projectTemplatesIndex.put("templates", (Object)templates);
            } else {
                String indexFileContents = this.readFile(indexFile.getPath());
                this.projectTemplatesIndex = new JSONObject(indexFileContents);
            }
        }
        catch (JSONException e) {
            String desc = "Project Templates index file - not a valid json file";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        return this.projectTemplatesIndex;
    }

    public JSONObject getProjectTemplatesIndex() throws IOException {
        return this.getProjectTemplatesIndex(null);
    }

    public JSONObject getProjectTemplatesIndex(IUser user) throws IOException {
        JSONObject projectTemplatesObject = this._getProjectTemplatesIndex();
        if (projectTemplatesObject == null) {
            return null;
        }
        JSONObject returnObject = this.cloneJSONObject(projectTemplatesObject);
        if (user == null) {
            return returnObject;
        }
        try {
            IPerson person = user.getPerson();
            String userEmail = person.getEmail();
            JSONArray allTemplates = returnObject.getJSONArray("templates");
            JSONArray userTemplates = new JSONArray();
            int count = allTemplates.length();
            int i = 0;
            while (i < count) {
                JSONObject template = allTemplates.getJSONObject(i);
                String authorEmail = template.getString("authorEmail");
                String sharing = template.getString("sharingSimple");
                if (userEmail.equals(authorEmail) || this.enableProjectSharingAll.booleanValue() && sharing.equals("all")) {
                    userTemplates.put((Object)template);
                }
                ++i;
            }
            returnObject.put("templates", (Object)userTemplates);
            return returnObject;
        }
        catch (JSONException e) {
            String desc = "getProjectTemplatesIndex - json exception";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
    }

    public IStorage getProjectTemplatesIndexIStorage() {
        if (this.projectTemplatesIndexIStorage != null) {
            return this.projectTemplatesIndexIStorage;
        }
        try {
            IStorage projectTemplatesDirectory = this.getProjectTemplatesDirectory();
            this.projectTemplatesIndexIStorage = projectTemplatesDirectory.newInstance(projectTemplatesDirectory, "__index.json");
        }
        catch (IOException e) {
            String desc = "getProjectTemplates";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        return this.projectTemplatesIndexIStorage;
    }

    public Boolean getEnableProjectSharingAll() {
        return this.enableProjectSharingAll;
    }

    public String addProjectTemplate(IUser user, JSONObject params) {
        String projectTemplateName = null;
        String projectToClone = null;
        String sharingSimple = null;
        String timestamp = null;
        try {
            projectTemplateName = params.getString("projectTemplateName");
            projectToClone = params.getString("projectToClone");
            sharingSimple = params.getString("sharingSimple");
            timestamp = params.getString("timestamp");
        }
        catch (JSONException e) {
            String desc = "addProjectTemplate - params not valid json";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        if (projectTemplateName == null || projectTemplateName.equals("")) {
            return "No project template name specified";
        }
        if (!projectTemplateName.matches("^[\\p{L}\\d\\.\\-]+$")) {
            return "Invalid characters in project template name";
        }
        if (projectToClone == null || projectToClone.equals("")) {
            return "No project to clone specified";
        }
        IStorage userDir = user.getUserDirectory();
        IStorage projectDir = userDir.newInstance(projectToClone);
        if (!projectDir.exists()) {
            return "Invalid project name to clone - project does not exist";
        }
        try {
            JSONObject template;
            IStorage file;
            int i;
            IStorage[] files;
            IStorage projectTemplatesDirectory = this.getProjectTemplatesDirectory();
            IPerson person = user.getPerson();
            String email = person.getEmail();
            String templateFolderName = this.makeProjectTemplateFolderName(projectTemplateName, email);
            IStorage templateDir = projectTemplatesDirectory.newInstance(projectTemplatesDirectory, templateFolderName);
            if (templateDir.exists()) {
                files = templateDir.listFiles();
                i = 0;
                while (i < files.length) {
                    file = files[i];
                    if (file.isFile()) {
                        file.delete();
                    } else if (file.isDirectory()) {
                        this.deleteDirectory(file);
                    }
                    ++i;
                }
            } else {
                templateDir.mkdir();
            }
            files = projectDir.listFiles();
            i = 0;
            while (i < files.length) {
                file = files[i];
                String filename = file.getPath();
                Path path = new Path(filename);
                if (!file.isFile() || path.segmentCount() <= 0 || !path.segment(1).equals(".project")) {
                    IStorage destination;
                    if (file.isDirectory() && path.segmentCount() > 1 && path.segment(1).equals(".settings")) {
                        IStorage destinationDir = templateDir.newInstance(templateDir, ".settings");
                        destinationDir.mkdirs();
                        IStorage libsSettingsSource = file.newInstance(file, "libs.settings");
                        IStorage libsSettingsDestination = destinationDir.newInstance(destinationDir, "libs.settings");
                        this.copyFileStripWebContent(libsSettingsSource, libsSettingsDestination);
                    } else if (file.isDirectory() && path.segmentCount() > 1 && path.segment(1).equals("WebContent")) {
                        this.copyDirectory(file, templateDir);
                    } else if (file.isFile()) {
                        destination = templateDir.newInstance(templateDir, file.getName());
                        this.copyFile(file, destination);
                    } else if (file.isDirectory()) {
                        destination = templateDir.newInstance(templateDir, file.getName());
                        this.copyDirectory(file, destination);
                    }
                }
                ++i;
            }
            JSONObject projectTemplatesObject = this._getProjectTemplatesIndex();
            JSONArray oldTemplates = projectTemplatesObject.getJSONArray("templates");
            JSONArray newTemplates = new JSONArray();
            String oldCreationTimestamp = null;
            int count = oldTemplates.length();
            int i2 = 0;
            while (i2 < count) {
                template = oldTemplates.getJSONObject(i2);
                String folder = template.getString("folder");
                if (folder.equals(templateFolderName)) {
                    oldCreationTimestamp = template.getString("creationTimestamp");
                } else {
                    newTemplates.put((Object)template);
                }
                ++i2;
            }
            template = new JSONObject();
            template.put("folder", (Object)templateFolderName);
            template.put("name", (Object)projectTemplateName);
            template.put("authorEmail", (Object)email);
            template.put("clonedProject", (Object)projectToClone);
            template.put("sharingSimple", (Object)sharingSimple);
            template.put("creationTimestamp", (Object)(oldCreationTimestamp == null ? timestamp : oldCreationTimestamp));
            template.put("lastModifyTimestamp", (Object)timestamp);
            newTemplates.put((Object)template);
            this.updateTemplates(newTemplates);
        }
        catch (JSONException e) {
            String desc = "addProjectTemplate - json exception";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        catch (IOException e) {
            String desc = "IOException with createProjectTemplate";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String deleteProjectTemplates(IUser user, JSONArray templatesToDelete) {
        String errorString = null;
        IPerson person = user.getPerson();
        String email = person.getEmail();
        try {
            IStorage projectTemplatesDirectory = this.getProjectTemplatesDirectory();
            JSONObject projectTemplatesObject = this._getProjectTemplatesIndex();
            JSONArray existingTemplates = projectTemplatesObject.getJSONArray("templates");
            int count = templatesToDelete.length();
            int i = 0;
            while (i < count) {
                JSONObject templateToDelete = templatesToDelete.getJSONObject(i);
                int found = this.findTemplateInArray(existingTemplates, templateToDelete, email);
                if (found == -1) {
                    return "at least one template to delete not found";
                }
                ++i;
            }
            JSONArray newTemplates = new JSONArray();
            int existingCount = existingTemplates.length();
            int j = 0;
            while (j < existingCount) {
                JSONObject existingTemplate = existingTemplates.getJSONObject(j);
                String existingName = existingTemplate.getString("name");
                String existingEmail = existingTemplate.getString("authorEmail");
                Boolean found = false;
                int deleteCount = templatesToDelete.length();
                int i2 = 0;
                while (i2 < deleteCount) {
                    JSONObject templateToDelete = templatesToDelete.getJSONObject(i2);
                    String deleteName = templateToDelete.getString("name");
                    if (existingName.equals(deleteName) && existingEmail.equals(email)) {
                        found = true;
                        break;
                    }
                    ++i2;
                }
                if (found.booleanValue()) {
                    String existingFolderName = this.makeProjectTemplateFolderName(existingName, existingEmail);
                    IStorage existingFolder = projectTemplatesDirectory.newInstance(projectTemplatesDirectory, existingFolderName);
                    this.deleteDirectory(existingFolder);
                } else {
                    newTemplates.put((Object)existingTemplate);
                }
                ++j;
            }
            this.updateTemplates(newTemplates);
            return errorString;
        }
        catch (JSONException e) {
            String desc = "deleteProjectTemplates - json exception";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        catch (IOException e) {
            String desc = "IOException with deleteProjectTemplates";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String modifyProjectTemplates(IUser user, JSONArray templatesToModify) {
        String errorString = null;
        IPerson person = user.getPerson();
        String userEmail = person.getEmail();
        try {
            JSONObject projectTemplatesObject = this._getProjectTemplatesIndex();
            JSONArray existingTemplates = projectTemplatesObject.getJSONArray("templates");
            int count = templatesToModify.length();
            int i = 0;
            while (i < count) {
                JSONObject templateToModify = templatesToModify.getJSONObject(i);
                int found = this.findTemplateInArray(existingTemplates, templateToModify, userEmail);
                if (found == -1) {
                    return "at least one template to modify not found";
                }
                ++i;
            }
            IStorage projectTemplatesDirectory = this.getProjectTemplatesDirectory();
            JSONArray newTemplates = new JSONArray();
            int existingCount = existingTemplates.length();
            int j = 0;
            while (j < existingCount) {
                JSONObject existingTemplate = existingTemplates.getJSONObject(j);
                String existingName = existingTemplate.getString("name");
                String existingEmail = existingTemplate.getString("authorEmail");
                int modifyCount = templatesToModify.length();
                int i2 = 0;
                while (i2 < modifyCount) {
                    JSONObject templateToModify = templatesToModify.getJSONObject(i2);
                    String modifyName = templateToModify.getString("name");
                    if (existingName.equals(modifyName) && existingEmail.equals(userEmail)) {
                        String newSharingSimply;
                        String newName;
                        if (templateToModify.has("newName") && !(newName = templateToModify.getString("newName")).equals("") && newName != null) {
                            String existingFolderName = this.makeProjectTemplateFolderName(existingName, userEmail);
                            String newFolderName = this.makeProjectTemplateFolderName(newName, userEmail);
                            IStorage existingFolder = projectTemplatesDirectory.newInstance(projectTemplatesDirectory, existingFolderName);
                            IStorage newFolder = projectTemplatesDirectory.newInstance(projectTemplatesDirectory, newFolderName);
                            existingFolder.renameTo(newFolder);
                            existingTemplate.put("name", (Object)newName);
                            existingTemplate.put("folder", (Object)newFolderName);
                        }
                        if (templateToModify.has("sharingSimple") && !(newSharingSimply = templateToModify.getString("sharingSimple")).equals("") && newSharingSimply != null) {
                            existingTemplate.put("sharingSimple", (Object)(newSharingSimply.equals("all") ? "all" : "none"));
                        }
                    }
                    ++i2;
                }
                newTemplates.put((Object)existingTemplate);
                ++j;
            }
            this.updateTemplates(newTemplates);
            return errorString;
        }
        catch (JSONException e) {
            String desc = "modifyProjectTemplates - json exception";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        catch (IOException e) {
            String desc = "IOException with modifyProjectTemplates";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
    }

    public IStorage getProjectTemplatesDirectory() throws IOException {
        if (this.projectTemplatesDirectory != null) {
            return this.projectTemplatesDirectory;
        }
        IStorage baseDirectory = ServerManager.getServerManager().getBaseDirectory();
        this.projectTemplatesDirectory = baseDirectory.newInstance(baseDirectory, ".project-templates");
        if (!this.projectTemplatesDirectory.exists()) {
            this.projectTemplatesDirectory.mkdir();
        }
        return this.projectTemplatesDirectory;
    }

    private void updateTemplates(JSONArray newTemplates) {
        String indexFileContents;
        JSONObject projectTemplatesIndex;
        try {
            projectTemplatesIndex = this._getProjectTemplatesIndex();
            this.projectTemplatesDirectory = this.getProjectTemplatesDirectory();
        }
        catch (IOException e) {
            String desc = "updateTemplates - IOException";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        try {
            projectTemplatesIndex.put("templates", (Object)newTemplates);
            indexFileContents = projectTemplatesIndex.toString(2);
        }
        catch (JSONException e) {
            String desc = "updateTemplates - json exception";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(indexFileContents.getBytes());
            IStorage destination = this.getProjectTemplatesIndexIStorage();
            OutputStream out = null;
            try {
                int len;
                out = destination.getOutputStream();
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                if (in != null) {
                    ((InputStream)in).close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            String desc = "updateTemplates - IOException";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
    }

    private String makeProjectTemplateFolderName(String projectTemplateName, String authorEmail) {
        return String.valueOf(projectTemplateName) + "_" + authorEmail;
    }

    private int findTemplateInArray(JSONArray templateArray, JSONObject templateToMatch, String emailToMatch) {
        int found = -1;
        try {
            String nameToMatch = templateToMatch.getString("name");
            int count = templateArray.length();
            int i = 0;
            while (i < count) {
                JSONObject template = templateArray.getJSONObject(i);
                String name = template.getString("name");
                String email = template.getString("authorEmail");
                if (name.equals(nameToMatch) && email.equals(emailToMatch)) {
                    found = i;
                    break;
                }
                ++i;
            }
        }
        catch (JSONException e) {
            String desc = "findTemplateInArray - json exception";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        return found;
    }

    private String readFile(String path) throws IOException {
        FileInputStream stream = new FileInputStream(new File(path));
        try {
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            String string = Charset.defaultCharset().decode(bb).toString();
            return string;
        }
        finally {
            stream.close();
        }
    }

    private void copyDirectory(IStorage sourceDir, IStorage destinationDir) throws IOException {
        destinationDir.mkdirs();
        IStorage[] file = sourceDir.listFiles();
        int i = 0;
        while (i < file.length) {
            if (file[i].isFile()) {
                IStorage sourceFile = file[i];
                IStorage targetFile = destinationDir.newInstance(destinationDir, file[i].getName());
                this.copyFile(sourceFile, targetFile);
            }
            if (file[i].isDirectory()) {
                IStorage destination = destinationDir.newInstance(destinationDir, file[i].getName());
                this.copyDirectory(file[i], destination);
            }
            ++i;
        }
    }

    private void copyFile(IStorage source, IStorage destination) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            destination.getParentFile().mkdirs();
            in = source.getInputStream();
            out = destination.getOutputStream();
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private void copyFileStripWebContent(IStorage source, IStorage destination) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                String line;
                destination.getParentFile().mkdirs();
                in = source.getInputStream();
                out = destination.getOutputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(in, Charset.forName("UTF-8")));
                while ((line = br.readLine()) != null) {
                    String adjustedLine = line.replace("virtualRoot=\"WebContent/", "virtualRoot=\"");
                    int len = adjustedLine.length();
                    ByteBuffer bb = ByteBuffer.wrap(adjustedLine.getBytes());
                    out.write(bb.array(), 0, len);
                    out.write(10);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            String desc = "IOException with createProjectTemplate";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
    }

    private void deleteDirectory(IStorage dir) throws IOException {
        IStorage[] file = dir.listFiles();
        int i = 0;
        while (i < file.length) {
            if (file[i].isFile()) {
                IStorage f = file[i];
                f.delete();
            }
            if (file[i].isDirectory()) {
                this.deleteDirectory(file[i]);
            }
            ++i;
        }
        dir.delete();
    }

    private JSONObject cloneJSONObject(JSONObject originalObject) {
        JSONObject returnObject;
        try {
            String temp = originalObject.toString();
            returnObject = new JSONObject(temp);
        }
        catch (JSONException e) {
            String desc = "Project Templates index file - not a valid json file";
            theLogger.log(Level.SEVERE, desc, e);
            throw new Error(desc, e);
        }
        return returnObject;
    }
}

