/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import java.util.Locale;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitCredentialsProvider
extends UsernamePasswordCredentialsProvider {
    private URIish uri;
    private String knownHosts;
    private byte[] privateKey;
    private byte[] publicKey;
    private byte[] passphrase;

    public GitCredentialsProvider(URIish uri, String username, char[] password, String knownHosts) {
        super(username, password);
        this.uri = uri;
        this.knownHosts = knownHosts;
    }

    public URIish getUri() {
        return this.uri;
    }

    public String getKnownHosts() {
        return this.knownHosts;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getPassphrase() {
        return this.passphrase;
    }

    public void setUri(URIish uri) {
        this.uri = uri;
    }

    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public void setPassphrase(byte[] passphrase) {
        this.passphrase = passphrase;
    }

    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        CredentialItem[] credentialItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            CredentialItem item = credentialItemArray[n2];
            if (super.supports(new CredentialItem[]{item})) {
                super.get(uri, new CredentialItem[]{item});
            } else if (item instanceof CredentialItem.StringType) {
                if (item.getPromptText().toLowerCase(Locale.ENGLISH).contains("passphrase") && this.passphrase != null && this.passphrase.length > 0) {
                    ((CredentialItem.StringType)item).setValue(new String(this.passphrase));
                } else {
                    ((CredentialItem.StringType)item).setValue("");
                }
            } else if (item instanceof CredentialItem.CharArrayType) {
                ((CredentialItem.CharArrayType)item).setValue(new char[0]);
            } else {
                throw new UnsupportedCredentialItem(uri, item.getPromptText());
            }
            ++n2;
        }
        return true;
    }
}

