/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.UserInfo;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.CredentialsProviderUserInfo;
import org.eclipse.jgit.transport.JschSession;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.orion.server.git.GitCredentialsProvider;
import org.eclipse.orion.server.jsch.SessionHandler;

public class GitSshSessionFactory
extends SshSessionFactory {
    private static final int SSH_PORT = 22;

    public RemoteSession getSession(URIish uri, CredentialsProvider credentialsProvider, FS fs, int tms) throws TransportException {
        int port = uri.getPort();
        String user = uri.getUser();
        String pass = uri.getPass();
        if (credentialsProvider instanceof GitCredentialsProvider) {
            CredentialItem.Password p;
            CredentialItem.Username u;
            if (port <= 0) {
                port = 22;
            }
            GitCredentialsProvider cp = (GitCredentialsProvider)credentialsProvider;
            if (user == null && cp.supports(new CredentialItem[]{u = new CredentialItem.Username()}) && cp.get(cp.getUri(), new CredentialItem[]{u})) {
                user = u.getValue();
            }
            if (pass == null && cp.supports(new CredentialItem[]{p = new CredentialItem.Password()}) && cp.get(cp.getUri(), new CredentialItem[]{p})) {
                pass = new String(p.getValue());
            }
            try {
                SessionHandler session = new SessionHandler(user, uri.getHost(), port, cp.getKnownHosts(), cp.getPrivateKey(), cp.getPublicKey(), cp.getPassphrase());
                if (pass != null) {
                    session.setPassword(pass);
                }
                if (credentialsProvider != null && !credentialsProvider.isInteractive()) {
                    session.setUserInfo((UserInfo)new CredentialsProviderUserInfo(session.getSession(), credentialsProvider));
                }
                session.connect(tms);
                return new JschSession(session.getSession(), uri);
            }
            catch (JSchException e) {
                throw new TransportException(uri, e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

