/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.api.ApplyCommand;
import org.eclipse.jgit.api.DiffCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.PatchApplyException;
import org.eclipse.jgit.api.errors.PatchFormatException;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.resources.UniversalUniqueIdentifier;
import org.eclipse.orion.server.git.objects.Diff;
import org.eclipse.orion.server.git.servlets.AbstractGitHandler;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONObject;

public class GitDiffHandlerV1
extends AbstractGitHandler {
    private static final String EOL = "\r\n";
    private ServletResourceHandler<IStatus> statusHandler;
    private HttpClient httpClient;

    GitDiffHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        super(statusHandler);
    }

    @Override
    protected boolean handleGet(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        String pattern;
        String parts;
        Repository db;
        HttpServletResponse response;
        HttpServletRequest request;
        String gitSegment;
        block5: {
            gitSegment = requestInfo.gitSegment;
            request = requestInfo.request;
            response = requestInfo.response;
            db = requestInfo.db;
            String relativePath = requestInfo.relativePath;
            try {
                parts = request.getParameter("parts");
                pattern = relativePath;
                String string = pattern = pattern.isEmpty() ? null : pattern;
                if (parts == null || "uris,diff".equals(parts) || "diff,uris".equals(parts)) {
                    return this.handleMultiPartGet(request, response, db, gitSegment, pattern);
                }
                if (!"uris".equals(parts)) break block5;
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)new Diff(GitDiffHandlerV1.getURI((HttpServletRequest)request), db).toJSON());
                return true;
            }
            catch (Exception e) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured while getting a diff.", (Throwable)e));
            }
        }
        if ("diff".equals(parts)) {
            return this.handleGetDiff(request, response, db, gitSegment, pattern, (OutputStream)response.getOutputStream());
        }
        return false;
    }

    private boolean handleGetDiff(HttpServletRequest request, HttpServletResponse response, Repository db, String scope, String pattern, OutputStream out) throws Exception {
        Object oldTree;
        Git git = new Git(db);
        DiffCommand diff = git.diff();
        diff.setOutputStream((OutputStream)new BufferedOutputStream(out));
        FileTreeIterator newTree = new FileTreeIterator(db);
        if (scope.contains("..")) {
            String[] commits = scope.split("\\.\\.");
            if (commits.length != 2) {
                String msg = NLS.bind((String)"Failed to generate diff for {0}", (Object)scope);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
            }
            oldTree = this.getTreeIterator(db, commits[0]);
            newTree = this.getTreeIterator(db, commits[1]);
        } else if (scope.equals("Cached")) {
            ObjectId head = db.resolve("HEAD^{tree}");
            if (head == null) {
                String msg = NLS.bind((String)"Failed to generate diff for {0}, no HEAD", (Object)scope);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, msg, null));
            }
            CanonicalTreeParser p = new CanonicalTreeParser();
            ObjectReader reader = db.newObjectReader();
            try {
                p.reset(reader, (AnyObjectId)head);
            }
            finally {
                reader.release();
            }
            oldTree = p;
            newTree = new DirCacheIterator(db.readDirCache());
        } else {
            oldTree = scope.equals("Default") ? new DirCacheIterator(db.readDirCache()) : this.getTreeIterator(db, scope);
        }
        String[] paths = request.getParameterValues("Path");
        Object filter = null;
        PathFilter pathFilter = null;
        if (paths != null) {
            if (paths.length > 1) {
                HashSet<PathFilter> pathFilters = new HashSet<PathFilter>(paths.length);
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String path = stringArray[n2];
                    pathFilters.add(PathFilter.create((String)path));
                    ++n2;
                }
                pathFilter = OrTreeFilter.create(pathFilters);
            } else if (paths.length == 1) {
                pathFilter = PathFilter.create((String)paths[0]);
            }
        }
        if (pattern != null) {
            PathFilter patternFilter = PathFilter.create((String)pattern);
            filter = pathFilter != null ? AndTreeFilter.create((TreeFilter)patternFilter, (TreeFilter)pathFilter) : patternFilter;
        } else {
            filter = pathFilter;
        }
        if (filter != null) {
            diff.setPathFilter((TreeFilter)filter);
        }
        diff.setOldTree(oldTree);
        diff.setNewTree((AbstractTreeIterator)newTree);
        diff.call();
        return true;
    }

    private boolean handleMultiPartGet(HttpServletRequest request, HttpServletResponse response, Repository db, String scope, String pattern) throws Exception {
        String boundary = this.createBoundaryString();
        response.setHeader("Content-Type", "multipart/related; boundary=\"" + boundary + '\"');
        ServletOutputStream outputStream = response.getOutputStream();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outputStream);
        try {
            out.write("--" + boundary + EOL);
            out.write("Content-Type: application/json; charset=UTF-8\r\n\r\n");
            ((Writer)out).flush();
            JSONObject getURIs = new Diff(GitDiffHandlerV1.getURI((HttpServletRequest)request), db).toJSON();
            out.write(getURIs.toString());
            out.write("\r\n--" + boundary + EOL);
            out.write("Content-Type: plain/text\r\n\r\n");
            ((Writer)out).flush();
            this.handleGetDiff(request, response, db, scope, pattern, (OutputStream)outputStream);
            out.write(EOL);
            ((Writer)out).flush();
        }
        finally {
            IOUtilities.safeClose((Closeable)out);
        }
        return true;
    }

    private String createBoundaryString() {
        return new UniversalUniqueIdentifier().toBase64String();
    }

    @Override
    protected boolean handlePost(AbstractGitHandler.RequestInfo requestInfo) throws ServletException {
        HttpServletRequest request = requestInfo.request;
        HttpServletResponse response = requestInfo.response;
        Repository db = requestInfo.db;
        String contentType = request.getHeader("Content-Type");
        if (contentType.startsWith("multipart")) {
            return this.applyPatch(request, response, db, contentType);
        }
        return this.identifyNewDiffResource(request, response);
    }

    private boolean applyPatch(HttpServletRequest request, HttpServletResponse response, Repository db, String contentType) throws ServletException {
        try {
            String patch = this.readPatch(request.getInputStream(), contentType);
            Git git = new Git(db);
            ApplyCommand applyCommand = git.apply();
            applyCommand.setPatch(IOUtilities.toInputStream((String)patch));
            try {
                applyCommand.call();
            }
            catch (PatchFormatException patchFormatException) {
            }
            catch (PatchApplyException patchApplyException) {}
            response.setStatus(201);
            response.setContentType("text/html;charset=UTF-8");
            response.getOutputStream().write(new String("<head></head><body><textarea>{}</textarea></body>").getBytes());
            return true;
        }
        catch (Exception e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when applying a patch.", (Throwable)e));
        }
    }

    private boolean identifyNewDiffResource(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            StringWriter writer = new StringWriter();
            IOUtilities.pipe((Reader)request.getReader(), (Writer)writer, (boolean)false, (boolean)false);
            JSONObject requestObject = new JSONObject(writer.toString());
            URI u = GitDiffHandlerV1.getURI((HttpServletRequest)request);
            Path p = new Path(u.getPath());
            Path np = new Path("/");
            int i = 0;
            while (i < p.segmentCount()) {
                String s = p.segment(i);
                if (i == 2) {
                    s = String.valueOf(s) + "..";
                    s = String.valueOf(s) + GitUtils.encode(requestObject.getString("New"));
                }
                np = np.append(s);
                ++i;
            }
            if (p.hasTrailingSeparator()) {
                np = np.addTrailingSeparator();
            }
            URI nu = new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), np.toString(), u.getQuery(), u.getFragment());
            JSONObject result = new JSONObject();
            result.put("Location", (Object)nu.toString());
            OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
            response.setHeader("Location", nu.toString());
            return true;
        }
        catch (Exception e) {
            return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, "An error occured when identifying a new Diff resource.", (Throwable)e));
        }
    }

    private String readPatch(ServletInputStream requestStream, String contentType) throws IOException {
        int boundaryOff = contentType.indexOf("boundary=");
        String boundary = contentType.substring(boundaryOff + "boundary=".length(), contentType.length());
        Map parts = IOUtilities.parseMultiPart((InputStream)requestStream, (String)boundary);
        if ("fileRadio".equals(parts.get("radio"))) {
            return (String)parts.get("uploadedfile");
        }
        if ("urlRadio".equals(parts.get("radio"))) {
            return this.fetchPatchContentFromUrl((String)parts.get("url"));
        }
        return null;
    }

    private String fetchPatchContentFromUrl(String url) throws IOException {
        GetMethod m = new GetMethod(url);
        this.getHttpClient().executeMethod((HttpMethod)m);
        if (m.getStatusCode() == 200) {
            return IOUtilities.toString((InputStream)m.getResponseBodyAsStream());
        }
        return null;
    }

    private HttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = new HttpClient();
        }
        return this.httpClient;
    }

    private AbstractTreeIterator getTreeIterator(Repository db, String name) throws IOException {
        ObjectId id = db.resolve(name);
        if (id == null) {
            throw new IllegalArgumentException(name);
        }
        CanonicalTreeParser p = new CanonicalTreeParser();
        ObjectReader or = db.newObjectReader();
        try {
            p.reset(or, (AnyObjectId)new RevWalk(db).parseTree((AnyObjectId)id));
            CanonicalTreeParser canonicalTreeParser = p;
            return canonicalTreeParser;
        }
        finally {
            or.release();
        }
    }
}

