/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.xfer;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.orion.internal.server.core.IOUtilities;
import org.eclipse.orion.internal.server.servlets.xfer.SFTPTransferJob;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SFTPImportJob
extends SFTPTransferJob {
    public SFTPImportJob(String userRunningTask, File destination, String host, int port, IPath sourcePath, String user, String passphrase, List<String> options) {
        super(userRunningTask, destination, host, port, sourcePath, user, passphrase, options);
    }

    protected void doTransferDirectory(ChannelSftp channel, IPath remotePath, SftpATTRS remoteAttributes, File localFile) throws SftpException, IOException {
        localFile.mkdirs();
        Vector remoteChildren = channel.ls(remotePath.toString());
        this.addTaskTotal(remoteChildren.size());
        for (ChannelSftp.LsEntry remoteChild : remoteChildren) {
            String childName = remoteChild.getFilename();
            if (this.shouldSkip(childName)) {
                this.taskItemLoaded();
                continue;
            }
            File localChild = new File(localFile, childName);
            if (remoteChild.getAttrs().isDir()) {
                this.doTransferDirectory(channel, remotePath.append(childName), remoteChild.getAttrs(), localChild);
            } else {
                this.doTransferFile(channel, remotePath.append(childName), remoteChild.getAttrs(), localChild);
            }
            this.taskItemLoaded();
        }
        this.synchronizeTimestamp(remoteAttributes, localFile);
    }

    protected void doTransferFile(ChannelSftp channel, IPath remotePath, SftpATTRS remoteAttributes, File localFile) throws IOException, SftpException {
        if (this.shouldSkip(remotePath, remoteAttributes, localFile)) {
            return;
        }
        IOUtilities.pipe((InputStream)channel.get(remotePath.toString()), (OutputStream)new FileOutputStream(localFile), (boolean)true, (boolean)true);
        this.synchronizeTimestamp(remoteAttributes, localFile);
    }

    private boolean shouldSkip(IPath remotePath, SftpATTRS remoteAttributes, File localFile) throws IOException {
        if (this.getOptions().contains("no-overwrite") && localFile.exists()) {
            IPath localPath = remotePath.removeFirstSegments(this.remoteRoot.segmentCount());
            throw new IOException(NLS.bind((String)"Local file exists: {0}", (Object)localPath.toString()));
        }
        int localMTime = (int)(localFile.lastModified() / 1000L);
        int remoteMTime = remoteAttributes.getMTime();
        if (this.getOptions().contains("overwrite-older") && localMTime > remoteMTime) {
            return true;
        }
        return localMTime == remoteMTime && localFile.length() == remoteAttributes.getSize();
    }

    private void synchronizeTimestamp(SftpATTRS remoteAttributes, File localFile) {
        localFile.setLastModified((long)remoteAttributes.getMTime() * 1000L);
    }

    @Override
    protected void transferDirectory(ChannelSftp channel, IPath remotePath, File localFile) throws SftpException, IOException {
        SftpATTRS attrs = channel.stat(remotePath.toString());
        this.doTransferDirectory(channel, remotePath, attrs, localFile);
    }
}

