/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.servlets;

import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JsonURIUnqualificationStrategy {
    public static final JsonURIUnqualificationStrategy ALL = new JsonURIUnqualificationStrategy(){

        protected URI unqualifyObjectProperty(String key, URI uri, String scheme, String hostname, int port) {
            return 1.unqualifyURI(uri, scheme, hostname, port);
        }

        protected URI unqualifyArrayValue(int index, URI uri, String scheme, String hostname, int port) {
            return 1.unqualifyURI(uri, scheme, hostname, port);
        }
    };
    public static final JsonURIUnqualificationStrategy LOCATION_ONLY = new JsonURIUnqualificationStrategy(){

        protected URI unqualifyObjectProperty(String key, URI uri, String scheme, String hostname, int port) {
            if (!"Location".equals(key)) {
                return uri;
            }
            return 2.unqualifyURI(uri, scheme, hostname, port);
        }

        protected URI unqualifyArrayValue(int index, URI uri, String scheme, String hostname, int port) {
            return uri;
        }
    };

    public void run(HttpServletRequest req, JSONObject result) {
        this.rewrite(result, req.getScheme(), req.getServerName(), req.getServerPort());
    }

    private void rewrite(JSONObject json, String scheme, String hostname, int port) {
        String[] names = JSONObject.getNames((JSONObject)json);
        if (names == null) {
            return;
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Object o = json.opt(name);
            if (o instanceof URI) {
                try {
                    json.put(name, (Object)this.unqualifyObjectProperty(name, (URI)o, scheme, hostname, port));
                }
                catch (JSONException jSONException) {}
            } else if (o instanceof String) {
                String string = (String)o;
                if (string.startsWith(scheme)) {
                    try {
                        json.put(name, (Object)this.unqualifyObjectProperty(name, new URI(string), scheme, hostname, port));
                    }
                    catch (JSONException jSONException) {
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
            } else {
                this.rewrite(o, scheme, hostname, port);
            }
            ++n2;
        }
    }

    private void rewrite(Object o, String scheme, String hostname, int port) {
        if (o instanceof JSONObject) {
            this.rewrite((JSONObject)o, scheme, hostname, port);
        } else if (o instanceof JSONArray) {
            JSONArray a = (JSONArray)o;
            int i = 0;
            while (i < a.length()) {
                Object v = a.opt(i);
                if (v instanceof URI) {
                    try {
                        a.put(i, (Object)this.unqualifyArrayValue(i, (URI)v, scheme, hostname, port));
                    }
                    catch (JSONException jSONException) {}
                } else if (v instanceof String) {
                    String string = (String)v;
                    if (string.startsWith(scheme)) {
                        try {
                            a.put(i, (Object)this.unqualifyArrayValue(i, new URI(string), scheme, hostname, port));
                        }
                        catch (JSONException jSONException) {
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                } else {
                    this.rewrite(v, scheme, hostname, port);
                }
                ++i;
            }
        }
    }

    protected abstract URI unqualifyObjectProperty(String var1, URI var2, String var3, String var4, int var5);

    protected abstract URI unqualifyArrayValue(int var1, URI var2, String var3, String var4, int var5);

    protected static URI unqualifyURI(URI uri, String scheme, String hostname, int port) {
        URI simpleURI = uri;
        int uriPort = uri.getPort();
        if (uriPort == -1) {
            uriPort = 80;
        }
        if (scheme.equals(uri.getScheme()) && hostname.equals(uri.getHost()) && port == uriPort) {
            try {
                simpleURI = new URI(null, null, null, -1, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                simpleURI = uri;
            }
        }
        return simpleURI;
    }
}

