require({cache:{
'davinci/review/actions/CloseVersionAction':function(){
define([
	"dojo/_base/declare",
	"./_ReviewNavigatorCommon",
	"davinci/Runtime",
	"dojox/widget/Toaster",
	"dojo/i18n!./nls/actions"
], function(declare, _ReviewNavigatorCommon, Runtime, Toaster, nls) {

var CloseVersionAction = declare("davinci.review.actions.CloseVersionAction", [_ReviewNavigatorCommon], {

	run: function(context) {
		var selection = this._getSelection(context);
		if (!selection || !selection.length) { return; }
		okToClose=confirm(nls.areYouSureClose);
		if (!okToClose) { 
			return;
		}
		var item = selection[0].resource.elementType=="ReviewFile"?selection[0].resource.parent:selection[0].resource;
		dojo.xhrGet({
			url: "cmd/managerVersion",
			sync:false,
			handleAs:"text",
			content:{
				'type' :'close',
				'vTime':item.timeStamp
			}
		}).then(function (result) {
			if (result=="OK") {
				if (typeof hasToaster == "undefined") {
					new Toaster({
						position: "br-left",
						duration: 4000,
						messageTopic: "/davinci/review/resourceChanged"
					});
					hasToaster = true;
				}
				dojo.publish("/davinci/review/resourceChanged", [{message:nls.closeSuccessful, type:"message"},"closed",item]);
			}
		});
	},

	isEnabled: function(context) {
		var selection = this._getSelection(context);
		if (!selection || selection.length == 0) { 
			return false;
		}
		var item = selection[0].resource.elementType=="ReviewFile"?selection[0].resource.parent:selection[0].resource;
		if (item.designerId == Runtime.userName) { 
			//Only enable if the current user is also the review's designer
			if (!item.closed&&!item.isDraft) { 
				return true; 
			}
		}
		return false;
	}

});

return CloseVersionAction;

});
},
'davinci/review/Review':function(){
define([
	"davinci/Runtime",
	"./Color"
], function(Runtime, Color) {

return {
	getColor: function(/*string*/ email) {
		var index;
		dojo.some(Runtime.reviewers, function(item, n) {
			if (item.email == email) {
				index = n;
				return true;
			}
			return false;
		});
		return Color.colors[index];
	}
};
});
},
'davinci/review/drawing/shapes/Arrow':function(){
define([
	"dojo/_base/declare",
	"./_ShapeCommon"
], function(declare, _ShapeCommon) {
	
return declare("davinci.review.drawing.shapes.Arrow", _ShapeCommon, {

	render: function() {
		if (!this.shapeNode) {
			this._createArrowBody();
			this._createArrowHead();
			this._evtConns.push(
				dojo.connect(this.shapeNode, "mouseover", this, "onMouseOver"),
				dojo.connect(this.shapeNode, "mouseout", this, "onMouseOut"),
				dojo.connect(this.shapeNode, "mousedown", this, "onMouseDown")
			);
		}
		this._transformArrowBody();
		this._transformArrowhead();
		this.inherited(arguments);
	},

	destroy: function() {
		this._triangle.right = this._triangle.left = null;
		this.inherited(arguments);
	},

	_createArrowBody: function() {
		this.shapeNode = dojo.create("div");
		dojo.style(this.shapeNode, {
			"position": "absolute",
			"padding": "0px",
			"margin": "0px",
			"border": "1px solid " + this.color,
			"height": "0px",
			"MozTransformOrigin": "0 0",
			"WebkitTransformOrigin": "0 0"
		});
	},

	_createArrowHead: function() {
		this._triangle = {};
		this._triangle.left = dojo.create("div", null, this.shapeNode);
		dojo.style(this._triangle.left, {
			"position": "absolute",
			"top": "-1px",
			"padding": "0px",
			"margin": "0px",
			"border": "1px solid " + this.color,
			"height": "0px",
			"width": "15px",
			"MozTransformOrigin": "100% 100%",
			"WebkitTransformOrigin": "100% 100%",
			"MozTransform": "rotate(15deg)",
			"WebkitTransform": "rotate(15deg)"
		});
		this._triangle.right = dojo.create("div", null, this.shapeNode);
		dojo.style(this._triangle.right, {
			"position": "absolute",
			"top": "-1px",
			"padding": "0px",
			"margin": "0px",
			"border": "1px solid " + this.color,
			"height": "0px",
			"width": "15px",
			"MozTransformOrigin": "100% 100%",
			"WebkitTransformOrigin": "100% 100%",
			"MozTransform": "rotate(-15deg)",
			"WebkitTransform": "rotate(-15deg)"
		});
	},

	_transformArrowBody: function() {
		this.angle = 90 - (180 / Math.PI) * Math.atan((this.x1 - this.x2)/(this.y1 - this.y2));
		if (isNaN(this.angle)) { 
			this.angle = 0;
		}
		if (this.y2 <= this.y1) {
			this.angle = this.angle + 180;
		}
		this.length = Math.sqrt(Math.pow(this.x1 - this.x2, 2) + Math.pow(this.y1 - this.y2, 2));
		dojo.style(this.shapeNode, {
			"left": this.x1 + "px",
			"top": this.y1 + "px",
			"width": this.length + "px",
			"MozTransformOrigin": "0 0",
			"WebkitTransformOrigin": "0 0",
			"MozTransform": "rotate(" + this.angle + "deg)",
			"WebkitTransform": "rotate(" + this.angle + "deg)"
		});
	},

	_transformArrowhead: function() {
		dojo.style(this._triangle.left, {
			"left": this.length - 17 + "px"
		});
		dojo.style(this._triangle.right, {
			"left": this.length - 17 + "px"
		});
	}

});
});

},
'davinci/review/drawing/tools/scaffolds/ArrowScaffold':function(){
define([
	"dojo/_base/declare",
	"./_ScaffoldCommon"
], function(declare, _ScaffoldCommon) {
	
return declare("davinci.review.drawing.tools.scaffolds.ArrowScaffold", _ScaffoldCommon, {

	constructor: function(surface) {
		this.tailHandler = this._createHandler("sw");
		this.headHandler = this._createHandler("ne");
		this._evtConns = [
		    dojo.connect(this.tailHandler, "mousedown", this, "onHandlerMouseDown"),
		    dojo.connect(this.headHandler, "mousedown", this, "onHandlerMouseDown")
		];
	},

	createShape: function(x, y, attributeMap) {
		this.shape = new davinci.review.drawing.shapes.Arrow(this.surface, x, y, x + 1, y + 1, attributeMap);
		this.inherited(arguments);
		return this.shape;
	},

	transformShape: function(x, y) {
		if (this.shape) {
			this.shape.x2 = x;
			this.shape.y2 = y;
		}
		this.inherited(arguments);
	},

	wrapShape: function(shape, /*Boolean*/ isRewrap) {
		this.inherited(arguments);
		dojo.style(this.tailHandler, { "left": shape.x1 - 3 + "px", "top": shape.y1 - 3 + "px" });
		dojo.style(this.headHandler, { "left": shape.x2 - 3 + "px", "top": shape.y2 - 3 + "px" });
		if (!isRewrap) {
			this.surface.appendChild(this.tailHandler);
			this.surface.appendChild(this.headHandler);
		}
	},

	destroy: function() {
		dojo.destroy(this.tailHandler);
		dojo.destroy(this.headHandler);
		this.tailHandler = this.headHandler = null;
		this.inherited(arguments);
	},

	onHandlerMouseMove: function(evt) {
		if (this.activeHandler.position == "sw") {
			this.shape.x1 = evt.pageX;
			this.shape.y1 = evt.pageY;
		} else {
			this.shape.x2 = evt.pageX;
			this.shape.y2 = evt.pageY;
		}
		this.inherited(arguments);
	}

});
});

},
'davinci/review/Color':function(){
define({
	colors:[
	        "firebrick",
	        "darkblue",
	        "darkgreen",
	        "purple",
	        "darkorange",
	        "darkgoldenrod",
	        "brown",
	        "darkgrey",
	        "darkcyan",
	        "deeppink"
	        ]
});

},
'davinci/review/actions/OpenVersionAction':function(){
define([
	"dojo/_base/declare",
	"./_ReviewNavigatorCommon",
	"davinci/Runtime",
	"dojox/widget/Toaster",
	"dojo/i18n!./nls/actions"
], function(declare, _ReviewNavigatorCommon, Runtime, Toaster, nls) {

var OpenVersionAction = declare("davinci.review.actions.OpenVersionAction", [_ReviewNavigatorCommon], {

	run: function(context) {
		var selection = this._getSelection(context);
		if (!selection || !selection.length)  { 
			return;
		}
		var item = selection[0].resource.elementType=="ReviewFile"?selection[0].resource.parent:selection[0].resource;
		dojo.xhrGet({
			url: "cmd/managerVersion",
			sync:false,
			handleAs:"text",
			content:{
				'type' :'open',
				'vTime':item.timeStamp}
		}).then(function (result) {
			if (result=="OK") {
				if (typeof hasToaster == "undefined") {
					new Toaster({
						position: "br-left",
						duration: 4000,
						messageTopic: "/davinci/review/resourceChanged"
					});
					hasToaster = true;
				}
				dojo.publish("/davinci/review/resourceChanged", [{message:nls.openSuccessful, type:"message"},"open",item]);
			}
		});
	},

	isEnabled: function(context) {
		var selection = this._getSelection(context);
		if (!selection || selection.length == 0) { 
			return false;
		}
		var item = selection[0].resource.elementType=="ReviewFile"?selection[0].resource.parent:selection[0].resource;
		if (item.designerId == Runtime.userName) { 
			//Only enable if the current user is also the review's designer
			if (item.closed&&item.closedManual&&!item.isDraft) { 
				return true;
			}
		}
		return false;
	}
});

return OpenVersionAction;

});
},
'davinci/review/drawing/tools/scaffolds/RectangleScaffold':function(){
define([
	"dojo/_base/declare",
	"./_ScaffoldCommon",
	"davinci/review/drawing/shapes/Rectangle"
], function(declare, _ScaffoldCommon, Rectangle) {
	
return declare("davinci.review.drawing.tools.scaffolds.RectangleScaffold", _ScaffoldCommon, {

	constructor: function(surface) {
		this.nwh = this._createHandler("nw");
		this.neh = this._createHandler("ne");
		this.seh = this._createHandler("se");
		this.swh = this._createHandler("sw");
		this._evtConns = [
			dojo.connect(this.nwh, "mousedown", this, "onHandlerMouseDown"),
			dojo.connect(this.neh, "mousedown", this, "onHandlerMouseDown"),
			dojo.connect(this.seh, "mousedown", this, "onHandlerMouseDown"),
			dojo.connect(this.swh, "mousedown", this, "onHandlerMouseDown")
		];
	},

	createShape: function(x, y, attributeMap) {
		this.shape = new Rectangle(this.surface, x, y, x + 1, y + 1, attributeMap);
		this.anchorPoint = {x: x, y: y};
		this.inherited(arguments);
		return this.shape;
	},

	transformShape: function(x, y) {
		this._transform(x, y);
		this.inherited(arguments);
	},

	wrapShape: function(shape, /*Boolean*/ isRewrap) {
		this.inherited(arguments);
		dojo.style(this.nwh, {"left": shape.x1 + "px", "top": shape.y1 + "px"});
		dojo.style(this.neh, {"left": shape.x2 + "px", "top": shape.y1 + "px"});
		dojo.style(this.seh, {"left": shape.x2 + "px", "top": shape.y2 + "px"});
		dojo.style(this.swh, {"left": shape.x1 + "px", "top": shape.y2 + "px"});
		if (!isRewrap) {
			this.surface.appendChild(this.nwh);
			this.surface.appendChild(this.neh);
			this.surface.appendChild(this.seh);
			this.surface.appendChild(this.swh);
		}
	},

	destroy: function() {
		dojo.destroy(this.nwh);
		dojo.destroy(this.neh);
		dojo.destroy(this.seh);
		dojo.destroy(this.swh);
		this.inherited(arguments);
	},

	onHandlerMouseMove: function(evt) {
		this._transform(evt.pageX, evt.pageY);
		this.inherited(arguments);
	},

	_transform: function(x, y) {
		var anchorPoint = this.anchorPoint, shape = this.shape;
		if (anchorPoint.x < x && anchorPoint.y < y) {
			this.anchorPoint = {x: shape.x1, y: shape.y1};
			shape.x2 = x; shape.y2 = y;
		} else if(anchorPoint.x > x && anchorPoint.y < y) {
			this.anchorPoint = {x: shape.x2, y: shape.y1};
			shape.x1 = x; shape.y2 = y;
		} else if(anchorPoint.x > x && anchorPoint.y > y) {
			this.anchorPoint = {x: shape.x2, y: shape.y2};
			shape.x1 = x; shape.y1 = y;
		} else if(anchorPoint.x < x && anchorPoint.y > y) {
			this.anchorPoint = {x: shape.x1, y: shape.y2};
			shape.x2 = x; shape.y1 = y;
		}
	}

});
});

},
'davinci/review/drawing/tools/SelectTool':function(){
define([
	"dojo/_base/declare",
	"./_ToolCommon",
	"./scaffolds/scaffolds",
	"../shapes/shapes"
], function(declare, _ToolCommon, scaffolds, shapes) {
	
return declare("davinci.review.drawing.tools.SelectTool", _ToolCommon, {

	constructor: function(surface, filterAttributes) {
		surface.selectTool = this;
	},

	hasPermission: function(shape) {
		var surface = this.surface, secAttrs = this.filterAttributes;
		return dojo.every(secAttrs, function(attr) {
			return shape[attr] && surface[attr] && shape[attr] == surface[attr];
		});
	},

	selectShape: function(shape, /*Boolean*/ isReselect, /*Point*/ clickPoint) {
		this.deselectShape(); // Deselect the previous one first
		this.shape = shape;
		if (!isReselect) {
			if (shape.isInstanceOf(shapes.Arrow)) {
				this.scaffold = new scaffolds.ArrowScaffold(this.surface);
			} else if(shape.isInstanceOf(shapes.Rectangle)) {
				this.scaffold = new scaffolds.RectangleScaffold(this.surface);
			} else if(shape.isInstanceOf(shapes.Ellipse)) {
				this.scaffold = new scaffolds.EllipseScaffold(this.surface);
			} else if(shape.isInstanceOf(shapes.Text)) {
				this.scaffold = new scaffolds.TextScaffold(this.surface);
			} else {
				new Error("Invalid shape type!");
			}
		}
		this.scaffold.wrapShape(shape, isReselect, clickPoint);
		dojo.publish("/davinci/review/drawing/selectshape", [shape, this.surface]);
	},

	deselectShape: function() {
		if (this.scaffold) { 
			this.scaffold.destroy();
		}
		var shape = this.shape;
		this.scaffold = this.shape = null;
		dojo.publish("/davinci/review/drawing/deselectshape", [shape, this.surface]);
	},

	removeShape: function() {
		if (this.scaffold) {
			this.scaffold.removeShape();
		}
		this.deselectShape(); //we want to fire a selection changed event
	},

	activate: function() {
		this._evtSubs = [
			dojo.subscribe("/davinci/review/drawing/shapemouseover", this, "_onShapeMouseOver"),
			dojo.subscribe("/davinci/review/drawing/shapemouseout", this, "_onShapeMouseOut"),
			dojo.subscribe("/davinci/review/drawing/shapemousedown", this, "_onShapeMouseDown")
		];
		this._evtConns = [
			dojo.connect(this.surface.domNode, "mousedown", this, "deselectShape")
		];
	},

	_onShapeMouseOver: function(shape, evt, surface) {
		if (this.surface === surface && !this.surface.isDrawing && !shape.editable && this.hasPermission(shape)) {
			shape.style({"cursor": "move"});
		}
	},

	_onShapeMouseOut: function(shape, evt, surface) {
		if (this.surface === surface && !this.surface.isDrawing && !shape.editable && this.hasPermission(shape)) {
			shape.style({"cursor": ""});
		}
	},

	_onShapeMouseDown: function(shape, evt, surface) {
		// If the shape is in edit mode, not need to bother the select action
		if (this.surface === surface && !this.surface.isDrawing && !shape.editable && this.hasPermission(shape)) {
			dojo.stopEvent(evt);
			this.selectShape(shape, false, {x: evt.pageX, y: evt.pageY});
		}
	},

	deactivate: function() {
		this.deselectShape();
		this.inherited(arguments);
	}

});
});

},
'davinci/review/drawing/shapes/_ShapeCommon':function(){
define("davinci/review/drawing/shapes/_ShapeCommon", [
	"dojo/_base/declare"
], function(declare){
	
return declare("davinci.review.drawing.shapes._ShapeCommon", null, {

	constructor: function(surface, x1, y1, x2, y2, attributeMap) {
		this.surface = surface;
		this.x1 = x1 || 0;
		this.y1 = y1 || 0;
		this.x2 = x2 || 0;
		this.y2 = y2 || 0;
		this._evtConns = [];

		// this.a2c, this.color are not parts of attributeMap
		if (attributeMap.a2c && typeof attributeMap.a2c == "function") {
			this.color = attributeMap.a2c(attributeMap.colorAlias);
			delete attributeMap.a2c;
		}

		this.attributeMap = attributeMap;
		dojo.mixin(this, attributeMap);

		if (!this.color) { 
			this.color = "black";
		}
	},

	setVisible: function(visible) {
		if (visible == "visible") {
			this.style({"visibility": "visible", "opacity": "1.0"});
		} else if (visible == "partial") {
			this.style({"visibility": "visible", "opacity": "0.1"});
		} else if (visible == "hidden") {
			this.style({"visibility": "hidden", "opacity": "1.0"});
		}
	},

	style: function(style) {
		var context = this.surface && this.surface.context;
		if(!context || !context._domIsReady){
			return;
		}
/* 20120503 - Delete this setTimeout code below if we don't notice any redraw problems
		//FIXME: Quick hack before Preview 4. For some reason, sometimes this.shapeNode doesn't yet
		// have a defaultView at this point. If it doesn't, try again within a setTimeout().
*/
		if (this.shapeNode && this.shapeNode.ownerDocument && this.shapeNode.ownerDocument.defaultView) {
			dojo.style(this.shapeNode, style);
		} else {
			console.error('this.shapeNode.ownerDocument.defaultView has no value');
/* 20120503 - Delete this setTimeout code below if we don't notice any redraw problems
			var that = this;
			setTimeout(function() {
				if (that.shapeNode && that.shapeNode.ownerDocument && that.shapeNode.ownerDocument.defaultView) {
					dojo.style(that.shapeNode, style);
				} else {
					console.error('this.shapeNode.ownerDocument.defaultView has no value after setTimeout');
				}
			},10);
*/
		}

	},

	render: function() {
		this.surface.appendChild(this.shapeNode);
		this.style({"zIndex": "1000255"});
	},

	destroy: function() {
		dojo.forEach(this._evtConns, dojo.disconnect);
		dojo.destroy(this.shapeNode);
		this.shapeNode = null;
		this.surface = null;
	},

	onMouseOver: function(/*Event*/ evt) {
		if (!this.surface.isDrawing) {
			evt.stopPropagation();
		}
		dojo.publish("/davinci/review/drawing/shapemouseover", [this, evt, this.surface]);
	},

	onMouseOut: function(/*Event*/ evt) {
		if (!this.surface.isDrawing) {
			evt.stopPropagation();
		}
		dojo.publish("/davinci/review/drawing/shapemouseout", [this, evt, this.surface]);
	},

	onMouseDown: function(/*Event*/ evt) {
		if (!this.surface.isDrawing) {
			evt.stopPropagation();
		}
		dojo.publish("/davinci/review/drawing/shapemousedown", [this, evt, this.surface]);
	}

});
});
},
'davinci/review/drawing/tools/scaffolds/scaffolds':function(){
define([
	"dojo/_base/declare",
	"./ArrowScaffold",
	"./RectangleScaffold",
	"./EllipseScaffold",
	"./TextScaffold"
], function(declare, ArrowScaffold, RectangleScaffold, EllipseScaffold, TextScaffold) {

	var scaffolds = {};
	
	scaffolds.ArrowScaffold = ArrowScaffold;
	scaffolds.RectangleScaffold = RectangleScaffold;
	scaffolds.EllipseScaffold = EllipseScaffold;
	scaffolds.TextScaffold = TextScaffold;
	
	return dojo.setObject("davinci.review.drawing.tools.scaffolds", scaffolds);
});
},
'davinci/review/drawing/tools/scaffolds/TextScaffold':function(){
define([
	"dojo/_base/declare",
	"./_ScaffoldCommon",
	"davinci/review/drawing/shapes/Text"
], function(declare, _ScaffoldCommon, Text) {
	
return declare("davinci.review.drawing.tools.scaffolds.TextScaffold", _ScaffoldCommon, {

	constructor: function(surface) {
		this.nwh = this._createHandler("nw");
		this.neh = this._createHandler("ne");
		this.seh = this._createHandler("se");
		this.swh = this._createHandler("sw");
		this._evtConns = [
			dojo.connect(this.nwh, "mousedown", this, "onHandlerMouseDown"),
			dojo.connect(this.neh, "mousedown", this, "onHandlerMouseDown"),
			dojo.connect(this.seh, "mousedown", this, "onHandlerMouseDown"),
			dojo.connect(this.swh, "mousedown", this, "onHandlerMouseDown")
		];
	},

	createShape: function(x, y, attributeMap) {
		this.shape = new Text(this.surface, x, y, x + 1, y + 1, attributeMap);
		this.anchorPoint = {x: x, y: y};
		this.inherited(arguments);
		return this.shape;
	},

	getEditMode: function() {
		this.shape.getEditMode(); // Turn on the edit mode
	},

	transformShape: function(x, y) {
		this._transform(x, y);
		this.inherited(arguments);
	},

	wrapShape: function(shape, /*Boolean*/ isRewrap) {
		this.inherited(arguments);
		dojo.style(this.nwh, {"left": shape.x1 - 0.5 + "px", "top": shape.y1 - 0.5 + "px"});
		dojo.style(this.neh, {"left": shape.x2 - 0.5 + "px", "top": shape.y1 - 0.5 + "px"});
		dojo.style(this.seh, {"left": shape.x2 - 0.5 + "px", "top": shape.y2 - 0.5 + "px"});
		dojo.style(this.swh, {"left": shape.x1 - 0.5 + "px", "top": shape.y2 - 0.5 + "px"});
		if (!isRewrap) {
			this.surface.appendChild(this.nwh);
			this.surface.appendChild(this.neh);
			this.surface.appendChild(this.seh);
			this.surface.appendChild(this.swh);
		}
	},

	destroy: function() {
		dojo.destroy(this.nwh);
		dojo.destroy(this.neh);
		dojo.destroy(this.seh);
		dojo.destroy(this.swh);
		this.inherited(arguments);
	},

	onHandlerMouseMove: function(evt) {
		this._transform(evt.pageX, evt.pageY);
		this.inherited(arguments);
	},

	_transform: function(x, y) {
		var anchorPoint = this.anchorPoint, shape = this.shape;
		if (anchorPoint.x < x && anchorPoint.y < y) {
			this.anchorPoint = {x: shape.x1, y: shape.y1};
			shape.x2 = x; shape.y2 = y;
		} else if(anchorPoint.x > x && anchorPoint.y < y) {
			this.anchorPoint = {x: shape.x2, y: shape.y1};
			shape.x1 = x; shape.y2 = y;
		} else if(anchorPoint.x > x && anchorPoint.y > y) {
			this.anchorPoint = {x: shape.x2, y: shape.y2};
			shape.x1 = x; shape.y1 = y;
		} else if(anchorPoint.x < x && anchorPoint.y > y) {
			this.anchorPoint = {x: shape.x1, y: shape.y2};
			shape.x2 = x; shape.y1 = y;
		}
	}

});
});

},
'davinci/review/editor/Context':function(){
define([
    "dojo/_base/declare",
    "dojo/_base/connect", 
    "../drawing/Surface",
	"../drawing/tools/CreateTool",
	"../drawing/tools/ExchangeTool",
	"../drawing/tools/HighlightTool",
	"../drawing/tools/SelectTool",
	"../../Runtime",
	"davinci/XPathUtils",
	"davinci/maqetta/AppStates",
	"../../UserActivityMonitor",
	"../Review",
	"../../ve/Context",
	'preview/silhouetteiframe'
], function(declare, connect, Surface, CreateTool, ExchangeTool, HighlightTool, SelectTool, Runtime, XPathUtils, AppStates, UserActivityMonitor, Review, Context, Silhouette) {

// AppStates functions are only available on the prototype object
var States = AppStates.prototype;

return declare("davinci.review.editor.Context", [Context], {

	setSource: function(){
				
		var containerNode = this.containerNode; 
		var versionInfo = this.resourceFile.parent;
		if (!versionInfo.width) {
			containerNode.style.overflowX = "hidden";
		}
		if (!versionInfo.height) {
			containerNode.style.overflowY = "hidden";
		}
		if (!this.frame) {
			var baseURL = this.baseURL;
			if (this.getPreference("zazl")) {
				baseURL += '?zazl=true';
			}

			this.frame = dojo.create("iframe", dojo.mixin(this.iframeattrs, {
				style: {
					border: "0",
					width: versionInfo.width && versionInfo.height ? versionInfo.width + "px" : "100%",
					height: versionInfo.width && versionInfo.height ? versionInfo.height + "px" : "100%"
				},
				src: baseURL,
				onload: function(event){
					this._domIsReady = true;
					var userDoc = event && event.target && event.target.contentDocument;
					var userWindow = userDoc && userDoc.defaultView && userDoc.defaultView.window;
					var deviceName = this.frame.contentDocument.body.getAttribute('data-maq-device');
					var deviceNameM6 = this.frame.contentDocument.body.getAttribute('data-maqetta-device');
					if(!deviceName && deviceNameM6){
						// Migrate old M6 attribute name to new M7-or-later attribute name
						deviceName = deviceNameM6;
					}
					var svgFilename = null;
					if (deviceName && deviceName != 'none' && deviceName != 'desktop') {
						svgFilename = "app/preview/images/" + deviceName + ".svg";
						userWindow.require && userWindow.require('dojo/ready')(function(){
				    		var deviceTheme = userWindow.require('dojox/mobile/deviceTheme');        	
				        	deviceTheme.loadDeviceTheme(Silhouette.getMobileTheme(svgFilename));
						});
					}

					connect.subscribe("/davinci/scene/selectionChanged", this, function(SceneManager, sceneId) {
						if (!Runtime.currentEditor || Runtime.currentEditor.editorID != "davinci.review.CommentReviewEditor") { 
							return; 
						}
						if (this._commentView) {
							this._commentView.updateStatesScenes();
						}							
					});

					userWindow.require && userWindow.require(["dojo/_base/connect"], function(userWindowConnect) {
						userWindowConnect.subscribe("/maqetta/appstates/state/changed", this, function(args) {
							if (!args || !Runtime.currentEditor || Runtime.currentEditor.declaredClass != "davinci.review.editor.ReviewEditor") { 
								return; 
							}
//							var state = args.newState || "Normal";
							var dv = userWindow.davinci;
							if(dv && dv.states && dv.states.setState){
/*FIXME: Shouldn't be necessary - event was spawned because state just changed. No need to change it again.
							dv.states.setState(state, args.stateContainerNode, { focus:true, silent:true, updateWhenCurrent:true });
*/
								if (this._commentView) {
									this._commentView.updateStatesScenes();
								}
								// Re-publish at the application level
								var newArgs = dojo.clone(args); //FIXME: use shallow copy?
								newArgs.editorClass = "davinci.review.editor.ReviewEditor";
								connect.publish("/maqetta/appstates/state/changed", [newArgs]);
							}
						});
					}.bind(this));

					this.rootNode = this.rootWidget = this.frame.contentDocument.body;
					
					// Set "focus" for application states
					var statesFocus = States.getFocus(this.rootNode);
					if(!statesFocus){
						var stateContainers = States.getAllStateContainers(this.rootNode);
						if(stateContainers.length > 0){
							var initialState = States.getInitial(stateContainers[0]);
							States.setState(initialState, stateContainers[0], { focus:true, updateWhenCurrent:true });
						}
					}
					
					this._initDrawing();
					connect.publish("/davinci/review/context/loaded", [this, this.fileName]);

					// add the user activity monitoring to the document and add the connects to be 
					// disconnected latter
					var newCons = [].concat(this._cxtConns, UserActivityMonitor.addInActivityMonitor(this.frame.contentDocument));
					this._cxtConns = newCons;
					this.containerEditor.silhouetteiframe.setSVGFilename(svgFilename);
					this._statesLoaded = true;
					connect.publish('/davinci/ui/context/statesLoaded', [this]);
					if(this.surface){
						this._refreshSurface(this.surface);
					}
				}.bind(this)
			}), containerNode);
/*FIXME: Pretty sure it's not needed, so commenting out for now, but leaving around in case problems crop up
			connect.subscribe("/maqetta/appstates/state/changed", this, function(args) { 
				if (!args || !Runtime.currentEditor || Runtime.currentEditor.editorID != "davinci.review.CommentReviewEditor" ||
						!this.containerEditor || this.containerEditor != Runtime.currentEditor) { 
					return; 
				}
				// Push the state change down into the review document
				var userWin = this.frame && this.frame.contentDocument && this.frame.contentDocument.defaultView;
				if(userWin && userWin.davinci && userWin.davinci.states && userWin.davinci.states.setState){
					userWin.davinci.states.setState(args.newState, args.stateContainerNode);
				}
			});
*/
		}
	},

	getSelection: function() {
		return []; // Overridden for NOOP behavior
	},

	select: function(){
		// Overridden for NOOP behavior
	},

	_initDrawing: function() {
		// summary:
		//        Create the canvas for annotations, and wait for the shape definition
		//        to add a shape. The shapes will be created one by one.
		//        Shapes with commentId, state and colorAlias(reviewer)
		var doc = this.frame.contentDocument, 
			surface;
		if (!this.surface) {
			surface = this.surface = new Surface(doc.body, doc, this);
			new CreateTool(surface, ["commentId"]);
			new SelectTool(surface, ["commentId"]).activate();
			new ExchangeTool(surface, ["commentId"]);
			new HighlightTool(surface).activate();
		} else {
			surface = this.surface;
		}
		this._cxtConns = [
			 connect.connect(surface.highlightTool, "onShapeMouseDown", function(shape) {
				 connect.publish("/davinci/review/drawing/annotationSelected", [shape.commentId]);
			 }),
			 connect.connect(this.getContainerNode(), "click", dojo.hitch(this, function(evt) {
				 if (!this.containerEditor.isDirty && evt.target === this.getContainerNode()) {
					 connect.publish("/davinci/review/view/canvasFocused", [this]);
				 }
			 }))
			];
		this._cxtSubs = [
			 connect.subscribe(this.fileName+"/davinci/review/drawing/addShape", function(shapeDef, clear, editor) {
				 this.surface.exchangeTool.importShapes(shapeDef, clear, dojo.hitch(Review, Review.getColor)); // FIXME: Unique surface is required
			 }.bind(this)),
			 connect.subscribe(this.fileName+"/davinci/review/drawing/enableEditing", this, function(reviewerEmail, commentId, args) {
				 var pageState = args.pageState;
				 var pageStateList = args.pageStateList;
				 var viewScene = args.viewScene;
				 var viewSceneList = args.viewSceneList;
				 var surface = this.surface;
				 surface.activate();
				 surface.cached = surface.exchangeTool.exportShapesByAttribute();
				 surface.currentReviewerEmail = reviewerEmail;
				 surface.commentId = commentId;
				 surface.filterState = pageState;
				 surface.filterStateList = pageStateList;
				 surface.filterScene = viewScene;
				 surface.filterSceneList = viewSceneList;
				 surface.filterComments = [commentId];
				 this._refreshSurface(surface);
			 }),
			 connect.subscribe(this.fileName+"/davinci/review/drawing/getShapesInEditing", this, function(obj, args) {
				 if (obj._currentPage != this.fileName) {
					 return;
				 }
				 var state = args.state;
				 var stateList = args.stateList;
				 var scene = args.scene;
				 var sceneList = args.sceneList;
				 var surface = this.surface;
				 surface.selectTool.deselectShape();
				 surface.setValueByAttribute("commentId", surface.commentId, "state", state);
				 surface.setValueByAttribute("commentId", surface.commentId, "stateList", stateList);
				 surface.setValueByAttribute("commentId", surface.commentId, "scene", scene);
				 surface.setValueByAttribute("commentId", surface.commentId, "sceneList", sceneList);
				 obj.drawingJson = surface.exchangeTool.exportShapesByAttribute("commentId", [surface.commentId]);
				 surface.deactivate();
				 surface.commentId = "";
			 }),
			 connect.subscribe(this.fileName+"/davinci/review/drawing/cancelEditing", this, function() {
				 // Restore the previous status
				 var surface = this.surface;
				 surface.exchangeTool.importShapes(surface.cached, true, dojo.hitch(Review, Review.getColor)); // FIXME: Unique surface is required
				 surface.deactivate();
				 this._refreshSurface(surface);
				 surface.commentId = ""; // Clear the filter so that no shapes can be selected
			 }),
			 connect.subscribe(this.fileName+"/davinci/review/drawing/filter", this, function(/*Object*/ stateinfo, /*Array*/ commentIds) {
				 var surface = this.surface;
/*FIXME: surface should update based on event listeners to setstate and setscene
				 surface.filterState = stateinfo.pageState;
				 surface.filterStateList = stateinfo.pageStateList;
				 surface.filterScene = stateinfo.viewScene;
				 surface.filterSceneList = stateinfo.viewSceneList;
*/
/*FIXME: We shouldn't be updating the surface here. That should be done
	by state change and scene change listeners */
				 var statesFocus = States.getFocus(this.rootNode);
				 surface.filterState = statesFocus ? statesFocus.state : undefined;
				 surface.filterStateList = this.getCurrentStates();
				 surface.filterScene =  this.getCurrentScene();
				 surface.filterSceneList = this.getCurrentScenes();
				 surface.filterComments = commentIds;
				 this._refreshSurface(surface);
			 }),
			 connect.subscribe(this.fileName+"/davinci/review/drawing/setShownColorAliases", this,function(colorAliases) {
				 var surface = this.surface;
				 surface.filterColorAliases = colorAliases;
				 this._refreshSurface(surface);
			 }),
			 connect.subscribe("/davinci/review/view/openComment", this, function() {
	            if (Runtime.currentEditor === this.containerEditor) {
	            	this.containerEditor.isDirty = true;
	            	//Also, tell our container we're dirty
	            	if (this.containerEditor.editorContainer) {
	            		this.containerEditor.editorContainer.setDirty(true);
	    			}
	            }
			 }),
			 connect.subscribe("/davinci/review/view/closeComment", this, function() {
				 if (Runtime.currentEditor === this.containerEditor) {
					 this.containerEditor.isDirty = false;
					 //Also, tell our container we're no longer dirty
		            	if (this.containerEditor.editorContainer) {
		            		this.containerEditor.editorContainer.setDirty(false);
		    			}
				 }
			 }),
			 connect.subscribe("/davinci/ui/editorSelected", this, function(obj){
				 if (obj.oldEditor!=null && this === obj.oldEditor.getContext && this === obj.oldEditor.getContext()) { // not all editors have a context eg textView
					 // Determine if the editor is closed, if the editor is closed then
					 // getDocument() will throw an exception
					 try {
						 this.getDocument();
					 } catch(err) {
						 // The editor is closed now
						 this._destroyDrawing();
					 }
				 }
			 })
		];
	},

	_refreshSurface: function(surface) {
		var that = this;
		if(!this._domIsReady){
			return;
		}
		
		// Return true if shape and surface have different values for state or scene
		function differentStateScene(shape, surface){
			if(!shape || !surface){
				return false;
			}
			if(!that.stateSceneCheck(shape.stateList, shape.sceneList, surface.filterStateList, surface.filterSceneList)){
				return true;
			}
			return false;
		}

		var shapes = surface.shapes, result;

		dojo.forEach(shapes, function(shape) {
			var result = "hidden";
			if (Runtime.singleUserMode() ||
					dojo.some(surface.filterColorAliases, function(colorAlias) {
				//FIXME: Hack to fix #1486 just before Preview 4 release
				// Old code - quick check - covers case where server uses same string for username and email
				if (shape.colorAlias == colorAlias) {
					return true;
				} else if (davinci && davinci.review && dojo.isArray(Runtime.reviewers)) {
					// New code hack - see if colorAlias matches either username or email corresponding to shape.colorAlias
					var reviewers = Runtime.reviewers;
					var found = false;
					for (var i=0; i<reviewers.length; i++) {
						if (colorAlias == reviewers[i].email) {
							found = true;
							break;
						}
					}
					if (found) {
						if (shape.colorAlias == reviewers[i].email) {
							return true;
						}
					}
					return false;
				}
			})) {
				if (surface.filterComments && surface.filterComments.length > 0) {
					if (dojo.some(surface.filterComments, function(commentId) { 
						return shape.commentId == commentId;
					})){
						result = "visible";
						surface.highlightTool && (surface.highlightTool.shape = shape);
					} else {
						result = "partial";
					}
					if (differentStateScene(shape, surface)) {
						result = "hidden";
					}
				} else {
					if (differentStateScene(shape, surface)){
						result = "hidden";
					} else {
						result = "visible";
					}
				}
			}
			if (shape.commentId == surface.commentId) {
				// Keep the shapes in editing
				result = "visible";
			}
			shape.setVisible(result);
		});
	},

	destroy: function() {
		this._destroyDrawing();
	},
	
	_destroyDrawing: function() {
		try {
			if (this.surface) {
				this.surface.destroy();
				delete this.surface;
			}
		} catch(err) { /*Do nothing*/ }
		this._cxtConns.forEach(connect.disconnect);
		this._cxtSubs.forEach(connect.unsubscribe);
	},
	
	getCurrentStates: function(){
		return States.getAllCurrentStates(this.rootNode).map(function(state) {
			var node = state.stateContainerNode;
			var id = node ? node.id : '';
			var xpath = node ? XPathUtils.getXPath(node) : '';
			return { id: id, xpath: xpath, state: state.state };
		});
	},
	
	getCurrentScenes: function(){
		var sceneManagers = this.sceneManagers;
		var sceneManagerObj = {};
		for (var smIndex in sceneManagers) {
			var sm = sceneManagers[smIndex];
			if (sm.getAllSceneContainers && sm.getCurrentScene) {
				sceneManagerObj[sm.id] = sm.getAllSceneContainers().map(function(sc) {
					var scene = sm.getCurrentScene(sc);
					var sceneId = (scene && scene.id) ? scene.id : '';
					var sceneXpath = (scene && scene.id) ? XPathUtils.getXPath(scene) : '';
					return {scId: sc.id, scXpath: XPathUtils.getXPath(sc), sceneId: sceneId, sceneXpath: sceneXpath };
				});
			}
		}
		return sceneManagerObj;
	},
	
	// FIXME: Probably not needed because should be using sceneList everywhere now
	// instead of checking for current scene
	getCurrentScene: function(){
		var sceneManagers = this.sceneManagers;
		for (var smIndex in sceneManagers) {
			var sm = sceneManagers[smIndex];
			if (sm.getAllSceneContainers && sm.getCurrentScene) {
				var sceneContainers = sm.getAllSceneContainers();
				for(var j=0; j<sceneContainers.length; j++){
					var sc = sceneContainers[j];
					var scene = sm.getCurrentScene(sc);
					var sceneId = (scene && scene.id) ? scene.id : '';
					return sceneId;
				}
			}
		}
		return;
	},
	
	/**
	 * Returns true if given object's states and scenes match what's in the reference object's
	 * states and scenes.
	 * @param {array} objPageStateList  Array of objects of form
	 *     [ { id:{string}, xpath:{string}, state:{string} } ]
	 *     where id and xpath identify a state container object
	 * @param {object} objViewSceneList  Associative array, with one entry
	 *     for each plugginable "scene container". Each entry in associative
	 *     array is a regular old array (of objects), with one entry for each scene container node.
	 *     Each of these objects with that regular old array has the following form:
	 *     [ { scId:{string}, scXpath:{string}, sceneId:{string}, sceneXPath:{string} } ]
	 *     where scId and scXpath identify a scene container node and
	 *     where sceneId and sceneXPath identify a scene node.
	 * @param {array} refPageStateList  Reference object's state list
	 * @param {object} refViewSceneList  Reference object's scene list
	 */
	stateSceneCheck: function(objPageStateList, objViewSceneList, refPageStateList, refViewSceneList){
		function normalizeNormalState(val){
			return !val ? States.NORMAL : val;
		}
		var i, obj, ref;
		if(objPageStateList && refPageStateList){
			for(i=0; i<refPageStateList.length; i++){
				ref = refPageStateList[i];
				var refState = normalizeNormalState(ref.state);
				obj = objPageStateList[i];
				var objState = normalizeNormalState(obj.state);
				if(obj && ref){
					if(((obj.id && obj.id === ref.id) || 
							(obj.xpath && obj.xpath === ref.xpath)) &&
							objState !== refState){
						return false;
					}
				}
			}
		}
		if(objViewSceneList && refViewSceneList){
			for(var smIndex in refViewSceneList){
				var _refViewSceneList = refViewSceneList[smIndex];
				var _objViewSceneList = objViewSceneList[smIndex];
				if(_refViewSceneList && _objViewSceneList){
					for(i=0; i<_refViewSceneList.length; i++){
						ref = _refViewSceneList[i];
						obj = _objViewSceneList[i];
						if(obj && ref){
							if(((obj && obj.scId && ref && obj.scId === ref.scId) ||
									(obj && obj.scXpath && ref && obj.scXpath === ref.scXpath)) &&
								((obj && obj.sceneId && ref && obj.sceneId !== ref.sceneId) ||
									(obj && obj.sceneXpath && ref && obj.sceneXpath !== ref.sceneXpath))){
								return false;
							}
						}
					}
				}
			}
		}
		return true;
	}

});
});
},
'davinci/review/drawing/tools/HighlightTool':function(){
define([
	"dojo/_base/declare",
	"./_ToolCommon"
], function(declare, _ToolCommon) {
	
return declare("davinci.review.drawing.tools.HighlightTool", _ToolCommon, {

	constructor: function(surface) {
		surface.highlightTool = this;
	},

	activate: function() {
		if (this.activated) { 
			return;
		}
		this._evtSubs = [
			dojo.subscribe("/davinci/review/drawing/shapemouseover", this, "_onShapeMouseOver"),
			dojo.subscribe("/davinci/review/drawing/shapemouseout", this, "_onShapeMouseOut"),
			dojo.subscribe("/davinci/review/drawing/shapemousedown", this, "_onShapeMouseDown")
		];
		this.activated = true;
	},

	_onShapeMouseOver: function(shape, evt, surface) {
		if (this.surface !== surface || this.surface.isDrawing) { 
			return;
		}
		var shapes = this.surface.shapes;
		shape.style({"cursor": "pointer"});
		if (!this.shape) {
			shape.style({"opacity": "0.5"});
		}
	},

	_onShapeMouseOut: function(shape, evt, surface) {
		if (this.surface !== surface || this.surface.isDrawing) { 
			return;
		}
		var shapes = this.surface.shapes;
		shape.style({"cursor": ""});
		if (!this.shape) {
			shape.style({"opacity": "1.0"});
		}
	},

	_onShapeMouseDown: function(shape, evt, surface) {
		if (this.surface !== surface || this.surface.isDrawing) { 
			return;
		}
		if (this.shape === shape) {
			shape.style({"opacity": "0.5"});
			this.shape = null;
		} else {
			shape.style({"opacity": "1.0"});
			this.shape = shape;
		}
		this.onShapeMouseDown(shape);
	},

	onShapeMouseDown: function(shape) {
		// Placeholder
	},

	deactivate: function() {
		if (!this.activated) { 
			return;
		}
		var shapes = this.surface.shapes;
		if (this.shape) {
			dojo.forEach(shapes, function(shape) {
				shape.style({"opacity": "1.0", "cursor": ""});
			});
		}
		dojo.forEach(this._evtSubs, dojo.unsubscribe);
		this.shape = null;
		this.activated = false;
	}

});
});

},
'davinci/review/drawing/tools/ExchangeTool':function(){
define([
	"dojo/_base/declare",
	"./_ToolCommon"
], function(declare, _ToolCommon) {
	
return declare("davinci.review.drawing.tools.ExchangeTool", _ToolCommon, {

	constructor: function(surface) {
		surface.exchangeTool = this;
	},

	exportShapesByAttribute: function(/*String?*/ attrName, /*Array?*/ values) {
		// summary:
		//		Export the shapes with the same tag. If the tag is not specified, export all the shapes
		var shapes = this.surface.getShapesByAttribute(attrName, values), 
			tmpStr,
			jsonString = [], 
			type;
		
		dojo.forEach(shapes, function(shape) {
			if (shape.isInstanceOf(davinci.review.drawing.shapes.Arrow)) {
				type = "Arrow";
			} else if(shape.isInstanceOf(davinci.review.drawing.shapes.Rectangle)) {
				type = "Rectangle";
			} else if(shape.isInstanceOf(davinci.review.drawing.shapes.Ellipse)) {
				type = "Ellipse";
			} else if(shape.isInstanceOf(davinci.review.drawing.shapes.Text)) {
				type = "Text";
			} else {
				return;
			}
			var o = {type:type ,x1:shape.x1, y1:shape.y1, x2:shape.x2, y2:shape.y2};
			for (var attr in shape.attributeMap) {
				if (shape.attributeMap.hasOwnProperty(attr)) {
					var s = (attr == 'stateList' || attr == 'sceneList') ?
							dojo.toJson(shape[attr]) : shape[attr];
					o[attr] = s;
				}
			}
			if (type == "Text") {
				o.text = escape(shape.getText());
			}
			tmpStr = dojo.toJson(o);
			jsonString.push(tmpStr);
		});
		return "[" + jsonString.join(",") + "]";
	},

	importShapes: function(/*String*/ data, /*Boolean*/clear, /*Function*/ a2c) {
		try {
			var shapes = eval(data),clazz, shape;
			if (clear) { 
				this.surface.clear();
			}
			dojo.forEach(shapes, function(s) {
				var type = s.type;
				if (type == "Arrow") {
					clazz = davinci.review.drawing.shapes.Arrow;
				} else if(type == "Rectangle") {
					clazz = davinci.review.drawing.shapes.Rectangle;
				} else if(type == "Ellipse") {
					clazz = davinci.review.drawing.shapes.Ellipse;
				} else if(type == "Text") {
					clazz = davinci.review.drawing.shapes.Text;
				} else {
					return;
				}
				var x1 = s.x1, x2 = s.x2, y1 = s.y1, y2 = s.y2, text = s.text;
				delete s.type;
				delete s.x1;
				delete s.x2;
				delete s.y1;
				delete s.y2;
				s.a2c = a2c;
				if(s.stateList){
					s.stateList = dojo.fromJson(s.stateList);
				}
				if(s.sceneList){
					s.sceneList = dojo.fromJson(s.sceneList);
				}
				shape = new clazz(this.surface, x1, y1, x2, y2, s);
				shape.filterAttributes = this.filterAttributes;
				shape.render();
				if (type == "Text") {
					shape.setText(unescape(text));
				}
				this.surface.shapes.push(shape);
			}, this);
		}catch(exp){
			console.log("Failed to create the shape with the definition: " + data);
		}
	}

});
});

},
'davinci/review/drawing/tools/scaffolds/_ScaffoldCommon':function(){
define([
	    "dojo/_base/declare"
], function(declare) {
	
return declare("davinci.review.drawing.tools.scaffolds._ScaffoldCommon", null, {

	constructor: function(surface) {
		this.surface = surface;
	},

	createShape: function(x, y, attributeMap) {
		this.shape.render();
	},

	transformShape: function(x, y) {
		if (this.shape) {
			this.shape.render();
		}
	},

	wrapShape: function(shape, /*Boolean*/ isRewrap, /*Point*/ clickPoint) {
		this.shape = shape;
		if (!isRewrap) {
			this._clickPoint = clickPoint;
			this._onShapeMouseDown();
		}
	},

	moveShape: function(dx, dy) {
		var shape = this.shape;
		shape.x1 += dx; shape.y1 += dy;
		shape.x2 += dx; shape.y2 += dy;
		shape.render();
		this.wrapShape(shape, true);
	},

	removeShape: function() {
		this.surface.removeShape(this.shape);
		this.destroy();
	},

	onHandlerMouseMove: function(evt) {
		this.shape.render();
		this.wrapShape(this.shape, true);
	},

	destroy: function() {
		dojo.forEach(this._evtConns, dojo.disconnect);
		dojo.forEach(this._evtSubs, dojo.unsubscribe);
		this.activeHandler = this.shape = this.surface = null;
	},

	onHandlerMouseDown: function(evt) {
		var shape = this.shape;
		this.activeHandler = evt.target;
		switch(this.activeHandler.position){
		case "nw":
			this.anchorPoint = {x: shape.x2, y: shape.y2};
			break;
		case "ne":
			this.anchorPoint = {x: shape.x1, y: shape.y2};
			break;
		case "se":
			this.anchorPoint = {x: shape.x1, y: shape.y1};
			break;
		case "sw":
			this.anchorPoint = {x: shape.x2, y: shape.y1};
			break;
		}
		dojo.stopEvent(evt);
		this._mouseMoveHandler = dojo.connect(this.surface.domNode, "mousemove", this, "onHandlerMouseMove");
		this._mouseUpHandler = dojo.connect(this.surface.domNode, "mouseup", this, "_onHandlerMouseUp");
	},

	_onHandlerMouseUp: function(evt) {
		dojo.disconnect(this._mouseMoveHandler);
		dojo.disconnect(this._mouseUpHandler);
	},

	_onShapeMouseDown: function() {
		this._mouseMoveHandler = dojo.connect(this.surface.domNode, "mousemove", this, "_onShapeMouseMove");
		this._mouseUpHandler = dojo.connect(this.surface.domNode, "mouseup", this, "_onShapeMouseUp");
		this._evtConns.push(dojo.connect(this.surface.domNode, "keydown", this, "_onShapeKeyDown"));
	},

	_onShapeMouseMove: function(evt) {
		var dx = evt.pageX - this._clickPoint.x,
		dy = evt.pageY - this._clickPoint.y;
		this._clickPoint.x = evt.pageX;
		this._clickPoint.y = evt.pageY;
		this.moveShape(dx, dy);
	},

	_onShapeMouseUp: function(evt) {
		dojo.disconnect(this._mouseMoveHandler);
		dojo.disconnect(this._mouseUpHandler);
	},

	_onShapeKeyDown: function(evt) {
		// If the shape is in edit mode, not need to bother the key actions
		if(this.shape.editable){ 
			return;
		}
		dojo.stopEvent(evt);
		switch (evt.keyCode) {
		case dojo.keys.ESCAPE:
			this.destroy();
			break;
		case dojo.keys.DELETE:
		case dojo.keys.BACKSPACE:
			this.removeShape();
			break;
		case dojo.keys.LEFT_ARROW:
			this.moveShape(-2, 0);
			break;
		case dojo.keys.UP_ARROW:
			this.moveShape(0, -2);
			break;
		case dojo.keys.RIGHT_ARROW:
			this.moveShape(2, 0);
			break;
		case dojo.keys.DOWN_ARROW:
			this.moveShape(0, 2);
			break;
		}
	},

	_createHandler: function(/*String*/ position) {
		// summary:
		//		position: "w", "sw", "s", "se", "e", "ne", "n", "nw"
		var handler = dojo.create("div");
		this.handlerRadius = 3;
		dojo.style(handler, {
			"position": "absolute",
			"padding": "0px",
			"margin": "0px",
			"border": "1px solid black",
			"backgroundColor": "white",
			"width": (this.handlerRadius - 1) * 2 + "px",
			"height": (this.handlerRadius - 1) * 2 + "px",
			"MozBorderRadius": this.handlerRadius + "px",
			"WebkitBorderRadius": this.handlerRadius + "px",
			"borderRadius": this.handlerRadius + "px",
			"cursor": position + "-resize",
			"zIndex": 1000256
		});
		handler.position = position;
		return handler;
	}

});
});

},
'davinci/review/drawing/tools/_ToolCommon':function(){
define([
	    "dojo/_base/declare"
], function(declare) {
	
return declare("davinci.review.drawing.tools._ToolCommon", null, {

	constructor: function(surface, filterAttributes) {
		this.surface = surface;
		this.filterAttributes = filterAttributes || [];
	},

	setFilterAttributes: function(attributes) {
		this.filterAttributes = filterAttributes || [];
	},

	activate: function() {},

	deactivate: function() {
		dojo.forEach(this._evtSubs, dojo.unsubscribe);
		dojo.forEach(this._evtConns, dojo.disconnect);
	},

	destroy: function() {
		dojo.forEach(this._evtSubs, dojo.unsubscribe);
		dojo.forEach(this._evtConns, dojo.disconnect);
		this.surface = null;
	}

});
});

},
'davinci/review/drawing/tools/CreateTool':function(){
define([
	"dojo/_base/declare",
	"./_ToolCommon",
	"./scaffolds/scaffolds"
], function(declare, _ToolCommon, scaffolds) {
	
return declare("davinci.review.drawing.tools.CreateTool", _ToolCommon, {

	constructor: function(surface, filterAttributes) {
		surface.createTool = this;
	},
	
	setShape: function(/*String*/ shapeName, attributeMap) {
		if(this.surface.isDrawing) { 
			return;
		}
		this.shapeAttributeMap = attributeMap;
		if (this.scaffold) { 
			this.scaffold.destroy(); //Ensure that the scaffold is cleaned
		}
		switch (shapeName) {
		case "Arrow":
			this.scaffold = new scaffolds.ArrowScaffold(this.surface);
			this.scaffold.type = "arrow";
			break;
		case "Rectangle":
			this.scaffold = new scaffolds.RectangleScaffold(this.surface);
			this.scaffold.type = "rectangle";
			break;
		case "Ellipse":
			this.scaffold = new scaffolds.EllipseScaffold(this.surface);
			this.scaffold.type = "ellipse";
			break;
		case "Text":
			this.scaffold = new scaffolds.TextScaffold(this.surface);
			this.scaffold.type = "text";
			break;
		default:
			new Error("Invalid shape type!");
		}
	},
	
	activate: function() {
		if (this.surface.isDrawing) {  
			return;
		}
		this.surface.isDrawing = true;
		var docNode = this.surface.docNode = this.surface.domNode;
		var htmlNode = this.surface.htmlNode = docNode.documentElement;
		var bodyNode = this.surface.bodyNode = docNode.body;
		var coverDiv = this.surface.coverDiv = dojo.create('div',
				// z-index:2million because annotations are at 1million plus change
				{style:'z-index:2000000;cursor:crosshair;position:absolute; left:0px; top:0px; width:'+htmlNode.offsetWidth+'px; height:'+htmlNode.offsetHeight+'px;'},
				bodyNode);
		this._evtConns = [
			dojo.connect(coverDiv, "mousedown", this, "_mouseDown"),
			dojo.connect(docNode, "keydown", this, "_keyDown")
		];
	},

	_mouseDown: function(evt) {
		dojo.stopEvent(evt);
		this.surface.appendShape(this.scaffold.createShape(evt.pageX, evt.pageY, this.shapeAttributeMap));
		if (this.scaffold.type == "text") {
			this.scaffold.shape.filterAttributes = this.filterAttributes;
		}
		this._evtConns.push(
			dojo.connect(this.surface.coverDiv, "mouseup", this, "_mouseUp"),
			dojo.connect(this.surface.coverDiv, "mousemove", this, "_mouseMove")
		);
	},

	_mouseUp: function(evt) {
		if (this.scaffold.getEditMode) {
			this.scaffold.getEditMode();
		}
		this.deactivate();
	},

	_mouseMove: function(evt) {
		if (!this.surface.isDrawing) { 
			return;
		}
		this.scaffold.transformShape(evt.pageX, evt.pageY);
	},

	_keyDown: function(evt) {
		if (evt.keyCode == dojo.keys.ESCAPE) {
			this.deactivate();
		}
	},

	deactivate: function() {
		if (!this.surface||!this.surface.isDrawing) { 
			return;
		}
		this.surface.isDrawing = false;
		this.scaffold.destroy();
		this.scaffold = null;
		this.inherited(arguments);
		var coverDiv = this.surface.coverDiv;
		if(coverDiv){
			var parentNode = coverDiv.parentNode;
			if(parentNode){
				parentNode.removeChild(coverDiv);
			}
			this.surface.coverDiv = null;
		}
	}

});
});

},
'davinci/review/actions/EditVersionAction':function(){
define([
	"dojo/_base/declare",
	"./_ReviewNavigatorCommon",
	"./PublishAction",
	"../../Runtime",
	"dojox/widget/Toaster",
	"dojo/i18n!./nls/actions"
], function(declare, _ReviewNavigatorCommon, PublishAction, Runtime, Toaster, nls) {

return declare("davinci.review.actions.EditVersionAction", [_ReviewNavigatorCommon], {

	run: function(context) {
		var selection = this._getSelection(context);
		if(!selection || !selection.length) return;
		var item = selection[0].resource.elementType=="ReviewFile"?selection[0].resource.parent:selection[0].resource;
		var action = new PublishAction(item);
		action.run();
	},

	isEnabled: function(context) {
		var selection = this._getSelection(context);
		if (selection && selection.length > 0) {
			var item = selection[0].resource.elementType=="ReviewFile"?selection[0].resource.parent:selection[0].resource;
			if (item.designerId == Runtime.userName) { 
				//Only enable if the current user is also the review's designer
				return true;
			}
		} 
		return false;
	}
});
});
},
'davinci/review/drawing/tools/scaffolds/EllipseScaffold':function(){
define([
	"dojo/_base/declare",
	"./_ScaffoldCommon",
	"davinci/review/drawing/shapes/Ellipse"
], function(declare, _ScaffoldCommon, Ellipse) {
	
return declare("davinci.review.drawing.tools.scaffolds.EllipseScaffold", _ScaffoldCommon, {

	constructor: function(surface) {
		this.nwh = this._createHandler("nw");
		this.neh = this._createHandler("ne");
		this.seh = this._createHandler("se");
		this.swh = this._createHandler("sw");
		this._evtConns = [
		    dojo.connect(this.nwh, "mousedown", this, "onHandlerMouseDown"),
		    dojo.connect(this.neh, "mousedown", this, "onHandlerMouseDown"),
		    dojo.connect(this.seh, "mousedown", this, "onHandlerMouseDown"),
		    dojo.connect(this.swh, "mousedown", this, "onHandlerMouseDown")
		];
	},

	createShape: function(x, y, attributeMap) {
		this.shape = new Ellipse(this.surface, x, y, x + 1, y + 1, attributeMap);
		this.anchorPoint = {x: x, y: y};
		this.inherited(arguments);
		return this.shape;
	},

	transformShape: function(x, y) {
		this._transform(x, y);
		this.inherited(arguments);
	},

	wrapShape: function(shape, /*Boolean*/ isRewrap) {
		this.inherited(arguments);
		dojo.style(this.nwh, {"left": shape.x1 + "px", "top": shape.y1 + "px"});
		dojo.style(this.neh, {"left": shape.x2 + "px", "top": shape.y1 + "px"});
		dojo.style(this.seh, {"left": shape.x2 + "px", "top": shape.y2 + "px"});
		dojo.style(this.swh, {"left": shape.x1 + "px", "top": shape.y2 + "px"});
		if (!isRewrap) {
			this.surface.appendChild(this.nwh);
			this.surface.appendChild(this.neh);
			this.surface.appendChild(this.seh);
			this.surface.appendChild(this.swh);
		}
	},

	destroy: function() {
		dojo.destroy(this.nwh);
		dojo.destroy(this.neh);
		dojo.destroy(this.seh);
		dojo.destroy(this.swh);
		this.inherited(arguments);
	},

	onHandlerMouseMove: function(evt) {
		this._transform(evt.pageX, evt.pageY);
		this.inherited(arguments);
	},

	_transform: function(x, y) {
		var anchorPoint = this.anchorPoint, shape = this.shape;
		if (anchorPoint.x < x && anchorPoint.y < y) {
			this.anchorPoint = {x: shape.x1, y: shape.y1};
			shape.x2 = x; shape.y2 = y;
		} else if(anchorPoint.x > x && anchorPoint.y < y) {
			this.anchorPoint = {x: shape.x2, y: shape.y1};
			shape.x1 = x; shape.y2 = y;
		} else if(anchorPoint.x > x && anchorPoint.y > y) {
			this.anchorPoint = {x: shape.x2, y: shape.y2};
			shape.x1 = x; shape.y1 = y;
		} else if(anchorPoint.x < x && anchorPoint.y > y) {
			this.anchorPoint = {x: shape.x1, y: shape.y2};
			shape.x2 = x; shape.y1 = y;
		}
	}

});
});

},
'davinci/review/drawing/shapes/Text':function(){
define([
	"dojo/_base/declare",
	"./_ShapeCommon"
], function(declare, _ShapeCommon) {
	
return declare("davinci.review.drawing.shapes.Text", _ShapeCommon, {

	render: function() {
		if (!this.shapeNode) {
			this._createEditArea();
			this._evtConns.push(
				dojo.connect(this.shapeNode, "mouseover", this, "onMouseOver"),
				dojo.connect(this.shapeNode, "mouseout", this, "onMouseOut"),
				dojo.connect(this.shapeNode, "mousedown", this, "onMouseDown"),
				dojo.connect(this.shapeNode, "dblclick", this, "_onDoubleClick"),
				dojo.connect(this.shapeNode, "blur", this, "_onblur")
			);
		}
		this._transformTextArea();
		this.inherited(arguments);
	},

	setText: function(text) {
		this.shapeNode.innerHTML = text;
	},

	getText: function() {
		return this.shapeNode.innerHTML.replace(/"/g, "'");
	},

	getEditMode: function() {
		if(!this.surface.isActivated) return;
		this.editable = true;
		dojo.attr(this.shapeNode, "contenteditable", "true");
		dojo.style(this.shapeNode, "cursor", "");
		this.shapeNode.focus();
	},

	_createEditArea: function() {
		this.shapeNode = dojo.create("div");
		this.width = Math.abs(this.x1 - this.x2);
		this.height = Math.abs(this.y1 - this.y2);
		dojo.style(this.shapeNode, {
			"position": "absolute",
			"padding": "2px",
			"margin": "0px",
			"border": "1px dotted black",
			"overflow": "hidden",
			"color": this.color,
			"width": this.width + "px",
			"height": this.height + "px"
		});
	},

	_transformTextArea: function() {
		this.width = Math.abs(this.x1 - this.x2);
		this.height = Math.abs(this.y1 - this.y2);
		dojo.style(this.shapeNode, {
			"left": this.x1 + "px",
			"top": this.y1 + "px",
			"width": this.width + "px",
			"height": this.height + "px"
		});
	},

	_onDoubleClick: function(evt) {
		if (!this.surface.isActivated || !this.isReadOnly()) {
			return;
		}
		this.editable = true;
		dojo.attr(this.shapeNode, "contenteditable", "true");
		dojo.style(this.shapeNode, "cursor", "");
		this.shapeNode.focus();
	},

	_onblur: function(evt) {
		if (!this.surface.isActivated) {
			return;
		}
		this.editable = false;
		dojo.attr(this.shapeNode, "contenteditable", "false");
		dojo.style(this.shapeNode, "cursor", "auto");
	},

	isReadOnly: function(){
		var surface = this.surface, secAttrs = this.filterAttributes;
		return dojo.every(secAttrs, function(attr) {
			return this[attr] && surface[attr] && this[attr] == surface[attr];
		}, this);
	}

});
});
},
'davinci/review/drawing/shapes/Rectangle':function(){
define([
	"dojo/_base/declare",
	"./_ShapeCommon"
], function(declare, _ShapeCommon) {
	
return declare("davinci.review.drawing.shapes.Rectangle", _ShapeCommon, {

	render: function(){ 
		if (!this.shapeNode) {
			this._createRectangle();
			this._evtConns.push(
				dojo.connect(this.shapeNode, "mouseover", this, "onMouseOver"),
				dojo.connect(this.shapeNode, "mouseout", this, "onMouseOut"),
				dojo.connect(this.shapeNode, "mousedown", this, "onMouseDown")
			);
		}
		this._transformRectangle();
		this.inherited(arguments);
	},

	_createRectangle: function() {
		this.shapeNode = dojo.create("div");
		this.width = Math.abs(this.x1 - this.x2);
		this.height = Math.abs(this.y1 - this.y2);
		dojo.style(this.shapeNode, {
			"position": "absolute",
			"padding": "0px",
			"margin": "0px",
			"border": "2px solid " + this.color,
			"width": this.width + "px",
			"height": this.height + "px",
			"MozBorderRadius": "10px",
			"WebkitBorderRadius": "10px",
			"borderRadius": "10px"
		});
		dojo.style(dojo.create("div", null, this.shapeNode), {
			"padding": "0px",
			"margin": "0px",
			"border": "none",
			"width": "100%",
			"height": "100%",
			"backgroundColor": this.color,
			"opacity": "0.05",
			"MozBorderRadius": "6px",
			"WebkitBorderRadius": "6px",
			"borderRadius": "6px"
		});
	},

	_transformRectangle: function() {
		this.width = Math.abs(this.x1 - this.x2);
		this.height = Math.abs(this.y1 - this.y2);
		dojo.style(this.shapeNode, {
			"left": this.x1 + "px",
			"top": this.y1 + "px",
			"width": this.width + "px",
			"height": this.height + "px"
		});
	}

});
});

},
'davinci/review/drawing/shapes/Ellipse':function(){
define([
	"dojo/_base/declare",
	"./_ShapeCommon"
], function(declare, _ShapeCommon) {
	
return declare("davinci.review.drawing.shapes.Ellipse", _ShapeCommon, {

	render: function() {
		if (!this.shapeNode) {
			this._createEllipse();
			this._evtConns.push(
				dojo.connect(this.shapeNode, "mouseover", this, "onMouseOver"),
				dojo.connect(this.shapeNode, "mouseout", this, "onMouseOut"),
				dojo.connect(this.shapeNode, "mousedown", this, "onMouseDown")
			);
		}
		this._transformEllipse();
		this.inherited(arguments);
	},

	destroy: function() {
		this._innerEllipse = null;
		this.inherited(arguments);
	},

	_createEllipse: function() {
		this.shapeNode = dojo.create("div");
		var width = this.width = Math.abs(this.x1 - this.x2),
		height = this.height = Math.abs(this.y1 - this.y2),
		radius = this.radius = (width / 2 + 1) + "px " + (height / 2 + 1) + "px",
		radiusInner = (width / 2 - 1) + "px " + (height / 2 - 1) + "px";

		dojo.style(this.shapeNode, {
			"position": "absolute",
			"padding": "0px",
			"margin": "0px",
			"border": "2px solid " + this.color,
			"width": width + "px",
			"height": height + "px",
			"borderTopLeftRadius": radius,
			"borderTopRightRadius": radius,
			"borderBottomLeftRadius": radius,
			"borderBottomRightRadius": radius,
			"MozBorderRadiusTopleft": radius,
			"MozBorderRadiusTopright": radius,
			"MozBorderRadiusBottomleft": radius,
			"MozBorderRadiusBottomright": radius,
			"WebkitBorderTopLeftRadius": radius,
			"WebkitBorderTopRightRadius": radius,
			"WebkitBorderBottomLeftRadius": radius,
			"WebkitBorderBottomRightRadius": radius
		});
		this._innerEllipse = dojo.create("div", null, this.shapeNode);
		dojo.style(this._innerEllipse, {
			"padding": "0px",
			"margin": "0px",
			"border": "none",
			"width": "100%",
			"height": "100%",
			"backgroundColor": this.color,
			"opacity": "0.05",
			"borderTopLeftRadius": radiusInner,
			"borderTopRightRadius": radiusInner,
			"borderBottomLeftRadius": radiusInner,
			"borderBottomRightRadius": radiusInner,
			"MozBorderRadiusTopleft": radiusInner,
			"MozBorderRadiusTopright": radiusInner,
			"MozBorderRadiusBottomleft": radiusInner,
			"MozBorderRadiusBottomright": radiusInner,
			"WebkitBorderTopLeftRadius": radiusInner,
			"WebkitBorderTopRightRadius": radiusInner,
			"WebkitBorderBottomLeftRadius": radiusInner,
			"WebkitBorderBottomRightRadius": radiusInner
		});
	},

	_transformEllipse: function() {
		var width = this.width = Math.abs(this.x1 - this.x2),
		height = this.height = Math.abs(this.y1 - this.y2),
		radius = this.radius = (width / 2 + 1) + "px " + (height / 2 + 1) + "px",
		radiusInner = (width / 2 - 1) + "px " + (height / 2 - 1) + "px";
		dojo.style(this.shapeNode, {
			"left": this.x1 + "px",
			"top": this.y1 + "px",
			"width": width + "px",
			"height": height + "px",

			"borderTopLeftRadius": radius,
			"borderTopRightRadius": radius,
			"borderBottomLeftRadius": radius,
			"borderBottomRightRadius": radius,
			"MozBorderRadiusTopleft": radius,
			"MozBorderRadiusTopright": radius,
			"MozBorderRadiusBottomleft": radius,
			"MozBorderRadiusBottomright": radius,
			"WebkitBorderTopLeftRadius": radius,
			"WebkitBorderTopRightRadius": radius,
			"WebkitBorderBottomLeftRadius": radius,
			"WebkitBorderBottomRightRadius": radius
		});
		dojo.style(this._innerEllipse, {
			"left": this.x1 + "px",
			"top": this.y1 + "px",
			"borderTopLeftRadius": radiusInner,
			"borderTopRightRadius": radiusInner,
			"borderBottomLeftRadius": radiusInner,
			"borderBottomRightRadius": radiusInner,
			"MozBorderRadiusTopleft": radiusInner,
			"MozBorderRadiusTopright": radiusInner,
			"MozBorderRadiusBottomleft": radiusInner,
			"MozBorderRadiusBottomright": radiusInner,
			"WebkitBorderTopLeftRadius": radiusInner,
			"WebkitBorderTopRightRadius": radiusInner,
			"WebkitBorderBottomLeftRadius": radiusInner,
			"WebkitBorderBottomRightRadius": radiusInner
		});
	}

});
});
},
'davinci/review/drawing/Surface':function(){
define([
	    "dojo/_base/declare"
], function(declare) {
	
return declare("davinci.review.drawing.Surface", null, {

	constructor: function(canvas, /*Document?*/ doc, context) {
		doc = doc || dojo.doc;
		this.canvas = canvas;
		this.context = context;
		this.domNode = canvas === doc.body ? doc : canvas;
		this._tools = [];
		this.shapes = [];
	},

	activate: function() {
		// Set the surface to be ready for drawing
		if(this.highlightTool){
			this.highlightTool.deactivate();
		}
		this.isActivated = true;
	},

	deactivate: function() {
		// Close the surface and disable drawing
		if(this.highlightTool){
			this.highlightTool.activate();
		}
		this.isActivated = false;
	},

	setValueByAttribute: function(/*String*/ attrName, /*Object*/ value, /*String*/targetAttrName, /*Object*/ targetValue) {
		dojo.forEach(this.shapes, function(shape) {
			if (shape[attrName] && shape[attrName] == value) {
				shape[targetAttrName] = targetValue;
			}
		});
	},

	getShapesByAttribute: function(/*String?*/ attrName, /*Array*/ values) {
		var shapes = [];
		dojo.forEach(this.shapes, function(shape) {
			if (!attrName || !values || shape[attrName] && dojo.some(values, function(value) { return shape[attrName] == value; })) {
				shapes.push(shape);
			}
		});
		return shapes;
	},

	style: function(style) {
		var tagName = this.canvas.tagName;
		if (tagName && tagName.toLowerCase() == "body") {
			dojo.style(this.canvas, style);
		} else {
			dojo.style(this.domNode, style);
		}
	},

	appendShape: function(shape) {
		this.shapes.push(shape);
	},

	removeShape: function(shape) {
		if (this.selectTool) {
			this.selectTool.deselectShape();
		}
		for (var i = 0; i < this.shapes.length; i++) {
			if (this.shapes[i] === shape) {
				shape.destroy();
				if (i == this.shapes.length - 1) {
					this.shapes.pop();
				} else {
					this.shapes[i] = this.shapes.pop();
				}
			}
		}
	},

	clear: function() {
		if (this.selectTool) {
			this.selectTool.deselectShape();
		}
		dojo.forEach(this.shapes, function(shape) {
			shape.destroy();
		});
		this.shapes = [];
	},

	// summary:
	//		tags: protected
	appendChild: function(child) {
		return this.canvas.appendChild(child);
	},

	// summary:
	//		tags: protected
	removeChild: function(child) {
		return this.canvas.removeChild(child);
	},

	destroy: function() {
		if (this.selectTool) {
			this.selectTool.deactivate();
			this.selectTool.destroy();
		}
		if (this.createTool) {
			this.createTool.deactivate();
			this.createTool.destroy();
		}
		if (this.exchangeTool) {
			this.exchangeTool.destroy();
		}
		if (this.highlightTool) {
			this.highlightTool.deactivate();
			this.highlightTool.destroy();
		}
		dojo.forEach(this.shapes, function(shape) {
			shape.destroy();
		});
	}

});
});

},
'davinci/review/drawing/shapes/shapes':function(){
define([
"./Arrow",
"./Rectangle",
"./Ellipse",
"./Text"
],
function(Arrow, Rectangle, Ellipse, Text) {

	var shapes = {};
	
	shapes.Arrow     = Arrow;
	shapes.Rectangle = Rectangle;
	shapes.Ellipse   = Ellipse;
	shapes.Text      = Text;

	return dojo.setObject("davinci.review.drawing.shapes", shapes);
});
},
'*now':function(r){r(['dojo/i18n!*preload*davinci/review/editor/nls/ReviewEditor*["ar","ca","cs","da","de","el","en-gb","en-us","es-es","fi-fi","fr-fr","he-il","hu","it-it","ja-jp","ko-kr","nl-nl","nb","pl","pt-br","pt-pt","ru","sk","sl","sv","th","tr","zh-tw","zh-cn","ROOT"]']);}
}});
define("davinci/review/editor/ReviewEditor", [
    "dojo/_base/declare",
    "davinci/ui/ModelEditor",
    "dijit/layout/BorderContainer",
    "dijit/layout/ContentPane",
    "./Context",
	"davinci/Runtime",
	"davinci/model/Path",
	"preview/silhouetteiframe",
	"dojo/i18n!./nls/review",
], function(declare, ModelEditor, BorderContainer, ContentPane, Context, Runtime, Path, SilhouetteIframe, reviewNls) {
	
return declare("davinci.review.editor.ReviewEditor", ModelEditor, {

	isReadOnly: true,

	constructor: function(element) {
		this._bc = new BorderContainer({}, element);
		this.domNode = this._bc.domNode;
		this._designCP = new ContentPane({region:'center'});
		this._bc.addChild(this._designCP);
		var content = '<div class="silhouette_div_container">'+
			'<span class="silhouetteiframe_object_container"></span>'+
			'</div>';
		this._designCP.set('content', content);
		var silhouette_div_container=dojo.query('.silhouette_div_container',this._designCP.domNode)[0];
		this.silhouetteiframe = new SilhouetteIframe({
			rootNode:silhouette_div_container,
			margin:20
		});

		this._bc.startup();
		this._bc.resize();
		this.isReadOnly = true;
		dojo.subscribe("/davinci/review/resourceChanged", this, function(arg1,arg2,arg3) {
			if (arg2!="open"&&arg2!="closed" || !this.resourceFile) {
				return;
			}
			var version = this.resourceFile.parent;
			if (version.timeStamp == arg3.timeStamp) {
				davinci.review.model.resource.root.findFile(version.timeStamp, this.resourceFile.name).then(function(node) {
					this.resourceFile = node;
				}.bind(this));
			}

		});
	},
	save: function(){
		// no-op.  editor not saved, comments are submitted
	},
	supports: function(something) {
		return something=="states";
	},

	getContext: function() {
		return this.context;
	},

	setContent: function(filename, content) {
		
		this.fileName = filename;
		this.basePath = new Path(filename);
		// URL will always be http://localhost:8080/davinci/review without / at the end at present
		var locationPath = new Path(Runtime.location());

		var designerName = this.resourceFile.parent.designerId;
		// Compose a URL like http://localhost:8080/davinci/review/user/heguyi/ws/workspace/.review/snapshot/20100101/folder1/sample1.html
		var baseUrl = locationPath.append("user").append(designerName)
			.append("ws").append("workspace").append(filename.replace(/:/g, "%3A")).toString();

		var containerNode = dojo.query('.silhouette_div_container',this._designCP.domNode)[0];
		this.context = new Context({
			containerNode: containerNode,
			baseURL: baseUrl,
			fileName: this.fileName,
			resourceFile: this.resourceFile,
			containerEditor: this,
			iframeattrs: {'class': 'silhouetteiframe_iframe'}
		});

		this.title = dojo.doc.title;
		this.context.setSource();
	},

	destroy: function() {
		 //Clear any pending comment from view cache
		if (this.context){
			if(this.context._commentView) {
				this.context._commentView._setPendingEditComment(this, null);
			}
			if(this.context.destroy){
				this.context.destroy();
			}
		}
		this.inherited(arguments);
	},

	onResize: function() {

	},
	
	getFileNameToDisplay: function() {
		var newFileName = this.fileName;
		var parts = newFileName.split('/');
		if(parts.length > 3){
			// Remove leading .review/snapshots/NNNNN/
			parts.splice(0, 3);
			newFileName = parts.join('/');
		}
		//FIXME: Shouldn't hard-code, instead should pull from plugin file
		return newFileName+'.rev';
	},

	/* Gets called before browser page is unloaded to give 
	 * editor a chance to warn the user they may lose data if
	 * they continue. Should return a message to display to the user
	 * if a warning is needed or null if there is no need to warn the
	 * user of anything. In browsers such as FF 4, the message shown
	 * will be the browser default rather than the returned value.
	 * 
	 * NOTE: With auto-save, _not_ typically needed by most editors.
	 */
	getOnUnloadWarningMessage: function() {
		var message = null;
		if (this.isDirty) {
			message = dojo.string.substitute(reviewNls.unsavedComment, [
				this.editorContainer._getTitle()
			]);
		}
		return message;
	}
});
});
