/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dijit/popup":function(){
define("dijit/popup",["dojo/_base/array","dojo/aspect","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/_base/event","dojo/keys","dojo/_base/lang","dojo/on","dojo/sniff","./place","./BackgroundIframe","./main"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,on,_d,_e,_f,_10){
function _11(){
if(this._popupWrapper){
_7.destroy(this._popupWrapper);
delete this._popupWrapper;
}
};
var _12=_4(null,{_stack:[],_beginZIndex:1000,_idGen:1,_createWrapper:function(_13){
var _14=_13._popupWrapper,_15=_13.domNode;
if(!_14){
_14=_7.create("div",{"class":"dijitPopup",style:{display:"none"},role:"presentation"},_13.ownerDocumentBody);
_14.appendChild(_15);
var s=_15.style;
s.display="";
s.visibility="";
s.position="";
s.top="0px";
_13._popupWrapper=_14;
_2.after(_13,"destroy",_11,true);
}
return _14;
},moveOffScreen:function(_16){
var _17=this._createWrapper(_16);
_9.set(_17,{visibility:"hidden",top:"-9999px",display:""});
},hide:function(_18){
var _19=this._createWrapper(_18);
_9.set(_19,"display","none");
},getTopPopup:function(){
var _1a=this._stack;
for(var pi=_1a.length-1;pi>0&&_1a[pi].parent===_1a[pi-1].widget;pi--){
}
return _1a[pi];
},open:function(_1b){
var _1c=this._stack,_1d=_1b.popup,_1e=_1b.orient||["below","below-alt","above","above-alt"],ltr=_1b.parent?_1b.parent.isLeftToRight():_8.isBodyLtr(_1d.ownerDocument),_1f=_1b.around,id=(_1b.around&&_1b.around.id)?(_1b.around.id+"_dropdown"):("popup_"+this._idGen++);
while(_1c.length&&(!_1b.parent||!_5.isDescendant(_1b.parent.domNode,_1c[_1c.length-1].widget.domNode))){
this.close(_1c[_1c.length-1].widget);
}
var _20=this._createWrapper(_1d);
_6.set(_20,{id:id,style:{zIndex:this._beginZIndex+_1c.length},"class":"dijitPopup "+(_1d.baseClass||_1d["class"]||"").split(" ")[0]+"Popup",dijitPopupParent:_1b.parent?_1b.parent.id:""});
if(_d("ie")||_d("mozilla")){
if(!_1d.bgIframe){
_1d.bgIframe=new _f(_20);
}
}
var _21=_1f?_e.around(_20,_1f,_1e,ltr,_1d.orient?_c.hitch(_1d,"orient"):null):_e.at(_20,_1b,_1e=="R"?["TR","BR","TL","BL"]:["TL","BL","TR","BR"],_1b.padding);
_20.style.display="";
_20.style.visibility="visible";
_1d.domNode.style.visibility="visible";
var _22=[];
_22.push(on(_20,_3._keypress,_c.hitch(this,function(evt){
if(evt.charOrCode==_b.ESCAPE&&_1b.onCancel){
_a.stop(evt);
_1b.onCancel();
}else{
if(evt.charOrCode===_b.TAB){
_a.stop(evt);
var _23=this.getTopPopup();
if(_23&&_23.onCancel){
_23.onCancel();
}
}
}
})));
if(_1d.onCancel&&_1b.onCancel){
_22.push(_1d.on("cancel",_1b.onCancel));
}
_22.push(_1d.on(_1d.onExecute?"execute":"change",_c.hitch(this,function(){
var _24=this.getTopPopup();
if(_24&&_24.onExecute){
_24.onExecute();
}
})));
_1c.push({widget:_1d,parent:_1b.parent,onExecute:_1b.onExecute,onCancel:_1b.onCancel,onClose:_1b.onClose,handlers:_22});
if(_1d.onOpen){
_1d.onOpen(_21);
}
return _21;
},close:function(_25){
var _26=this._stack;
while((_25&&_1.some(_26,function(_27){
return _27.widget==_25;
}))||(!_25&&_26.length)){
var top=_26.pop(),_28=top.widget,_29=top.onClose;
if(_28.onClose){
_28.onClose();
}
var h;
while(h=top.handlers.pop()){
h.remove();
}
if(_28&&_28.domNode){
this.hide(_28);
}
if(_29){
_29();
}
}
}});
return (_10.popup=new _12());
});
},"dojo/string":function(){
define(["./_base/kernel","./_base/lang"],function(_2a,_2b){
var _2c={};
_2b.setObject("dojo.string",_2c);
_2c.rep=function(str,num){
if(num<=0||!str){
return "";
}
var buf=[];
for(;;){
if(num&1){
buf.push(str);
}
if(!(num>>=1)){
break;
}
str+=str;
}
return buf.join("");
};
_2c.pad=function(_2d,_2e,ch,end){
if(!ch){
ch="0";
}
var out=String(_2d),pad=_2c.rep(ch,Math.ceil((_2e-out.length)/ch.length));
return end?out+pad:pad+out;
};
_2c.substitute=function(_2f,map,_30,_31){
_31=_31||_2a.global;
_30=_30?_2b.hitch(_31,_30):function(v){
return v;
};
return _2f.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_32,key,_33){
var _34=_2b.getObject(key,false,map);
if(_33){
_34=_2b.getObject(_33,false,_31).call(_31,_34,key);
}
return _30(_34,key).toString();
});
};
_2c.trim=String.prototype.trim?_2b.trim:function(str){
str=str.replace(/^\s+/,"");
for(var i=str.length-1;i>=0;i--){
if(/\S/.test(str.charAt(i))){
str=str.substring(0,i+1);
break;
}
}
return str;
};
return _2c;
});
},"dijit/a11y":function(){
define("dijit/a11y",["dojo/_base/array","dojo/_base/config","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/sniff","./main"],function(_35,_36,_37,dom,_38,_39,has,_3a){
var _3b=(_3a._isElementShown=function(_3c){
var s=_39.get(_3c);
return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_38.get(_3c,"type")!="hidden");
});
_3a.hasDefaultTabStop=function(_3d){
switch(_3d.nodeName.toLowerCase()){
case "a":
return _38.has(_3d,"href");
case "area":
case "button":
case "input":
case "object":
case "select":
case "textarea":
return true;
case "iframe":
var _3e;
try{
var _3f=_3d.contentDocument;
if("designMode" in _3f&&_3f.designMode=="on"){
return true;
}
_3e=_3f.body;
}
catch(e1){
try{
_3e=_3d.contentWindow.document.body;
}
catch(e2){
return false;
}
}
return _3e&&(_3e.contentEditable=="true"||(_3e.firstChild&&_3e.firstChild.contentEditable=="true"));
default:
return _3d.contentEditable=="true";
}
};
var _40=(_3a.isTabNavigable=function(_41){
if(_38.get(_41,"disabled")){
return false;
}else{
if(_38.has(_41,"tabIndex")){
return _38.get(_41,"tabIndex")>=0;
}else{
return _3a.hasDefaultTabStop(_41);
}
}
});
_3a._getTabNavigable=function(_42){
var _43,_44,_45,_46,_47,_48,_49={};
function _4a(_4b){
return _4b&&_4b.tagName.toLowerCase()=="input"&&_4b.type&&_4b.type.toLowerCase()=="radio"&&_4b.name&&_4b.name.toLowerCase();
};
var _4c=function(_4d){
for(var _4e=_4d.firstChild;_4e;_4e=_4e.nextSibling){
if(_4e.nodeType!=1||(has("ie")<=9&&_4e.scopeName!=="HTML")||!_3b(_4e)){
continue;
}
if(_40(_4e)){
var _4f=+_38.get(_4e,"tabIndex");
if(!_38.has(_4e,"tabIndex")||_4f==0){
if(!_43){
_43=_4e;
}
_44=_4e;
}else{
if(_4f>0){
if(!_45||_4f<_46){
_46=_4f;
_45=_4e;
}
if(!_47||_4f>=_48){
_48=_4f;
_47=_4e;
}
}
}
var rn=_4a(_4e);
if(_38.get(_4e,"checked")&&rn){
_49[rn]=_4e;
}
}
if(_4e.nodeName.toUpperCase()!="SELECT"){
_4c(_4e);
}
}
};
if(_3b(_42)){
_4c(_42);
}
function rs(_50){
return _49[_4a(_50)]||_50;
};
return {first:rs(_43),last:rs(_44),lowest:rs(_45),highest:rs(_47)};
};
_3a.getFirstInTabbingOrder=function(_51,doc){
var _52=_3a._getTabNavigable(dom.byId(_51,doc));
return _52.lowest?_52.lowest:_52.first;
};
_3a.getLastInTabbingOrder=function(_53,doc){
var _54=_3a._getTabNavigable(dom.byId(_53,doc));
return _54.last?_54.last:_54.highest;
};
return {hasDefaultTabStop:_3a.hasDefaultTabStop,isTabNavigable:_3a.isTabNavigable,_getTabNavigable:_3a._getTabNavigable,getFirstInTabbingOrder:_3a.getFirstInTabbingOrder,getLastInTabbingOrder:_3a.getLastInTabbingOrder};
});
},"dijit/WidgetSet":function(){
define("dijit/WidgetSet",["dojo/_base/array","dojo/_base/declare","dojo/_base/kernel","./registry"],function(_55,_56,_57,_58){
var _59=_56("dijit.WidgetSet",null,{constructor:function(){
this._hash={};
this.length=0;
},add:function(_5a){
if(this._hash[_5a.id]){
throw new Error("Tried to register widget with id=="+_5a.id+" but that id is already registered");
}
this._hash[_5a.id]=_5a;
this.length++;
},remove:function(id){
if(this._hash[id]){
delete this._hash[id];
this.length--;
}
},forEach:function(_5b,_5c){
_5c=_5c||_57.global;
var i=0,id;
for(id in this._hash){
_5b.call(_5c,this._hash[id],i++,this._hash);
}
return this;
},filter:function(_5d,_5e){
_5e=_5e||_57.global;
var res=new _59(),i=0,id;
for(id in this._hash){
var w=this._hash[id];
if(_5d.call(_5e,w,i++,this._hash)){
res.add(w);
}
}
return res;
},byId:function(id){
return this._hash[id];
},byClass:function(cls){
var res=new _59(),id,_5f;
for(id in this._hash){
_5f=this._hash[id];
if(_5f.declaredClass==cls){
res.add(_5f);
}
}
return res;
},toArray:function(){
var ar=[];
for(var id in this._hash){
ar.push(this._hash[id]);
}
return ar;
},map:function(_60,_61){
return _55.map(this.toArray(),_60,_61);
},every:function(_62,_63){
_63=_63||_57.global;
var x=0,i;
for(i in this._hash){
if(!_62.call(_63,this._hash[i],x++,this._hash)){
return false;
}
}
return true;
},some:function(_64,_65){
_65=_65||_57.global;
var x=0,i;
for(i in this._hash){
if(_64.call(_65,this._hash[i],x++,this._hash)){
return true;
}
}
return false;
}});
_55.forEach(["forEach","filter","byClass","map","every","some"],function(_66){
_58[_66]=_59.prototype[_66];
});
return _59;
});
},"dijit/_base/wai":function(){
define("dijit/_base/wai",["dojo/dom-attr","dojo/_base/lang","../main","../hccss"],function(_67,_68,_69){
var _6a={hasWaiRole:function(_6b,_6c){
var _6d=this.getWaiRole(_6b);
return _6c?(_6d.indexOf(_6c)>-1):(_6d.length>0);
},getWaiRole:function(_6e){
return _68.trim((_67.get(_6e,"role")||"").replace("wairole:",""));
},setWaiRole:function(_6f,_70){
_67.set(_6f,"role",_70);
},removeWaiRole:function(_71,_72){
var _73=_67.get(_71,"role");
if(!_73){
return;
}
if(_72){
var t=_68.trim((" "+_73+" ").replace(" "+_72+" "," "));
_67.set(_71,"role",t);
}else{
_71.removeAttribute("role");
}
},hasWaiState:function(_74,_75){
return _74.hasAttribute?_74.hasAttribute("aria-"+_75):!!_74.getAttribute("aria-"+_75);
},getWaiState:function(_76,_77){
return _76.getAttribute("aria-"+_77)||"";
},setWaiState:function(_78,_79,_7a){
_78.setAttribute("aria-"+_79,_7a);
},removeWaiState:function(_7b,_7c){
_7b.removeAttribute("aria-"+_7c);
}};
_68.mixin(_69,_6a);
return _69;
});
},"dijit/Viewport":function(){
define("dijit/Viewport",["dojo/Evented","dojo/on","dojo/ready","dojo/sniff","dojo/_base/window","dojo/window"],function(_7d,on,_7e,has,win,_7f){
var _80=new _7d();
_7e(200,function(){
var _81=_7f.getBox();
_80._rlh=on(win.global,"resize",function(){
var _82=_7f.getBox();
if(_81.h==_82.h&&_81.w==_82.w){
return;
}
_81=_82;
_80.emit("resize");
});
if(has("ie")==8){
var _83=screen.deviceXDPI;
setInterval(function(){
if(screen.deviceXDPI!=_83){
_83=screen.deviceXDPI;
_80.emit("resize");
}
},500);
}
});
return _80;
});
},"dojo/hccss":function(){
define(["require","./_base/config","./dom-class","./dom-style","./has","./ready","./_base/window"],function(_84,_85,_86,_87,has,_88,win){
has.add("highcontrast",function(){
var div=win.doc.createElement("div");
div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url("+(_85.blankGif||_84.toUrl("./resources/blank.gif"))+");";
win.body().appendChild(div);
var cs=_87.getComputedStyle(div),_89=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_89&&(_89=="none"||_89=="url(invalid-url:)"));
if(has("ie")<=8){
div.outerHTML="";
}else{
win.body().removeChild(div);
}
return hc;
});
_88(90,function(){
if(has("highcontrast")){
_86.add(win.body(),"dj_a11y");
}
});
return has;
});
},"dijit/_WidgetBase":function(){
define("dijit/_WidgetBase",["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","./registry"],function(_8a,_8b,_8c,_8d,_8e,_8f,dom,_90,_91,_92,_93,_94,has,_95,_96,on,_97,_98,_99,win,_9a,_9b){
has.add("dijit-legacy-requires",!_95.isAsync);
if(has("dijit-legacy-requires")){
_97(0,function(){
var _9c=["dijit/_base/manager"];
_8a(_9c);
});
}
var _9d={};
function _9e(obj){
var ret={};
for(var _9f in obj){
ret[_9f.toLowerCase()]=true;
}
return ret;
};
function _a0(_a1){
return function(val){
_90[val?"set":"remove"](this.domNode,_a1,val);
this._set(_a1,val);
};
};
return _8f("dijit._WidgetBase",[_98,_9a],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_a0("lang"),dir:"",_setDirAttr:_a0("dir"),textDir:"","class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){
this._set("ownerDocument",val);
},attributeMap:{},_blankGif:_8d.blankGif||_8a.toUrl("dojo/resources/blank.gif"),postscript:function(_a2,_a3){
this.create(_a2,_a3);
},create:function(_a4,_a5){
this.srcNodeRef=dom.byId(_a5);
this._connects=[];
this._supportingWidgets=[];
if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){
this.id=this.srcNodeRef.id;
}
if(_a4){
this.params=_a4;
_96.mixin(this,_a4);
}
this.postMixInProperties();
if(!this.id){
this.id=_9b.getUniqueId(this.declaredClass.replace(/\./g,"_"));
if(this.params){
delete this.params.id;
}
}
this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:win.doc);
this.ownerDocumentBody=win.body(this.ownerDocument);
_9b.add(this);
this.buildRendering();
var _a6;
if(this.domNode){
this._applyAttributes();
var _a7=this.srcNodeRef;
if(_a7&&_a7.parentNode&&this.domNode!==_a7){
_a7.parentNode.replaceChild(this.domNode,_a7);
_a6=true;
}
this.domNode.setAttribute("widgetId",this.id);
}
this.postCreate();
if(_a6){
delete this.srcNodeRef;
}
this._created=true;
},_applyAttributes:function(){
var _a8=this.constructor,_a9=_a8._setterAttrs;
if(!_a9){
_a9=(_a8._setterAttrs=[]);
for(var _aa in this.attributeMap){
_a9.push(_aa);
}
var _ab=_a8.prototype;
for(var _ac in _ab){
if(_ac in this.attributeMap){
continue;
}
var _ad="_set"+_ac.replace(/^[a-z]|-[a-zA-Z]/g,function(c){
return c.charAt(c.length-1).toUpperCase();
})+"Attr";
if(_ad in _ab){
_a9.push(_ac);
}
}
}
var _ae={};
for(var key in this.params||{}){
_ae[key]=this[key];
}
_8b.forEach(_a9,function(_af){
if(_af in _ae){
}else{
if(this[_af]){
this.set(_af,this[_af]);
}
}
},this);
for(key in _ae){
this.set(key,_ae[key]);
}
},postMixInProperties:function(){
},buildRendering:function(){
if(!this.domNode){
this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");
}
if(this.baseClass){
var _b0=this.baseClass.split(" ");
if(!this.isLeftToRight()){
_b0=_b0.concat(_8b.map(_b0,function(_b1){
return _b1+"Rtl";
}));
}
_91.add(this.domNode,_b0);
}
},postCreate:function(){
},startup:function(){
if(this._started){
return;
}
this._started=true;
_8b.forEach(this.getChildren(),function(obj){
if(!obj._started&&!obj._destroyed&&_96.isFunction(obj.startup)){
obj.startup();
obj._started=true;
}
});
},destroyRecursive:function(_b2){
this._beingDestroyed=true;
this.destroyDescendants(_b2);
this.destroy(_b2);
},destroy:function(_b3){
this._beingDestroyed=true;
this.uninitialize();
function _b4(w){
if(w.destroyRecursive){
w.destroyRecursive(_b3);
}else{
if(w.destroy){
w.destroy(_b3);
}
}
};
_8b.forEach(this._connects,_96.hitch(this,"disconnect"));
_8b.forEach(this._supportingWidgets,_b4);
if(this.domNode){
_8b.forEach(_9b.findWidgets(this.domNode,this.containerNode),_b4);
}
this.destroyRendering(_b3);
_9b.remove(this.id);
this._destroyed=true;
},destroyRendering:function(_b5){
if(this.bgIframe){
this.bgIframe.destroy(_b5);
delete this.bgIframe;
}
if(this.domNode){
if(_b5){
_90.remove(this.domNode,"widgetId");
}else{
_92.destroy(this.domNode);
}
delete this.domNode;
}
if(this.srcNodeRef){
if(!_b5){
_92.destroy(this.srcNodeRef);
}
delete this.srcNodeRef;
}
},destroyDescendants:function(_b6){
_8b.forEach(this.getChildren(),function(_b7){
if(_b7.destroyRecursive){
_b7.destroyRecursive(_b6);
}
});
},uninitialize:function(){
return false;
},_setStyleAttr:function(_b8){
var _b9=this.domNode;
if(_96.isObject(_b8)){
_94.set(_b9,_b8);
}else{
if(_b9.style.cssText){
_b9.style.cssText+="; "+_b8;
}else{
_b9.style.cssText=_b8;
}
}
this._set("style",_b8);
},_attrToDom:function(_ba,_bb,_bc){
_bc=arguments.length>=3?_bc:this.attributeMap[_ba];
_8b.forEach(_96.isArray(_bc)?_bc:[_bc],function(_bd){
var _be=this[_bd.node||_bd||"domNode"];
var _bf=_bd.type||"attribute";
switch(_bf){
case "attribute":
if(_96.isFunction(_bb)){
_bb=_96.hitch(this,_bb);
}
var _c0=_bd.attribute?_bd.attribute:(/^on[A-Z][a-zA-Z]*$/.test(_ba)?_ba.toLowerCase():_ba);
if(_be.tagName){
_90.set(_be,_c0,_bb);
}else{
_be.set(_c0,_bb);
}
break;
case "innerText":
_be.innerHTML="";
_be.appendChild(this.ownerDocument.createTextNode(_bb));
break;
case "innerHTML":
_be.innerHTML=_bb;
break;
case "class":
_91.replace(_be,_bb,this[_ba]);
break;
}
},this);
},get:function(_c1){
var _c2=this._getAttrNames(_c1);
return this[_c2.g]?this[_c2.g]():this[_c1];
},set:function(_c3,_c4){
if(typeof _c3==="object"){
for(var x in _c3){
this.set(x,_c3[x]);
}
return this;
}
var _c5=this._getAttrNames(_c3),_c6=this[_c5.s];
if(_96.isFunction(_c6)){
var _c7=_c6.apply(this,Array.prototype.slice.call(arguments,1));
}else{
var _c8=this.focusNode&&!_96.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_c8].tagName,_c9=_9d[tag]||(_9d[tag]=_9e(this[_c8])),map=_c3 in this.attributeMap?this.attributeMap[_c3]:_c5.s in this?this[_c5.s]:((_c5.l in _c9&&typeof _c4!="function")||/^aria-|^data-|^role$/.test(_c3))?_c8:null;
if(map!=null){
this._attrToDom(_c3,_c4,map);
}
this._set(_c3,_c4);
}
return _c7||this;
},_attrPairNames:{},_getAttrNames:function(_ca){
var apn=this._attrPairNames;
if(apn[_ca]){
return apn[_ca];
}
var uc=_ca.replace(/^[a-z]|-[a-zA-Z]/g,function(c){
return c.charAt(c.length-1).toUpperCase();
});
return (apn[_ca]={n:_ca+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});
},_set:function(_cb,_cc){
var _cd=this[_cb];
this[_cb]=_cc;
if(this._created&&_cc!==_cd){
if(this._watchCallbacks){
this._watchCallbacks(_cb,_cd,_cc);
}
this.emit("attrmodified-"+_cb,{detail:{prevValue:_cd,newValue:_cc}});
}
},emit:function(_ce,_cf,_d0){
_cf=_cf||{};
if(_cf.bubbles===undefined){
_cf.bubbles=true;
}
if(_cf.cancelable===undefined){
_cf.cancelable=true;
}
if(!_cf.detail){
_cf.detail={};
}
_cf.detail.widget=this;
var ret,_d1=this["on"+_ce];
if(_d1){
ret=_d1.apply(this,_d0?_d0:[_cf]);
}
if(this._started&&!this._beingDestroyed){
on.emit(this.domNode,_ce.toLowerCase(),_cf);
}
return ret;
},on:function(_d2,_d3){
var _d4=this._onMap(_d2);
if(_d4){
return _8c.after(this,_d4,_d3,true);
}
return this.own(on(this.domNode,_d2,_d3))[0];
},_onMap:function(_d5){
var _d6=this.constructor,map=_d6._onMap;
if(!map){
map=(_d6._onMap={});
for(var _d7 in _d6.prototype){
if(/^on/.test(_d7)){
map[_d7.replace(/^on/,"").toLowerCase()]=_d7;
}
}
}
return map[typeof _d5=="string"&&_d5.toLowerCase()];
},toString:function(){
return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";
},getChildren:function(){
return this.containerNode?_9b.findWidgets(this.containerNode):[];
},getParent:function(){
return _9b.getEnclosingWidget(this.domNode.parentNode);
},connect:function(obj,_d8,_d9){
return this.own(_8e.connect(obj,_d8,this,_d9))[0];
},disconnect:function(_da){
_da.remove();
},subscribe:function(t,_db){
return this.own(_99.subscribe(t,_96.hitch(this,_db)))[0];
},unsubscribe:function(_dc){
_dc.remove();
},isLeftToRight:function(){
return this.dir?(this.dir=="ltr"):_93.isBodyLtr(this.ownerDocument);
},isFocusable:function(){
return this.focus&&(_94.get(this.domNode,"display")!="none");
},placeAt:function(_dd,_de){
var _df=!_dd.tagName&&_9b.byId(_dd);
if(_df&&_df.addChild&&(!_de||typeof _de==="number")){
_df.addChild(this,_de);
}else{
var ref=_df?(_df.containerNode&&!/after|before|replace/.test(_de||"")?_df.containerNode:_df.domNode):dom.byId(_dd,this.ownerDocument);
_92.place(this.domNode,ref,_de);
if(!this._started&&(this.getParent()||{})._started){
this.startup();
}
}
return this;
},getTextDir:function(_e0,_e1){
return _e1;
},applyTextDir:function(){
},defer:function(fcn,_e2){
var _e3=setTimeout(_96.hitch(this,function(){
_e3=null;
if(!this._destroyed){
_96.hitch(this,fcn)();
}
}),_e2||0);
return {remove:function(){
if(_e3){
clearTimeout(_e3);
_e3=null;
}
return null;
}};
}});
});
},"dijit/_base":function(){
define("dijit/_base",["./main","./a11y","./WidgetSet","./_base/focus","./_base/manager","./_base/place","./_base/popup","./_base/scroll","./_base/sniff","./_base/typematic","./_base/wai","./_base/window"],function(_e4){
return _e4._base;
});
},"dojo/touch":function(){
define(["./_base/kernel","./aspect","./dom","./on","./has","./mouse","./ready","./_base/window"],function(_e5,_e6,dom,on,has,_e7,_e8,win){
var _e9=has("touch");
var _ea=false;
if(has("ios")){
var ua=navigator.userAgent;
var v=ua.match(/OS ([\d_]+)/)?RegExp.$1:"1";
var os=parseFloat(v.replace(/_/,".").replace(/_/g,""));
_ea=os<5;
}
var _eb,_ec;
if(_e9){
_e8(function(){
_ec=win.body();
win.doc.addEventListener("touchstart",function(evt){
var _ed=_ec;
_ec=evt.target;
on.emit(_ed,"dojotouchout",{target:_ed,relatedTarget:_ec,bubbles:true});
on.emit(_ec,"dojotouchover",{target:_ec,relatedTarget:_ed,bubbles:true});
},true);
on(win.doc,"touchmove",function(evt){
var _ee=win.doc.elementFromPoint(evt.pageX-(_ea?0:win.global.pageXOffset),evt.pageY-(_ea?0:win.global.pageYOffset));
if(_ee&&_ec!==_ee){
on.emit(_ec,"dojotouchout",{target:_ec,relatedTarget:_ee,bubbles:true});
on.emit(_ee,"dojotouchover",{target:_ee,relatedTarget:_ec,bubbles:true});
_ec=_ee;
}
});
});
_eb=function(_ef,_f0){
return on(win.doc,"touchmove",function(evt){
if(_ef===win.doc||dom.isDescendant(_ec,_ef)){
evt.target=_ec;
_f0.call(this,evt);
}
});
};
}
function _f1(_f2){
return function(_f3,_f4){
return on(_f3,_f2,_f4);
};
};
var _f5={press:_f1(_e9?"touchstart":"mousedown"),move:_e9?_eb:_f1("mousemove"),release:_f1(_e9?"touchend":"mouseup"),cancel:_e9?_f1("touchcancel"):_e7.leave,over:_f1(_e9?"dojotouchover":"mouseover"),out:_f1(_e9?"dojotouchout":"mouseout"),enter:_e7._eventHandler(_e9?"dojotouchover":"mouseover"),leave:_e7._eventHandler(_e9?"dojotouchout":"mouseout")};
1&&(_e5.touch=_f5);
return _f5;
});
},"dijit/form/_FormValueMixin":function(){
define("dijit/form/_FormValueMixin",["dojo/_base/declare","dojo/dom-attr","dojo/keys","dojo/sniff","./_FormWidgetMixin"],function(_f6,_f7,_f8,has,_f9){
return _f6("dijit.form._FormValueMixin",_f9,{readOnly:false,_setReadOnlyAttr:function(_fa){
_f7.set(this.focusNode,"readOnly",_fa);
this._set("readOnly",_fa);
},postCreate:function(){
this.inherited(arguments);
if(has("ie")){
this.connect(this.focusNode||this.domNode,"onkeydown",this._onKeyDown);
}
if(this._resetValue===undefined){
this._lastValueReported=this._resetValue=this.value;
}
},_setValueAttr:function(_fb,_fc){
this._handleOnChange(_fb,_fc);
},_handleOnChange:function(_fd,_fe){
this._set("value",_fd);
this.inherited(arguments);
},undo:function(){
this._setValueAttr(this._lastValueReported,false);
},reset:function(){
this._hasBeenBlurred=false;
this._setValueAttr(this._resetValue,true);
},_onKeyDown:function(e){
if(e.keyCode==_f8.ESCAPE&&!(e.ctrlKey||e.altKey||e.metaKey)){
if(has("ie")<9||(has("ie")&&has("quirks"))){
e.preventDefault();
var _ff=e.srcElement,te=_ff.ownerDocument.createEventObject();
te.keyCode=_f8.ESCAPE;
te.shiftKey=e.shiftKey;
_ff.fireEvent("onkeypress",te);
}
}
}});
});
},"dojo/Stateful":function(){
define(["./_base/declare","./_base/lang","./_base/array","dojo/when"],function(_100,lang,_101,when){
return _100("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){
var apn=this._attrPairNames;
if(apn[name]){
return apn[name];
}
return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});
},postscript:function(_102){
if(_102){
this.set(_102);
}
},_get:function(name,_103){
return typeof this[_103.g]==="function"?this[_103.g]():this[name];
},get:function(name){
return this._get(name,this._getAttrNames(name));
},set:function(name,_104){
if(typeof name==="object"){
for(var x in name){
if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){
this.set(x,name[x]);
}
}
return this;
}
var _105=this._getAttrNames(name),_106=this._get(name,_105),_107=this[_105.s],_108;
if(typeof _107==="function"){
_108=_107.apply(this,Array.prototype.slice.call(arguments,1));
}else{
this[name]=_104;
}
if(this._watchCallbacks){
var self=this;
when(_108,function(){
self._watchCallbacks(name,_106,_104);
});
}
return this;
},_changeAttrValue:function(name,_109){
var _10a=this.get(name);
this[name]=_109;
if(this._watchCallbacks){
this._watchCallbacks(name,_10a,_109);
}
return this;
},watch:function(name,_10b){
var _10c=this._watchCallbacks;
if(!_10c){
var self=this;
_10c=this._watchCallbacks=function(name,_10d,_10e,_10f){
var _110=function(_111){
if(_111){
_111=_111.slice();
for(var i=0,l=_111.length;i<l;i++){
_111[i].call(self,name,_10d,_10e);
}
}
};
_110(_10c["_"+name]);
if(!_10f){
_110(_10c["*"]);
}
};
}
if(!_10b&&typeof name==="function"){
_10b=name;
name="*";
}else{
name="_"+name;
}
var _112=_10c[name];
if(typeof _112!=="object"){
_112=_10c[name]=[];
}
_112.push(_10b);
var _113={};
_113.unwatch=_113.remove=function(){
var _114=_101.indexOf(_112,_10b);
if(_114>-1){
_112.splice(_114,1);
}
};
return _113;
}});
});
},"dijit/_CssStateMixin":function(){
define("dijit/_CssStateMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/_base/window","./registry"],function(_115,_116,dom,_117,has,lang,on,_118,win,_119){
var _11a=_116("dijit._CssStateMixin",[],{cssStateNodes:{},hovering:false,active:false,_applyAttributes:function(){
this.inherited(arguments);
_115.forEach(["disabled","readOnly","checked","selected","focused","state","hovering","active","_opened"],function(attr){
this.watch(attr,lang.hitch(this,"_setStateClass"));
},this);
for(var ap in this.cssStateNodes){
this._trackMouseState(this[ap],this.cssStateNodes[ap]);
}
this._trackMouseState(this.domNode,this.baseClass);
this._setStateClass();
},_cssMouseEvent:function(_11b){
if(!this.disabled){
switch(_11b.type){
case "mouseover":
this._set("hovering",true);
this._set("active",this._mouseDown);
break;
case "mouseout":
this._set("hovering",false);
this._set("active",false);
break;
case "mousedown":
case "touchstart":
this._set("active",true);
break;
case "mouseup":
case "touchend":
this._set("active",false);
break;
}
}
},_setStateClass:function(){
var _11c=this.baseClass.split(" ");
function _11d(_11e){
_11c=_11c.concat(_115.map(_11c,function(c){
return c+_11e;
}),"dijit"+_11e);
};
if(!this.isLeftToRight()){
_11d("Rtl");
}
var _11f=this.checked=="mixed"?"Mixed":(this.checked?"Checked":"");
if(this.checked){
_11d(_11f);
}
if(this.state){
_11d(this.state);
}
if(this.selected){
_11d("Selected");
}
if(this._opened){
_11d("Opened");
}
if(this.disabled){
_11d("Disabled");
}else{
if(this.readOnly){
_11d("ReadOnly");
}else{
if(this.active){
_11d("Active");
}else{
if(this.hovering){
_11d("Hover");
}
}
}
}
if(this.focused){
_11d("Focused");
}
var tn=this.stateNode||this.domNode,_120={};
_115.forEach(tn.className.split(" "),function(c){
_120[c]=true;
});
if("_stateClasses" in this){
_115.forEach(this._stateClasses,function(c){
delete _120[c];
});
}
_115.forEach(_11c,function(c){
_120[c]=true;
});
var _121=[];
for(var c in _120){
_121.push(c);
}
tn.className=_121.join(" ");
this._stateClasses=_11c;
},_subnodeCssMouseEvent:function(node,_122,evt){
if(this.disabled||this.readOnly){
return;
}
function _123(_124){
_117.toggle(node,_122+"Hover",_124);
};
function _125(_126){
_117.toggle(node,_122+"Active",_126);
};
function _127(_128){
_117.toggle(node,_122+"Focused",_128);
};
switch(evt.type){
case "mouseover":
_123(true);
break;
case "mouseout":
_123(false);
_125(false);
break;
case "mousedown":
case "touchstart":
_125(true);
break;
case "mouseup":
case "touchend":
_125(false);
break;
case "focus":
case "focusin":
_127(true);
break;
case "blur":
case "focusout":
_127(false);
break;
}
},_trackMouseState:function(node,_129){
node._cssState=_129;
}});
_118(function(){
function _12a(evt){
if(!dom.isDescendant(evt.relatedTarget,evt.target)){
for(var node=evt.target;node&&node!=evt.relatedTarget;node=node.parentNode){
if(node._cssState){
var _12b=_119.getEnclosingWidget(node);
if(_12b){
if(node==_12b.domNode){
_12b._cssMouseEvent(evt);
}else{
_12b._subnodeCssMouseEvent(node,node._cssState,evt);
}
}
}
}
}
};
function _12c(evt){
evt.target=evt.srcElement;
_12a(evt);
};
var body=win.body(),_12d=(has("touch")?[]:["mouseover","mouseout"]).concat(["mousedown","touchstart","mouseup","touchend"]);
_115.forEach(_12d,function(type){
if(body.addEventListener){
body.addEventListener(type,_12a,true);
}else{
body.attachEvent("on"+type,_12c);
}
});
on(body,"focusin, focusout",function(evt){
var node=evt.target;
if(node._cssState&&!node.getAttribute("widgetId")){
var _12e=_119.getEnclosingWidget(node);
_12e._subnodeCssMouseEvent(node,node._cssState,evt);
}
});
});
return _11a;
});
},"dijit/_base/manager":function(){
define("dijit/_base/manager",["dojo/_base/array","dojo/_base/config","dojo/_base/lang","../registry","../main"],function(_12f,_130,lang,_131,_132){
var _133={};
_12f.forEach(["byId","getUniqueId","findWidgets","_destroyAll","byNode","getEnclosingWidget"],function(name){
_133[name]=_131[name];
});
lang.mixin(_133,{defaultDuration:_130["defaultDuration"]||200});
lang.mixin(_132,_133);
return _132;
});
},"dijit/_base/sniff":function(){
define("dijit/_base/sniff",["dojo/uacss"],function(){
});
},"dijit/BackgroundIframe":function(){
define("dijit/BackgroundIframe",["require","./main","dojo/_base/config","dojo/dom-construct","dojo/dom-style","dojo/_base/lang","dojo/on","dojo/sniff","dojo/_base/window"],function(_134,_135,_136,_137,_138,lang,on,has,win){
var _139=new function(){
var _13a=[];
this.pop=function(){
var _13b;
if(_13a.length){
_13b=_13a.pop();
_13b.style.display="";
}else{
if(has("ie")<9){
var burl=_136["dojoBlankHtmlUrl"]||_134.toUrl("dojo/resources/blank.html")||"javascript:\"\"";
var html="<iframe src='"+burl+"' role='presentation'"+" style='position: absolute; left: 0px; top: 0px;"+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";
_13b=win.doc.createElement(html);
}else{
_13b=_137.create("iframe");
_13b.src="javascript:\"\"";
_13b.className="dijitBackgroundIframe";
_13b.setAttribute("role","presentation");
_138.set(_13b,"opacity",0.1);
}
_13b.tabIndex=-1;
}
return _13b;
};
this.push=function(_13c){
_13c.style.display="none";
_13a.push(_13c);
};
}();
_135.BackgroundIframe=function(node){
if(!node.id){
throw new Error("no id");
}
if(has("ie")||has("mozilla")){
var _13d=(this.iframe=_139.pop());
node.appendChild(_13d);
if(has("ie")<7||has("quirks")){
this.resize(node);
this._conn=on(node,"resize",lang.hitch(this,function(){
this.resize(node);
}));
}else{
_138.set(_13d,{width:"100%",height:"100%"});
}
}
};
lang.extend(_135.BackgroundIframe,{resize:function(node){
if(this.iframe){
_138.set(this.iframe,{width:node.offsetWidth+"px",height:node.offsetHeight+"px"});
}
},destroy:function(){
if(this._conn){
this._conn.remove();
this._conn=null;
}
if(this.iframe){
_139.push(this.iframe);
delete this.iframe;
}
}});
return _135.BackgroundIframe;
});
},"dijit/typematic":function(){
define(["dojo/_base/array","dojo/_base/connect","dojo/_base/event","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/sniff","./main"],function(_13e,_13f,_140,_141,lang,on,has,_142){
var _143=(_142.typematic={_fireEventAndReload:function(){
this._timer=null;
this._callback(++this._count,this._node,this._evt);
this._currentTimeout=Math.max(this._currentTimeout<0?this._initialDelay:(this._subsequentDelay>1?this._subsequentDelay:Math.round(this._currentTimeout*this._subsequentDelay)),this._minDelay);
this._timer=setTimeout(lang.hitch(this,"_fireEventAndReload"),this._currentTimeout);
},trigger:function(evt,_144,node,_145,obj,_146,_147,_148){
if(obj!=this._obj){
this.stop();
this._initialDelay=_147||500;
this._subsequentDelay=_146||0.9;
this._minDelay=_148||10;
this._obj=obj;
this._node=node;
this._currentTimeout=-1;
this._count=-1;
this._callback=lang.hitch(_144,_145);
this._evt={faux:true};
for(var attr in evt){
if(attr!="layerX"&&attr!="layerY"){
var v=evt[attr];
if(typeof v!="function"&&typeof v!="undefined"){
this._evt[attr]=v;
}
}
}
this._fireEventAndReload();
}
},stop:function(){
if(this._timer){
clearTimeout(this._timer);
this._timer=null;
}
if(this._obj){
this._callback(-1,this._node,this._evt);
this._obj=null;
}
},addKeyListener:function(node,_149,_14a,_14b,_14c,_14d,_14e){
if(_149.keyCode){
_149.charOrCode=_149.keyCode;
_141.deprecated("keyCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.","","2.0");
}else{
if(_149.charCode){
_149.charOrCode=String.fromCharCode(_149.charCode);
_141.deprecated("charCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.","","2.0");
}
}
var _14f=[on(node,_13f._keypress,lang.hitch(this,function(evt){
if(evt.charOrCode==_149.charOrCode&&(_149.ctrlKey===undefined||_149.ctrlKey==evt.ctrlKey)&&(_149.altKey===undefined||_149.altKey==evt.altKey)&&(_149.metaKey===undefined||_149.metaKey==(evt.metaKey||false))&&(_149.shiftKey===undefined||_149.shiftKey==evt.shiftKey)){
_140.stop(evt);
_143.trigger(evt,_14a,node,_14b,_149,_14c,_14d,_14e);
}else{
if(_143._obj==_149){
_143.stop();
}
}
})),on(node,"keyup",lang.hitch(this,function(){
if(_143._obj==_149){
_143.stop();
}
}))];
return {remove:function(){
_13e.forEach(_14f,function(h){
h.remove();
});
}};
},addMouseListener:function(node,_150,_151,_152,_153,_154){
var _155=[on(node,"mousedown",lang.hitch(this,function(evt){
evt.preventDefault();
_143.trigger(evt,_150,node,_151,node,_152,_153,_154);
})),on(node,"mouseup",lang.hitch(this,function(evt){
if(this._obj){
evt.preventDefault();
}
_143.stop();
})),on(node,"mouseout",lang.hitch(this,function(evt){
if(this._obj){
evt.preventDefault();
}
_143.stop();
})),on(node,"dblclick",lang.hitch(this,function(evt){
evt.preventDefault();
if(has("ie")<9){
_143.trigger(evt,_150,node,_151,node,_152,_153,_154);
setTimeout(lang.hitch(this,_143.stop),50);
}
}))];
return {remove:function(){
_13e.forEach(_155,function(h){
h.remove();
});
}};
},addListener:function(_156,_157,_158,_159,_15a,_15b,_15c,_15d){
var _15e=[this.addKeyListener(_157,_158,_159,_15a,_15b,_15c,_15d),this.addMouseListener(_156,_159,_15a,_15b,_15c,_15d)];
return {remove:function(){
_13e.forEach(_15e,function(h){
h.remove();
});
}};
}});
return _143;
});
},"dojo/_base/url":function(){
define(["./kernel"],function(dojo){
var ore=new RegExp("^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\\?([^#]*))?(#(.*))?$"),ire=new RegExp("^((([^\\[:]+):)?([^@]+)@)?(\\[([^\\]]+)\\]|([^\\[:]*))(:([0-9]+))?$"),_15f=function(){
var n=null,_160=arguments,uri=[_160[0]];
for(var i=1;i<_160.length;i++){
if(!_160[i]){
continue;
}
var _161=new _15f(_160[i]+""),_162=new _15f(uri[0]+"");
if(_161.path==""&&!_161.scheme&&!_161.authority&&!_161.query){
if(_161.fragment!=n){
_162.fragment=_161.fragment;
}
_161=_162;
}else{
if(!_161.scheme){
_161.scheme=_162.scheme;
if(!_161.authority){
_161.authority=_162.authority;
if(_161.path.charAt(0)!="/"){
var path=_162.path.substring(0,_162.path.lastIndexOf("/")+1)+_161.path;
var segs=path.split("/");
for(var j=0;j<segs.length;j++){
if(segs[j]=="."){
if(j==segs.length-1){
segs[j]="";
}else{
segs.splice(j,1);
j--;
}
}else{
if(j>0&&!(j==1&&segs[0]=="")&&segs[j]==".."&&segs[j-1]!=".."){
if(j==(segs.length-1)){
segs.splice(j,1);
segs[j-1]="";
}else{
segs.splice(j-1,2);
j-=2;
}
}
}
}
_161.path=segs.join("/");
}
}
}
}
uri=[];
if(_161.scheme){
uri.push(_161.scheme,":");
}
if(_161.authority){
uri.push("//",_161.authority);
}
uri.push(_161.path);
if(_161.query){
uri.push("?",_161.query);
}
if(_161.fragment){
uri.push("#",_161.fragment);
}
}
this.uri=uri.join("");
var r=this.uri.match(ore);
this.scheme=r[2]||(r[1]?"":n);
this.authority=r[4]||(r[3]?"":n);
this.path=r[5];
this.query=r[7]||(r[6]?"":n);
this.fragment=r[9]||(r[8]?"":n);
if(this.authority!=n){
r=this.authority.match(ire);
this.user=r[3]||n;
this.password=r[4]||n;
this.host=r[6]||r[7];
this.port=r[9]||n;
}
};
_15f.prototype.toString=function(){
return this.uri;
};
return dojo._Url=_15f;
});
},"dojo/date/stamp":function(){
define(["../_base/lang","../_base/array"],function(lang,_163){
var _164={};
lang.setObject("dojo.date.stamp",_164);
_164.fromISOString=function(_165,_166){
if(!_164._isoRegExp){
_164._isoRegExp=/^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(.\d+)?)?((?:[+-](\d{2}):(\d{2}))|Z)?)?$/;
}
var _167=_164._isoRegExp.exec(_165),_168=null;
if(_167){
_167.shift();
if(_167[1]){
_167[1]--;
}
if(_167[6]){
_167[6]*=1000;
}
if(_166){
_166=new Date(_166);
_163.forEach(_163.map(["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],function(prop){
return _166["get"+prop]();
}),function(_169,_16a){
_167[_16a]=_167[_16a]||_169;
});
}
_168=new Date(_167[0]||1970,_167[1]||0,_167[2]||1,_167[3]||0,_167[4]||0,_167[5]||0,_167[6]||0);
if(_167[0]<100){
_168.setFullYear(_167[0]||1970);
}
var _16b=0,_16c=_167[7]&&_167[7].charAt(0);
if(_16c!="Z"){
_16b=((_167[8]||0)*60)+(Number(_167[9])||0);
if(_16c!="-"){
_16b*=-1;
}
}
if(_16c){
_16b-=_168.getTimezoneOffset();
}
if(_16b){
_168.setTime(_168.getTime()+_16b*60000);
}
}
return _168;
};
_164.toISOString=function(_16d,_16e){
var _16f=function(n){
return (n<10)?"0"+n:n;
};
_16e=_16e||{};
var _170=[],_171=_16e.zulu?"getUTC":"get",date="";
if(_16e.selector!="time"){
var year=_16d[_171+"FullYear"]();
date=["0000".substr((year+"").length)+year,_16f(_16d[_171+"Month"]()+1),_16f(_16d[_171+"Date"]())].join("-");
}
_170.push(date);
if(_16e.selector!="date"){
var time=[_16f(_16d[_171+"Hours"]()),_16f(_16d[_171+"Minutes"]()),_16f(_16d[_171+"Seconds"]())].join(":");
var _172=_16d[_171+"Milliseconds"]();
if(_16e.milliseconds){
time+="."+(_172<100?"0":"")+_16f(_172);
}
if(_16e.zulu){
time+="Z";
}else{
if(_16e.selector!="time"){
var _173=_16d.getTimezoneOffset();
var _174=Math.abs(_173);
time+=(_173>0?"-":"+")+_16f(Math.floor(_174/60))+":"+_16f(_174%60);
}
}
_170.push(time);
}
return _170.join("T");
};
return _164;
});
},"dojo/text":function(){
define(["./_base/kernel","require","./has","./_base/xhr"],function(dojo,_175,has,xhr){
var _176;
if(1){
_176=function(url,sync,load){
xhr("GET",{url:url,sync:!!sync,load:load,headers:dojo.config.textPluginHeaders||{}});
};
}else{
if(_175.getText){
_176=_175.getText;
}else{
console.error("dojo/text plugin failed to load because loader does not support getText");
}
}
var _177={},_178=function(text){
if(text){
text=text.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");
var _179=text.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);
if(_179){
text=_179[1];
}
}else{
text="";
}
return text;
},_17a={},_17b={};
dojo.cache=function(_17c,url,_17d){
var key;
if(typeof _17c=="string"){
if(/\//.test(_17c)){
key=_17c;
_17d=url;
}else{
key=_175.toUrl(_17c.replace(/\./g,"/")+(url?("/"+url):""));
}
}else{
key=_17c+"";
_17d=url;
}
var val=(_17d!=undefined&&typeof _17d!="string")?_17d.value:_17d,_17e=_17d&&_17d.sanitize;
if(typeof val=="string"){
_177[key]=val;
return _17e?_178(val):val;
}else{
if(val===null){
delete _177[key];
return null;
}else{
if(!(key in _177)){
_176(key,true,function(text){
_177[key]=text;
});
}
return _17e?_178(_177[key]):_177[key];
}
}
};
return {dynamic:true,normalize:function(id,_17f){
var _180=id.split("!"),url=_180[0];
return (/^\./.test(url)?_17f(url):url)+(_180[1]?"!"+_180[1]:"");
},load:function(id,_181,load){
var _182=id.split("!"),_183=_182.length>1,_184=_182[0],url=_181.toUrl(_182[0]),_185="url:"+url,text=_17a,_186=function(text){
load(_183?_178(text):text);
};
if(_184 in _177){
text=_177[_184];
}else{
if(_185 in _181.cache){
text=_181.cache[_185];
}else{
if(url in _177){
text=_177[url];
}
}
}
if(text===_17a){
if(_17b[url]){
_17b[url].push(_186);
}else{
var _187=_17b[url]=[_186];
_176(url,!_181.async,function(text){
_177[_184]=_177[url]=text;
for(var i=0;i<_187.length;){
_187[i++](text);
}
delete _17b[url];
});
}
}else{
_186(text);
}
}};
});
},"dijit/_base/place":function(){
define("dijit/_base/place",["dojo/_base/array","dojo/_base/lang","dojo/window","../place","../main"],function(_188,lang,_189,_18a,_18b){
var _18c={};
_18c.getViewport=function(){
return _189.getBox();
};
_18c.placeOnScreen=_18a.at;
_18c.placeOnScreenAroundElement=function(node,_18d,_18e,_18f){
var _190;
if(lang.isArray(_18e)){
_190=_18e;
}else{
_190=[];
for(var key in _18e){
_190.push({aroundCorner:key,corner:_18e[key]});
}
}
return _18a.around(node,_18d,_190,true,_18f);
};
_18c.placeOnScreenAroundNode=_18c.placeOnScreenAroundElement;
_18c.placeOnScreenAroundRectangle=_18c.placeOnScreenAroundElement;
_18c.getPopupAroundAlignment=function(_191,_192){
var _193={};
_188.forEach(_191,function(pos){
var ltr=_192;
switch(pos){
case "after":
_193[_192?"BR":"BL"]=_192?"BL":"BR";
break;
case "before":
_193[_192?"BL":"BR"]=_192?"BR":"BL";
break;
case "below-alt":
ltr=!ltr;
case "below":
_193[ltr?"BL":"BR"]=ltr?"TL":"TR";
_193[ltr?"BR":"BL"]=ltr?"TR":"TL";
break;
case "above-alt":
ltr=!ltr;
case "above":
default:
_193[ltr?"TL":"TR"]=ltr?"BL":"BR";
_193[ltr?"TR":"TL"]=ltr?"BR":"BL";
break;
}
});
return _193;
};
lang.mixin(_18b,_18c);
return _18b;
});
},"dijit/registry":function(){
define("dijit/registry",["dojo/_base/array","dojo/sniff","dojo/_base/unload","dojo/_base/window","./main"],function(_194,has,_195,win,_196){
var _197={},hash={};
var _198={length:0,add:function(_199){
if(hash[_199.id]){
throw new Error("Tried to register widget with id=="+_199.id+" but that id is already registered");
}
hash[_199.id]=_199;
this.length++;
},remove:function(id){
if(hash[id]){
delete hash[id];
this.length--;
}
},byId:function(id){
return typeof id=="string"?hash[id]:id;
},byNode:function(node){
return hash[node.getAttribute("widgetId")];
},toArray:function(){
var ar=[];
for(var id in hash){
ar.push(hash[id]);
}
return ar;
},getUniqueId:function(_19a){
var id;
do{
id=_19a+"_"+(_19a in _197?++_197[_19a]:_197[_19a]=0);
}while(hash[id]);
return _196._scopeName=="dijit"?id:_196._scopeName+"_"+id;
},findWidgets:function(root,_19b){
var _19c=[];
function _19d(root){
for(var node=root.firstChild;node;node=node.nextSibling){
if(node.nodeType==1){
var _19e=node.getAttribute("widgetId");
if(_19e){
var _19f=hash[_19e];
if(_19f){
_19c.push(_19f);
}
}else{
if(node!==_19b){
_19d(node);
}
}
}
}
};
_19d(root);
return _19c;
},_destroyAll:function(){
_196._curFocus=null;
_196._prevFocus=null;
_196._activeStack=[];
_194.forEach(_198.findWidgets(win.body()),function(_1a0){
if(!_1a0._destroyed){
if(_1a0.destroyRecursive){
_1a0.destroyRecursive();
}else{
if(_1a0.destroy){
_1a0.destroy();
}
}
}
});
},getEnclosingWidget:function(node){
while(node){
var id=node.nodeType==1&&node.getAttribute("widgetId");
if(id){
return hash[id];
}
node=node.parentNode;
}
return null;
},_hash:hash};
_196.registry=_198;
return _198;
});
},"dijit/form/_FormWidgetMixin":function(){
define("dijit/form/_FormWidgetMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/mouse","dojo/sniff","dojo/window","../a11y"],function(_1a1,_1a2,_1a3,_1a4,lang,_1a5,has,_1a6,a11y){
return _1a2("dijit.form._FormWidgetMixin",null,{name:"",alt:"",value:"",type:"text","aria-label":"focusNode",tabIndex:"0",_setTabIndexAttr:"focusNode",disabled:false,intermediateChanges:false,scrollOnFocus:true,_setIdAttr:"focusNode",_setDisabledAttr:function(_1a7){
this._set("disabled",_1a7);
_1a3.set(this.focusNode,"disabled",_1a7);
if(this.valueNode){
_1a3.set(this.valueNode,"disabled",_1a7);
}
this.focusNode.setAttribute("aria-disabled",_1a7?"true":"false");
if(_1a7){
this._set("hovering",false);
this._set("active",false);
var _1a8="tabIndex" in this.attributeMap?this.attributeMap.tabIndex:("_setTabIndexAttr" in this)?this._setTabIndexAttr:"focusNode";
_1a1.forEach(lang.isArray(_1a8)?_1a8:[_1a8],function(_1a9){
var node=this[_1a9];
if(has("webkit")||a11y.hasDefaultTabStop(node)){
node.setAttribute("tabIndex","-1");
}else{
node.removeAttribute("tabIndex");
}
},this);
}else{
if(this.tabIndex!=""){
this.set("tabIndex",this.tabIndex);
}
}
},_onFocus:function(by){
if(by=="mouse"&&this.isFocusable()){
var _1aa=this.connect(this.focusNode,"onfocus",function(){
this.disconnect(_1ab);
this.disconnect(_1aa);
});
var _1ab=this.connect(this.ownerDocumentBody,"onmouseup",function(){
this.disconnect(_1ab);
this.disconnect(_1aa);
if(this.focused){
this.focus();
}
});
}
if(this.scrollOnFocus){
this.defer(function(){
_1a6.scrollIntoView(this.domNode);
});
}
this.inherited(arguments);
},isFocusable:function(){
return !this.disabled&&this.focusNode&&(_1a4.get(this.domNode,"display")!="none");
},focus:function(){
if(!this.disabled&&this.focusNode.focus){
try{
this.focusNode.focus();
}
catch(e){
}
}
},compare:function(val1,val2){
if(typeof val1=="number"&&typeof val2=="number"){
return (isNaN(val1)&&isNaN(val2))?0:val1-val2;
}else{
if(val1>val2){
return 1;
}else{
if(val1<val2){
return -1;
}else{
return 0;
}
}
}
},onChange:function(){
},_onChangeActive:false,_handleOnChange:function(_1ac,_1ad){
if(this._lastValueReported==undefined&&(_1ad===null||!this._onChangeActive)){
this._resetValue=this._lastValueReported=_1ac;
}
this._pendingOnChange=this._pendingOnChange||(typeof _1ac!=typeof this._lastValueReported)||(this.compare(_1ac,this._lastValueReported)!=0);
if((this.intermediateChanges||_1ad||_1ad===undefined)&&this._pendingOnChange){
this._lastValueReported=_1ac;
this._pendingOnChange=false;
if(this._onChangeActive){
if(this._onChangeHandle){
this._onChangeHandle.remove();
}
this._onChangeHandle=this.defer(function(){
this._onChangeHandle=null;
this.onChange(_1ac);
});
}
}
},create:function(){
this.inherited(arguments);
this._onChangeActive=true;
},destroy:function(){
if(this._onChangeHandle){
this._onChangeHandle.remove();
this.onChange(this._lastValueReported);
}
this.inherited(arguments);
}});
});
},"dojo/uacss":function(){
define(["./dom-geometry","./_base/lang","./ready","./sniff","./_base/window"],function(_1ae,lang,_1af,has,_1b0){
var html=_1b0.doc.documentElement,ie=has("ie"),_1b1=has("opera"),maj=Math.floor,ff=has("ff"),_1b2=_1ae.boxModel.replace(/-/,""),_1b3={"dj_quirks":has("quirks"),"dj_opera":_1b1,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla")};
if(ie){
_1b3["dj_ie"]=true;
_1b3["dj_ie"+maj(ie)]=true;
_1b3["dj_iequirks"]=has("quirks");
}
if(ff){
_1b3["dj_ff"+maj(ff)]=true;
}
_1b3["dj_"+_1b2]=true;
var _1b4="";
for(var clz in _1b3){
if(_1b3[clz]){
_1b4+=clz+" ";
}
}
html.className=lang.trim(html.className+" "+_1b4);
_1af(90,function(){
if(!_1ae.isBodyLtr()){
var _1b5="dj_rtl dijitRtl "+_1b4.replace(/ /g,"-rtl ");
html.className=lang.trim(html.className+" "+_1b5+"dj_rtl dijitRtl "+_1b4.replace(/ /g,"-rtl "));
}
});
return has;
});
},"dijit/place":function(){
define("dijit/place",["dojo/_base/array","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","dojo/_base/window","dojo/window","./main"],function(_1b6,_1b7,_1b8,_1b9,win,_1ba,_1bb){
function _1bc(node,_1bd,_1be,_1bf){
var view=_1ba.getBox(node.ownerDocument);
if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){
win.body(node.ownerDocument).appendChild(node);
}
var best=null;
_1b6.some(_1bd,function(_1c0){
var _1c1=_1c0.corner;
var pos=_1c0.pos;
var _1c2=0;
var _1c3={w:{"L":view.l+view.w-pos.x,"R":pos.x-view.l,"M":view.w}[_1c1.charAt(1)],h:{"T":view.t+view.h-pos.y,"B":pos.y-view.t,"M":view.h}[_1c1.charAt(0)]};
var s=node.style;
s.left=s.right="auto";
if(_1be){
var res=_1be(node,_1c0.aroundCorner,_1c1,_1c3,_1bf);
_1c2=typeof res=="undefined"?0:res;
}
var _1c4=node.style;
var _1c5=_1c4.display;
var _1c6=_1c4.visibility;
if(_1c4.display=="none"){
_1c4.visibility="hidden";
_1c4.display="";
}
var bb=_1b7.position(node);
_1c4.display=_1c5;
_1c4.visibility=_1c6;
var _1c7={"L":pos.x,"R":pos.x-bb.w,"M":Math.max(view.l,Math.min(view.l+view.w,pos.x+(bb.w>>1))-bb.w)}[_1c1.charAt(1)],_1c8={"T":pos.y,"B":pos.y-bb.h,"M":Math.max(view.t,Math.min(view.t+view.h,pos.y+(bb.h>>1))-bb.h)}[_1c1.charAt(0)],_1c9=Math.max(view.l,_1c7),_1ca=Math.max(view.t,_1c8),endX=Math.min(view.l+view.w,_1c7+bb.w),endY=Math.min(view.t+view.h,_1c8+bb.h),_1cb=endX-_1c9,_1cc=endY-_1ca;
_1c2+=(bb.w-_1cb)+(bb.h-_1cc);
if(best==null||_1c2<best.overflow){
best={corner:_1c1,aroundCorner:_1c0.aroundCorner,x:_1c9,y:_1ca,w:_1cb,h:_1cc,overflow:_1c2,spaceAvailable:_1c3};
}
return !_1c2;
});
if(best.overflow&&_1be){
_1be(node,best.aroundCorner,best.corner,best.spaceAvailable,_1bf);
}
var l=_1b7.isBodyLtr(node.ownerDocument),s=node.style;
s.top=best.y+"px";
s[l?"left":"right"]=(l?best.x:view.w-best.x-best.w)+"px";
s[l?"right":"left"]="auto";
return best;
};
var _1cd={at:function(node,pos,_1ce,_1cf){
var _1d0=_1b6.map(_1ce,function(_1d1){
var c={corner:_1d1,pos:{x:pos.x,y:pos.y}};
if(_1cf){
c.pos.x+=_1d1.charAt(1)=="L"?_1cf.x:-_1cf.x;
c.pos.y+=_1d1.charAt(0)=="T"?_1cf.y:-_1cf.y;
}
return c;
});
return _1bc(node,_1d0);
},around:function(node,_1d2,_1d3,_1d4,_1d5){
var _1d6=(typeof _1d2=="string"||"offsetWidth" in _1d2)?_1b7.position(_1d2,true):_1d2;
if(_1d2.parentNode){
var _1d7=_1b8.getComputedStyle(_1d2).position=="absolute";
var _1d8=_1d2.parentNode;
while(_1d8&&_1d8.nodeType==1&&_1d8.nodeName!="BODY"){
var _1d9=_1b7.position(_1d8,true),pcs=_1b8.getComputedStyle(_1d8);
if(/relative|absolute/.test(pcs.position)){
_1d7=false;
}
if(!_1d7&&/hidden|auto|scroll/.test(pcs.overflow)){
var _1da=Math.min(_1d6.y+_1d6.h,_1d9.y+_1d9.h);
var _1db=Math.min(_1d6.x+_1d6.w,_1d9.x+_1d9.w);
_1d6.x=Math.max(_1d6.x,_1d9.x);
_1d6.y=Math.max(_1d6.y,_1d9.y);
_1d6.h=_1da-_1d6.y;
_1d6.w=_1db-_1d6.x;
}
if(pcs.position=="absolute"){
_1d7=true;
}
_1d8=_1d8.parentNode;
}
}
var x=_1d6.x,y=_1d6.y,_1dc="w" in _1d6?_1d6.w:(_1d6.w=_1d6.width),_1dd="h" in _1d6?_1d6.h:(_1b9.deprecated("place.around: dijit/place.__Rectangle: { x:"+x+", y:"+y+", height:"+_1d6.height+", width:"+_1dc+" } has been deprecated.  Please use { x:"+x+", y:"+y+", h:"+_1d6.height+", w:"+_1dc+" }","","2.0"),_1d6.h=_1d6.height);
var _1de=[];
function push(_1df,_1e0){
_1de.push({aroundCorner:_1df,corner:_1e0,pos:{x:{"L":x,"R":x+_1dc,"M":x+(_1dc>>1)}[_1df.charAt(1)],y:{"T":y,"B":y+_1dd,"M":y+(_1dd>>1)}[_1df.charAt(0)]}});
};
_1b6.forEach(_1d3,function(pos){
var ltr=_1d4;
switch(pos){
case "above-centered":
push("TM","BM");
break;
case "below-centered":
push("BM","TM");
break;
case "after-centered":
ltr=!ltr;
case "before-centered":
push(ltr?"ML":"MR",ltr?"MR":"ML");
break;
case "after":
ltr=!ltr;
case "before":
push(ltr?"TL":"TR",ltr?"TR":"TL");
push(ltr?"BL":"BR",ltr?"BR":"BL");
break;
case "below-alt":
ltr=!ltr;
case "below":
push(ltr?"BL":"BR",ltr?"TL":"TR");
push(ltr?"BR":"BL",ltr?"TR":"TL");
break;
case "above-alt":
ltr=!ltr;
case "above":
push(ltr?"TL":"TR",ltr?"BL":"BR");
push(ltr?"TR":"TL",ltr?"BR":"BL");
break;
default:
push(pos.aroundCorner,pos.corner);
}
});
var _1e1=_1bc(node,_1de,_1d5,{w:_1dc,h:_1dd});
_1e1.aroundNodePos=_1d6;
return _1e1;
}};
return _1bb.place=_1cd;
});
},"dojo/window":function(){
define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style"],function(lang,has,_1e2,dom,geom,_1e3){
var _1e4={getBox:function(doc){
doc=doc||_1e2.doc;
var _1e5=(doc.compatMode=="BackCompat")?_1e2.body(doc):doc.documentElement,_1e6=geom.docScroll(doc),w,h;
if(has("touch")){
var _1e7=_1e4.get(doc);
w=_1e7.innerWidth||_1e5.clientWidth;
h=_1e7.innerHeight||_1e5.clientHeight;
}else{
w=_1e5.clientWidth;
h=_1e5.clientHeight;
}
return {l:_1e6.x,t:_1e6.y,w:w,h:h};
},get:function(doc){
if(has("ie")&&_1e4!==document.parentWindow){
doc.parentWindow.execScript("document._parentWindow = window;","Javascript");
var win=doc._parentWindow;
doc._parentWindow=null;
return win;
}
return doc.parentWindow||doc.defaultView;
},scrollIntoView:function(node,pos){
try{
node=dom.byId(node);
var doc=node.ownerDocument||_1e2.doc,body=_1e2.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");
if((!(has("mozilla")||isIE||isWK||has("opera"))||node==body||node==html)&&(typeof node.scrollIntoView!="undefined")){
node.scrollIntoView(false);
return;
}
var _1e8=doc.compatMode=="BackCompat",_1e9=(isIE>=9&&"frameElement" in node.ownerDocument.parentWindow)?((html.clientHeight>0&&html.clientWidth>0&&(body.clientHeight==0||body.clientWidth==0||body.clientHeight>html.clientHeight||body.clientWidth>html.clientWidth))?html:body):(_1e8?body:html),_1ea=isWK?body:_1e9,_1eb=_1e9.clientWidth,_1ec=_1e9.clientHeight,rtl=!geom.isBodyLtr(doc),_1ed=pos||geom.position(node),el=node.parentNode,_1ee=function(el){
return ((isIE<=6||(isIE&&_1e8))?false:(_1e3.get(el,"position").toLowerCase()=="fixed"));
};
if(_1ee(node)){
return;
}
while(el){
if(el==body){
el=_1ea;
}
var _1ef=geom.position(el),_1f0=_1ee(el);
if(el==_1ea){
_1ef.w=_1eb;
_1ef.h=_1ec;
if(_1ea==html&&isIE&&rtl){
_1ef.x+=_1ea.offsetWidth-_1ef.w;
}
if(_1ef.x<0||!isIE){
_1ef.x=0;
}
if(_1ef.y<0||!isIE){
_1ef.y=0;
}
}else{
var pb=geom.getPadBorderExtents(el);
_1ef.w-=pb.w;
_1ef.h-=pb.h;
_1ef.x+=pb.l;
_1ef.y+=pb.t;
var _1f1=el.clientWidth,_1f2=_1ef.w-_1f1;
if(_1f1>0&&_1f2>0){
_1ef.w=_1f1;
_1ef.x+=(rtl&&(isIE||el.clientLeft>pb.l))?_1f2:0;
}
_1f1=el.clientHeight;
_1f2=_1ef.h-_1f1;
if(_1f1>0&&_1f2>0){
_1ef.h=_1f1;
}
}
if(_1f0){
if(_1ef.y<0){
_1ef.h+=_1ef.y;
_1ef.y=0;
}
if(_1ef.x<0){
_1ef.w+=_1ef.x;
_1ef.x=0;
}
if(_1ef.y+_1ef.h>_1ec){
_1ef.h=_1ec-_1ef.y;
}
if(_1ef.x+_1ef.w>_1eb){
_1ef.w=_1eb-_1ef.x;
}
}
var l=_1ed.x-_1ef.x,t=_1ed.y-Math.max(_1ef.y,0),r=l+_1ed.w-_1ef.w,bot=t+_1ed.h-_1ef.h;
if(r*l>0){
var s=Math[l<0?"max":"min"](l,r);
if(rtl&&((isIE==8&&!_1e8)||isIE>=9)){
s=-s;
}
_1ed.x+=el.scrollLeft;
el.scrollLeft+=s;
_1ed.x-=el.scrollLeft;
}
if(bot*t>0){
_1ed.y+=el.scrollTop;
el.scrollTop+=Math[t<0?"max":"min"](t,bot);
_1ed.y-=el.scrollTop;
}
el=(el!=_1ea)&&!_1f0&&el.parentNode;
}
}
catch(error){
console.error("scrollIntoView: "+error);
node.scrollIntoView(false);
}
}};
1&&lang.setObject("dojo.window",_1e4);
return _1e4;
});
},"dijit/form/_FormValueWidget":function(){
define("dijit/form/_FormValueWidget",["dojo/_base/declare","dojo/sniff","./_FormWidget","./_FormValueMixin"],function(_1f3,has,_1f4,_1f5){
return _1f3("dijit.form._FormValueWidget",[_1f4,_1f5],{_layoutHackIE7:function(){
if(has("ie")==7){
var _1f6=this.domNode;
var _1f7=_1f6.parentNode;
var _1f8=_1f6.firstChild||_1f6;
var _1f9=_1f8.style.filter;
var _1fa=this;
while(_1f7&&_1f7.clientHeight==0){
(function ping(){
var _1fb=_1fa.connect(_1f7,"onscroll",function(){
_1fa.disconnect(_1fb);
_1f8.style.filter=(new Date()).getMilliseconds();
_1fa.defer(function(){
_1f8.style.filter=_1f9;
});
});
})();
_1f7=_1f7.parentNode;
}
}
}});
});
},"dijit/_OnDijitClickMixin":function(){
define("dijit/_OnDijitClickMixin",["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window","./a11yclick"],function(on,_1fc,keys,_1fd,has,_1fe,win,_1ff){
var ret=_1fd("dijit._OnDijitClickMixin",null,{connect:function(obj,_200,_201){
return this.inherited(arguments,[obj,_200=="ondijitclick"?_1ff:_200,_201]);
}});
ret.a11yclick=_1ff;
return ret;
});
},"dijit/a11yclick":function(){
define("dijit/a11yclick",["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window"],function(on,_202,keys,_203,has,_204,win){
var _205=null;
if(has("dom-addeventlistener")){
win.doc.addEventListener("keydown",function(evt){
_205=evt.target;
},true);
}else{
(function(){
var _206=function(evt){
_205=evt.srcElement;
};
win.doc.attachEvent("onkeydown",_206);
_204.addOnWindowUnload(function(){
win.doc.detachEvent("onkeydown",_206);
});
})();
}
function _207(e){
return (e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey;
};
return function(node,_208){
if(/input|button/i.test(node.nodeName)){
return on(node,"click",_208);
}else{
var _209=[on(node,"keydown",function(e){
if(_207(e)){
_205=e.target;
e.preventDefault();
}
}),on(node,"keyup",function(e){
if(_207(e)&&e.target==_205){
_205=null;
on.emit(e.target,"click",{cancelable:true,bubbles:true});
}
}),on(node,"click",function(e){
_208.call(this,e);
})];
if(has("touch")){
var _20a;
_209.push(on(node,"touchend",function(e){
var _20b=e.target;
_20a=setTimeout(function(){
_20a=null;
on.emit(_20b,"click",{cancelable:true,bubbles:true});
},600);
}),on(node,"click",function(e){
if(_20a){
clearTimeout(_20a);
}
}));
}
return {remove:function(){
_202.forEach(_209,function(h){
h.remove();
});
if(_20a){
clearTimeout(_20a);
_20a=null;
}
}};
}
};
return ret;
});
},"dijit/hccss":function(){
define("dijit/hccss",["dojo/dom-class","dojo/hccss","dojo/ready","dojo/_base/window"],function(_20c,has,_20d,win){
_20d(90,function(){
if(has("highcontrast")){
_20c.add(win.body(),"dijit_a11y");
}
});
return has;
});
},"dijit/_TemplatedMixin":function(){
define("dijit/_TemplatedMixin",["dojo/_base/lang","dojo/touch","./_WidgetBase","dojo/string","dojo/cache","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/sniff","dojo/_base/unload"],function(lang,_20e,_20f,_210,_211,_212,_213,_214,has,_215){
var _216=_213("dijit._TemplatedMixin",null,{templateString:null,templatePath:null,_skipNodeCache:false,_earlyTemplatedStartup:false,constructor:function(){
this._attachPoints=[];
this._attachEvents=[];
},_stringRepl:function(tmpl){
var _217=this.declaredClass,_218=this;
return _210.substitute(tmpl,this,function(_219,key){
if(key.charAt(0)=="!"){
_219=lang.getObject(key.substr(1),false,_218);
}
if(typeof _219=="undefined"){
throw new Error(_217+" template:"+key);
}
if(_219==null){
return "";
}
return key.charAt(0)=="!"?_219:_219.toString().replace(/"/g,"&quot;");
},this);
},buildRendering:function(){
if(!this.templateString){
this.templateString=_211(this.templatePath,{sanitize:true});
}
var _21a=_216.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);
var node;
if(lang.isString(_21a)){
node=_214.toDom(this._stringRepl(_21a),this.ownerDocument);
if(node.nodeType!=1){
throw new Error("Invalid template: "+_21a);
}
}else{
node=_21a.cloneNode(true);
}
this.domNode=node;
this.inherited(arguments);
this._attachTemplateNodes(node,function(n,p){
return n.getAttribute(p);
});
this._beforeFillContent();
this._fillContent(this.srcNodeRef);
},_beforeFillContent:function(){
},_fillContent:function(_21b){
var dest=this.containerNode;
if(_21b&&dest){
while(_21b.hasChildNodes()){
dest.appendChild(_21b.firstChild);
}
}
},_attachTemplateNodes:function(_21c,_21d){
var _21e=lang.isArray(_21c)?_21c:(_21c.all||_21c.getElementsByTagName("*"));
var x=lang.isArray(_21c)?0:-1;
for(;x<0||_21e[x];x++){
var _21f=(x==-1)?_21c:_21e[x];
if(this.widgetsInTemplate&&(_21d(_21f,"dojoType")||_21d(_21f,"data-dojo-type"))){
continue;
}
var _220=_21d(_21f,"dojoAttachPoint")||_21d(_21f,"data-dojo-attach-point");
if(_220){
var _221,_222=_220.split(/\s*,\s*/);
while((_221=_222.shift())){
if(lang.isArray(this[_221])){
this[_221].push(_21f);
}else{
this[_221]=_21f;
}
this._attachPoints.push(_221);
}
}
var _223=_21d(_21f,"dojoAttachEvent")||_21d(_21f,"data-dojo-attach-event");
if(_223){
var _224,_225=_223.split(/\s*,\s*/);
var trim=lang.trim;
while((_224=_225.shift())){
if(_224){
var _226=null;
if(_224.indexOf(":")!=-1){
var _227=_224.split(":");
_224=trim(_227[0]);
_226=trim(_227[1]);
}else{
_224=trim(_224);
}
if(!_226){
_226=_224;
}
this._attachEvents.push(this.connect(_21f,_20e[_224]||_224,_226));
}
}
}
}
},destroyRendering:function(){
_212.forEach(this._attachPoints,function(_228){
delete this[_228];
},this);
this._attachPoints=[];
_212.forEach(this._attachEvents,this.disconnect,this);
this._attachEvents=[];
this.inherited(arguments);
}});
_216._templateCache={};
_216.getCachedTemplate=function(_229,_22a,doc){
var _22b=_216._templateCache;
var key=_229;
var _22c=_22b[key];
if(_22c){
try{
if(!_22c.ownerDocument||_22c.ownerDocument==(doc||document)){
return _22c;
}
}
catch(e){
}
_214.destroy(_22c);
}
_229=_210.trim(_229);
if(_22a||_229.match(/\$\{([^\}]+)\}/g)){
return (_22b[key]=_229);
}else{
var node=_214.toDom(_229,doc);
if(node.nodeType!=1){
throw new Error("Invalid template: "+_229);
}
return (_22b[key]=node);
}
};
if(has("ie")){
_215.addOnWindowUnload(function(){
var _22d=_216._templateCache;
for(var key in _22d){
var _22e=_22d[key];
if(typeof _22e=="object"){
_214.destroy(_22e);
}
delete _22d[key];
}
});
}
lang.extend(_20f,{dojoAttachEvent:"",dojoAttachPoint:""});
return _216;
});
},"dijit/form/_FormWidget":function(){
define("dijit/form/_FormWidget",["dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/ready","../_Widget","../_CssStateMixin","../_TemplatedMixin","./_FormWidgetMixin"],function(_22f,has,_230,_231,_232,_233,_234,_235){
if(has("dijit-legacy-requires")){
_231(0,function(){
var _236=["dijit/form/_FormValueWidget"];
require(_236);
});
}
return _22f("dijit.form._FormWidget",[_232,_234,_233,_235],{setDisabled:function(_237){
_230.deprecated("setDisabled("+_237+") is deprecated. Use set('disabled',"+_237+") instead.","","2.0");
this.set("disabled",_237);
},setValue:function(_238){
_230.deprecated("dijit.form._FormWidget:setValue("+_238+") is deprecated.  Use set('value',"+_238+") instead.","","2.0");
this.set("value",_238);
},getValue:function(){
_230.deprecated(this.declaredClass+"::getValue() is deprecated. Use get('value') instead.","","2.0");
return this.get("value");
},postMixInProperties:function(){
this.nameAttrSetting=this.name?("name=\""+this.name.replace(/"/g,"&quot;")+"\""):"";
this.inherited(arguments);
},_setTypeAttr:null});
});
},"dijit/_base/focus":function(){
define("dijit/_base/focus",["dojo/_base/array","dojo/dom","dojo/_base/lang","dojo/topic","dojo/_base/window","../focus","../main"],function(_239,dom,lang,_23a,win,_23b,_23c){
var _23d={_curFocus:null,_prevFocus:null,isCollapsed:function(){
return _23c.getBookmark().isCollapsed;
},getBookmark:function(){
var bm,rg,tg,sel=win.doc.selection,cf=_23b.curNode;
if(win.global.getSelection){
sel=win.global.getSelection();
if(sel){
if(sel.isCollapsed){
tg=cf?cf.tagName:"";
if(tg){
tg=tg.toLowerCase();
if(tg=="textarea"||(tg=="input"&&(!cf.type||cf.type.toLowerCase()=="text"))){
sel={start:cf.selectionStart,end:cf.selectionEnd,node:cf,pRange:true};
return {isCollapsed:(sel.end<=sel.start),mark:sel};
}
}
bm={isCollapsed:true};
if(sel.rangeCount){
bm.mark=sel.getRangeAt(0).cloneRange();
}
}else{
rg=sel.getRangeAt(0);
bm={isCollapsed:false,mark:rg.cloneRange()};
}
}
}else{
if(sel){
tg=cf?cf.tagName:"";
tg=tg.toLowerCase();
if(cf&&tg&&(tg=="button"||tg=="textarea"||tg=="input")){
if(sel.type&&sel.type.toLowerCase()=="none"){
return {isCollapsed:true,mark:null};
}else{
rg=sel.createRange();
return {isCollapsed:rg.text&&rg.text.length?false:true,mark:{range:rg,pRange:true}};
}
}
bm={};
try{
rg=sel.createRange();
bm.isCollapsed=!(sel.type=="Text"?rg.htmlText.length:rg.length);
}
catch(e){
bm.isCollapsed=true;
return bm;
}
if(sel.type.toUpperCase()=="CONTROL"){
if(rg.length){
bm.mark=[];
var i=0,len=rg.length;
while(i<len){
bm.mark.push(rg.item(i++));
}
}else{
bm.isCollapsed=true;
bm.mark=null;
}
}else{
bm.mark=rg.getBookmark();
}
}else{
console.warn("No idea how to store the current selection for this browser!");
}
}
return bm;
},moveToBookmark:function(_23e){
var _23f=win.doc,mark=_23e.mark;
if(mark){
if(win.global.getSelection){
var sel=win.global.getSelection();
if(sel&&sel.removeAllRanges){
if(mark.pRange){
var n=mark.node;
n.selectionStart=mark.start;
n.selectionEnd=mark.end;
}else{
sel.removeAllRanges();
sel.addRange(mark);
}
}else{
console.warn("No idea how to restore selection for this browser!");
}
}else{
if(_23f.selection&&mark){
var rg;
if(mark.pRange){
rg=mark.range;
}else{
if(lang.isArray(mark)){
rg=_23f.body.createControlRange();
_239.forEach(mark,function(n){
rg.addElement(n);
});
}else{
rg=_23f.body.createTextRange();
rg.moveToBookmark(mark);
}
}
rg.select();
}
}
}
},getFocus:function(menu,_240){
var node=!_23b.curNode||(menu&&dom.isDescendant(_23b.curNode,menu.domNode))?_23c._prevFocus:_23b.curNode;
return {node:node,bookmark:node&&(node==_23b.curNode)&&win.withGlobal(_240||win.global,_23c.getBookmark),openedForWindow:_240};
},_activeStack:[],registerIframe:function(_241){
return _23b.registerIframe(_241);
},unregisterIframe:function(_242){
_242&&_242.remove();
},registerWin:function(_243,_244){
return _23b.registerWin(_243,_244);
},unregisterWin:function(_245){
_245&&_245.remove();
}};
_23b.focus=function(_246){
if(!_246){
return;
}
var node="node" in _246?_246.node:_246,_247=_246.bookmark,_248=_246.openedForWindow,_249=_247?_247.isCollapsed:false;
if(node){
var _24a=(node.tagName.toLowerCase()=="iframe")?node.contentWindow:node;
if(_24a&&_24a.focus){
try{
_24a.focus();
}
catch(e){
}
}
_23b._onFocusNode(node);
}
if(_247&&win.withGlobal(_248||win.global,_23c.isCollapsed)&&!_249){
if(_248){
_248.focus();
}
try{
win.withGlobal(_248||win.global,_23c.moveToBookmark,null,[_247]);
}
catch(e2){
}
}
};
_23b.watch("curNode",function(name,_24b,_24c){
_23c._curFocus=_24c;
_23c._prevFocus=_24b;
if(_24c){
_23a.publish("focusNode",_24c);
}
});
_23b.watch("activeStack",function(name,_24d,_24e){
_23c._activeStack=_24e;
});
_23b.on("widget-blur",function(_24f,by){
_23a.publish("widgetBlur",_24f,by);
});
_23b.on("widget-focus",function(_250,by){
_23a.publish("widgetFocus",_250,by);
});
lang.mixin(_23c,_23d);
return _23c;
});
},"dojo/parser":function(){
define(["require","./_base/kernel","./_base/lang","./_base/array","./_base/config","./_base/html","./_base/window","./_base/url","./_base/json","./aspect","./date/stamp","./Deferred","./has","./query","./on","./ready"],function(_251,dojo,_252,_253,_254,_255,_256,_257,_258,_259,_25a,_25b,has,_25c,don,_25d){
new Date("X");
var _25e=0;
_259.after(_252,"extend",function(){
_25e++;
},true);
function _25f(ctor){
var map=ctor._nameCaseMap,_260=ctor.prototype;
if(!map||map._extendCnt<_25e){
map=ctor._nameCaseMap={};
for(var name in _260){
if(name.charAt(0)==="_"){
continue;
}
map[name.toLowerCase()]=name;
}
map._extendCnt=_25e;
}
return map;
};
var _261={};
function _262(_263){
var ts=_263.join();
if(!_261[ts]){
var _264=[];
for(var i=0,l=_263.length;i<l;i++){
var t=_263[i];
_264[_264.length]=(_261[t]=_261[t]||(_252.getObject(t)||(~t.indexOf("/")&&_251(t))));
}
var ctor=_264.shift();
_261[ts]=_264.length?(ctor.createSubclass?ctor.createSubclass(_264):ctor.extend.apply(ctor,_264)):ctor;
}
return _261[ts];
};
var _265={_clearCache:function(){
_25e++;
_261={};
},_functionFromScript:function(_266,_267){
var _268="",_269="",_26a=(_266.getAttribute(_267+"args")||_266.getAttribute("args")),_26b=_266.getAttribute("with");
var _26c=(_26a||"").split(/\s*,\s*/);
if(_26b&&_26b.length){
_253.forEach(_26b.split(/\s*,\s*/),function(part){
_268+="with("+part+"){";
_269+="}";
});
}
return new Function(_26c,_268+_266.innerHTML+_269);
},instantiate:function(_26d,_26e,_26f){
_26e=_26e||{};
_26f=_26f||{};
var _270=(_26f.scope||dojo._scopeName)+"Type",_271="data-"+(_26f.scope||dojo._scopeName)+"-",_272=_271+"type",_273=_271+"mixins";
var list=[];
_253.forEach(_26d,function(node){
var type=_270 in _26e?_26e[_270]:node.getAttribute(_272)||node.getAttribute(_270);
if(type){
var _274=node.getAttribute(_273),_275=_274?[type].concat(_274.split(/\s*,\s*/)):[type];
list.push({node:node,types:_275});
}
});
return this._instantiate(list,_26e,_26f);
},_instantiate:function(_276,_277,_278){
var _279=_253.map(_276,function(obj){
var ctor=obj.ctor||_262(obj.types);
if(!ctor){
throw new Error("Unable to resolve constructor for: '"+obj.types.join()+"'");
}
return this.construct(ctor,obj.node,_277,_278,obj.scripts,obj.inherited);
},this);
if(!_277._started&&!_278.noStart){
_253.forEach(_279,function(_27a){
if(typeof _27a.startup==="function"&&!_27a._started){
_27a.startup();
}
});
}
return _279;
},construct:function(ctor,node,_27b,_27c,_27d,_27e){
var _27f=ctor&&ctor.prototype;
_27c=_27c||{};
var _280={};
if(_27c.defaults){
_252.mixin(_280,_27c.defaults);
}
if(_27e){
_252.mixin(_280,_27e);
}
var _281;
if(has("dom-attributes-explicit")){
_281=node.attributes;
}else{
if(has("dom-attributes-specified-flag")){
_281=_253.filter(node.attributes,function(a){
return a.specified;
});
}else{
var _282=/^input$|^img$/i.test(node.nodeName)?node:node.cloneNode(false),_283=_282.outerHTML.replace(/=[^\s"']+|="[^"]*"|='[^']*'/g,"").replace(/^\s*<[a-zA-Z0-9]*\s*/,"").replace(/\s*>.*$/,"");
_281=_253.map(_283.split(/\s+/),function(name){
var _284=name.toLowerCase();
return {name:name,value:(node.nodeName=="LI"&&name=="value")||_284=="enctype"?node.getAttribute(_284):node.getAttributeNode(_284).value};
});
}
}
var _285=_27c.scope||dojo._scopeName,_286="data-"+_285+"-",hash={};
if(_285!=="dojo"){
hash[_286+"props"]="data-dojo-props";
hash[_286+"type"]="data-dojo-type";
hash[_286+"mixins"]="data-dojo-mixins";
hash[_285+"type"]="dojoType";
hash[_286+"id"]="data-dojo-id";
}
var i=0,item,_287=[],_288,_289;
while(item=_281[i++]){
var name=item.name,_28a=name.toLowerCase(),_28b=item.value;
switch(hash[_28a]||_28a){
case "data-dojo-type":
case "dojotype":
case "data-dojo-mixins":
break;
case "data-dojo-props":
_289=_28b;
break;
case "data-dojo-id":
case "jsid":
_288=_28b;
break;
case "data-dojo-attach-point":
case "dojoattachpoint":
_280.dojoAttachPoint=_28b;
break;
case "data-dojo-attach-event":
case "dojoattachevent":
_280.dojoAttachEvent=_28b;
break;
case "class":
_280["class"]=node.className;
break;
case "style":
_280["style"]=node.style&&node.style.cssText;
break;
default:
if(!(name in _27f)){
var map=_25f(ctor);
name=map[_28a]||name;
}
if(name in _27f){
switch(typeof _27f[name]){
case "string":
_280[name]=_28b;
break;
case "number":
_280[name]=_28b.length?Number(_28b):NaN;
break;
case "boolean":
_280[name]=_28b.toLowerCase()!="false";
break;
case "function":
if(_28b===""||_28b.search(/[^\w\.]+/i)!=-1){
_280[name]=new Function(_28b);
}else{
_280[name]=_252.getObject(_28b,false)||new Function(_28b);
}
_287.push(name);
break;
default:
var pVal=_27f[name];
_280[name]=(pVal&&"length" in pVal)?(_28b?_28b.split(/\s*,\s*/):[]):(pVal instanceof Date)?(_28b==""?new Date(""):_28b=="now"?new Date():_25a.fromISOString(_28b)):(pVal instanceof _257)?(dojo.baseUrl+_28b):_258.fromJson(_28b);
}
}else{
_280[name]=_28b;
}
}
}
for(var j=0;j<_287.length;j++){
var _28c=_287[j].toLowerCase();
node.removeAttribute(_28c);
node[_28c]=null;
}
if(_289){
try{
_289=_258.fromJson.call(_27c.propsThis,"{"+_289+"}");
_252.mixin(_280,_289);
}
catch(e){
throw new Error(e.toString()+" in data-dojo-props='"+_289+"'");
}
}
_252.mixin(_280,_27b);
if(!_27d){
_27d=(ctor&&(ctor._noScript||_27f._noScript)?[]:_25c("> script[type^='dojo/']",node));
}
var _28d=[],_28e=[],_28f=[],ons=[];
if(_27d){
for(i=0;i<_27d.length;i++){
var _290=_27d[i];
node.removeChild(_290);
var _291=(_290.getAttribute(_286+"event")||_290.getAttribute("event")),prop=_290.getAttribute(_286+"prop"),_292=_290.getAttribute(_286+"method"),_293=_290.getAttribute(_286+"advice"),_294=_290.getAttribute("type"),nf=this._functionFromScript(_290,_286);
if(_291){
if(_294=="dojo/connect"){
_28d.push({method:_291,func:nf});
}else{
if(_294=="dojo/on"){
ons.push({event:_291,func:nf});
}else{
_280[_291]=nf;
}
}
}else{
if(_294=="dojo/aspect"){
_28d.push({method:_292,advice:_293,func:nf});
}else{
if(_294=="dojo/watch"){
_28f.push({prop:prop,func:nf});
}else{
_28e.push(nf);
}
}
}
}
}
var _295=ctor.markupFactory||_27f.markupFactory;
var _296=_295?_295(_280,node,ctor):new ctor(_280,node);
if(_288){
_252.setObject(_288,_296);
}
for(i=0;i<_28d.length;i++){
_259[_28d[i].advice||"after"](_296,_28d[i].method,_252.hitch(_296,_28d[i].func),true);
}
for(i=0;i<_28e.length;i++){
_28e[i].call(_296);
}
for(i=0;i<_28f.length;i++){
_296.watch(_28f[i].prop,_28f[i].func);
}
for(i=0;i<ons.length;i++){
don(_296,ons[i].event,ons[i].func);
}
return _296;
},scan:function(root,_297){
var list=[],mids=[],_298={};
var _299=(_297.scope||dojo._scopeName)+"Type",_29a="data-"+(_297.scope||dojo._scopeName)+"-",_29b=_29a+"type",_29c=_29a+"textdir",_29d=_29a+"mixins";
var node=root.firstChild;
var _29e=_297.inherited;
if(!_29e){
function _29f(node,attr){
return (node.getAttribute&&node.getAttribute(attr))||(node.parentNode&&_29f(node.parentNode,attr));
};
_29e={dir:_29f(root,"dir"),lang:_29f(root,"lang"),textDir:_29f(root,_29c)};
for(var key in _29e){
if(!_29e[key]){
delete _29e[key];
}
}
}
var _2a0={inherited:_29e};
var _2a1;
var _2a2;
function _2a3(_2a4){
if(!_2a4.inherited){
_2a4.inherited={};
var node=_2a4.node,_2a5=_2a3(_2a4.parent);
var _2a6={dir:node.getAttribute("dir")||_2a5.dir,lang:node.getAttribute("lang")||_2a5.lang,textDir:node.getAttribute(_29c)||_2a5.textDir};
for(var key in _2a6){
if(_2a6[key]){
_2a4.inherited[key]=_2a6[key];
}
}
}
return _2a4.inherited;
};
while(true){
if(!node){
if(!_2a0||!_2a0.node){
break;
}
node=_2a0.node.nextSibling;
_2a2=false;
_2a0=_2a0.parent;
_2a1=_2a0.scripts;
continue;
}
if(node.nodeType!=1){
node=node.nextSibling;
continue;
}
if(_2a1&&node.nodeName.toLowerCase()=="script"){
type=node.getAttribute("type");
if(type&&/^dojo\/\w/i.test(type)){
_2a1.push(node);
}
node=node.nextSibling;
continue;
}
if(_2a2){
node=node.nextSibling;
continue;
}
var type=node.getAttribute(_29b)||node.getAttribute(_299);
var _2a7=node.firstChild;
if(!type&&(!_2a7||(_2a7.nodeType==3&&!_2a7.nextSibling))){
node=node.nextSibling;
continue;
}
var _2a8;
var ctor=null;
if(type){
var _2a9=node.getAttribute(_29d),_2aa=_2a9?[type].concat(_2a9.split(/\s*,\s*/)):[type];
try{
ctor=_262(_2aa);
}
catch(e){
}
if(!ctor){
_253.forEach(_2aa,function(t){
if(~t.indexOf("/")&&!_298[t]){
_298[t]=true;
mids[mids.length]=t;
}
});
}
var _2ab=ctor&&!ctor.prototype._noScript?[]:null;
_2a8={types:_2aa,ctor:ctor,parent:_2a0,node:node,scripts:_2ab};
_2a8.inherited=_2a3(_2a8);
list.push(_2a8);
}else{
_2a8={node:node,scripts:_2a1,parent:_2a0};
}
node=_2a7;
_2a1=_2ab;
_2a2=ctor&&ctor.prototype.stopParser&&!(_297.template);
_2a0=_2a8;
}
var d=new _25b();
if(mids.length){
if(has("dojo-debug-messages")){
console.warn("WARNING: Modules being Auto-Required: "+mids.join(", "));
}
_251(mids,function(){
d.resolve(_253.filter(list,function(_2ac){
if(!_2ac.ctor){
try{
_2ac.ctor=_262(_2ac.types);
}
catch(e){
}
}
var _2ad=_2ac.parent;
while(_2ad&&!_2ad.types){
_2ad=_2ad.parent;
}
var _2ae=_2ac.ctor&&_2ac.ctor.prototype;
_2ac.instantiateChildren=!(_2ae&&_2ae.stopParser&&!(_297.template));
_2ac.instantiate=!_2ad||(_2ad.instantiate&&_2ad.instantiateChildren);
return _2ac.instantiate;
}));
});
}else{
d.resolve(list);
}
return d.promise;
},_require:function(_2af){
var hash=_258.fromJson("{"+_2af.innerHTML+"}"),vars=[],mids=[],d=new _25b();
for(var name in hash){
vars.push(name);
mids.push(hash[name]);
}
_251(mids,function(){
for(var i=0;i<vars.length;i++){
_252.setObject(vars[i],arguments[i]);
}
d.resolve(arguments);
});
return d.promise;
},_scanAmd:function(root){
var _2b0=new _25b(),_2b1=_2b0.promise;
_2b0.resolve(true);
var self=this;
_25c("script[type='dojo/require']",root).forEach(function(node){
_2b1=_2b1.then(function(){
return self._require(node);
});
node.parentNode.removeChild(node);
});
return _2b1;
},parse:function(_2b2,_2b3){
var root;
if(!_2b3&&_2b2&&_2b2.rootNode){
_2b3=_2b2;
root=_2b3.rootNode;
}else{
if(_2b2&&_252.isObject(_2b2)&&!("nodeType" in _2b2)){
_2b3=_2b2;
}else{
root=_2b2;
}
}
root=root?_255.byId(root):_256.body();
_2b3=_2b3||{};
var _2b4=_2b3.template?{template:true}:{},_2b5=[],self=this;
var p=this._scanAmd(root,_2b3).then(function(){
return self.scan(root,_2b3);
}).then(function(_2b6){
return _2b5=_2b5.concat(self._instantiate(_2b6,_2b4,_2b3));
}).otherwise(function(e){
console.error("dojo/parser::parse() error",e);
throw e;
});
_252.mixin(_2b5,p);
return _2b5;
}};
if(1){
dojo.parser=_265;
}
if(_254.parseOnLoad){
_25d(100,_265,"parse");
}
return _265;
});
},"dijit/layout/_LayoutWidget":function(){
define("dijit/layout/_LayoutWidget",["dojo/_base/lang","../_Widget","../_Container","../_Contained","../Viewport","dojo/_base/declare","dojo/dom-class","dojo/dom-geometry","dojo/dom-style"],function(lang,_2b7,_2b8,_2b9,_2ba,_2bb,_2bc,_2bd,_2be){
return _2bb("dijit.layout._LayoutWidget",[_2b7,_2b8,_2b9],{baseClass:"dijitLayoutContainer",isLayoutContainer:true,buildRendering:function(){
this.inherited(arguments);
_2bc.add(this.domNode,"dijitContainer");
},startup:function(){
if(this._started){
return;
}
this.inherited(arguments);
var _2bf=this.getParent&&this.getParent();
if(!(_2bf&&_2bf.isLayoutContainer)){
this.resize();
this.own(_2ba.on("resize",lang.hitch(this,"resize")));
}
},resize:function(_2c0,_2c1){
var node=this.domNode;
if(_2c0){
_2bd.setMarginBox(node,_2c0);
}
var mb=_2c1||{};
lang.mixin(mb,_2c0||{});
if(!("h" in mb)||!("w" in mb)){
mb=lang.mixin(_2bd.getMarginBox(node),mb);
}
var cs=_2be.getComputedStyle(node);
var me=_2bd.getMarginExtents(node,cs);
var be=_2bd.getBorderExtents(node,cs);
var bb=(this._borderBox={w:mb.w-(me.w+be.w),h:mb.h-(me.h+be.h)});
var pe=_2bd.getPadExtents(node,cs);
this._contentBox={l:_2be.toPixelValue(node,cs.paddingLeft),t:_2be.toPixelValue(node,cs.paddingTop),w:bb.w-pe.w,h:bb.h-pe.h};
this.layout();
},layout:function(){
},_setupChild:function(_2c2){
var cls=this.baseClass+"-child "+(_2c2.baseClass?this.baseClass+"-"+_2c2.baseClass:"");
_2bc.add(_2c2.domNode,cls);
},addChild:function(_2c3,_2c4){
this.inherited(arguments);
if(this._started){
this._setupChild(_2c3);
}
},removeChild:function(_2c5){
var cls=this.baseClass+"-child"+(_2c5.baseClass?" "+this.baseClass+"-"+_2c5.baseClass:"");
_2bc.remove(_2c5.domNode,cls);
this.inherited(arguments);
}});
});
},"dijit/_Widget":function(){
define("dijit/_Widget",["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_2c6,_2c7,_2c8,_2c9,has,_2ca,lang,_2cb,_2cc,_2cd,_2ce,_2cf,_2d0){
function _2d1(){
};
function _2d2(_2d3){
return function(obj,_2d4,_2d5,_2d6){
if(obj&&typeof _2d4=="string"&&obj[_2d4]==_2d1){
return obj.on(_2d4.substring(2).toLowerCase(),lang.hitch(_2d5,_2d6));
}
return _2d3.apply(_2c8,arguments);
};
};
_2c6.around(_2c8,"connect",_2d2);
if(_2ca.connect){
_2c6.around(_2ca,"connect",_2d2);
}
var _2d7=_2c9("dijit._Widget",[_2ce,_2cf,_2d0],{onClick:_2d1,onDblClick:_2d1,onKeyDown:_2d1,onKeyPress:_2d1,onKeyUp:_2d1,onMouseDown:_2d1,onMouseMove:_2d1,onMouseOut:_2d1,onMouseOver:_2d1,onMouseLeave:_2d1,onMouseEnter:_2d1,onMouseUp:_2d1,constructor:function(_2d8){
this._toConnect={};
for(var name in _2d8){
if(this[name]===_2d1){
this._toConnect[name.replace(/^on/,"").toLowerCase()]=_2d8[name];
delete _2d8[name];
}
}
},postCreate:function(){
this.inherited(arguments);
for(var name in this._toConnect){
this.on(name,this._toConnect[name]);
}
delete this._toConnect;
},on:function(type,func){
if(this[this._onMap(type)]===_2d1){
return _2c8.connect(this.domNode,type.toLowerCase(),this,func);
}
return this.inherited(arguments);
},_setFocusedAttr:function(val){
this._focused=val;
this._set("focused",val);
},setAttribute:function(attr,_2d9){
_2ca.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");
this.set(attr,_2d9);
},attr:function(name,_2da){
if(_2c7.isDebug){
var _2db=arguments.callee._ach||(arguments.callee._ach={}),_2dc=(arguments.callee.caller||"unknown caller").toString();
if(!_2db[_2dc]){
_2ca.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_2dc,"","2.0");
_2db[_2dc]=true;
}
}
var args=arguments.length;
if(args>=2||typeof name==="object"){
return this.set.apply(this,arguments);
}else{
return this.get(name);
}
},getDescendants:function(){
_2ca.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");
return this.containerNode?_2cb("[widgetId]",this.containerNode).map(_2cd.byNode):[];
},_onShow:function(){
this.onShow();
},onShow:function(){
},onHide:function(){
},onClose:function(){
return true;
}});
if(has("dijit-legacy-requires")){
_2cc(0,function(){
var _2dd=["dijit/_base"];
require(_2dd);
});
}
return _2d7;
});
},"dijit/_FocusMixin":function(){
define(["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_2de,_2df,_2e0,lang){
lang.extend(_2df,{focused:false,onFocus:function(){
},onBlur:function(){
},_onFocus:function(){
this.onFocus();
},_onBlur:function(){
this.onBlur();
}});
return _2e0("dijit._FocusMixin",null,{_focusManager:_2de});
});
},"dijit/focus":function(){
define("dijit/focus",["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/Stateful","dojo/_base/unload","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_2e1,_2e2,dom,_2e3,_2e4,_2e5,lang,on,_2e6,has,_2e7,_2e8,win,_2e9,a11y,_2ea,_2eb){
var _2ec=_2e2([_2e7,_2e5],{curNode:null,activeStack:[],constructor:function(){
var _2ed=lang.hitch(this,function(node){
if(dom.isDescendant(this.curNode,node)){
this.set("curNode",null);
}
if(dom.isDescendant(this.prevNode,node)){
this.set("prevNode",null);
}
});
_2e1.before(_2e4,"empty",_2ed);
_2e1.before(_2e4,"destroy",_2ed);
},registerIframe:function(_2ee){
return this.registerWin(_2ee.contentWindow,_2ee);
},registerWin:function(_2ef,_2f0){
var _2f1=this;
var _2f2=function(evt){
_2f1._justMouseDowned=true;
setTimeout(function(){
_2f1._justMouseDowned=false;
},0);
if(has("ie")&&evt&&evt.srcElement&&evt.srcElement.parentNode==null){
return;
}
_2f1._onTouchNode(_2f0||evt.target||evt.srcElement,"mouse");
};
var doc=has("ie")?_2ef.document.documentElement:_2ef.document;
if(doc){
if(has("ie")){
_2ef.document.body.attachEvent("onmousedown",_2f2);
var _2f3=function(evt){
var tag=evt.srcElement.tagName.toLowerCase();
if(tag=="#document"||tag=="body"){
return;
}
if(a11y.isTabNavigable(evt.srcElement)){
_2f1._onFocusNode(_2f0||evt.srcElement);
}else{
_2f1._onTouchNode(_2f0||evt.srcElement);
}
};
doc.attachEvent("onfocusin",_2f3);
var _2f4=function(evt){
_2f1._onBlurNode(_2f0||evt.srcElement);
};
doc.attachEvent("onfocusout",_2f4);
return {remove:function(){
_2ef.document.detachEvent("onmousedown",_2f2);
doc.detachEvent("onfocusin",_2f3);
doc.detachEvent("onfocusout",_2f4);
doc=null;
}};
}else{
doc.body.addEventListener("mousedown",_2f2,true);
doc.body.addEventListener("touchstart",_2f2,true);
var _2f5=function(evt){
_2f1._onFocusNode(_2f0||evt.target);
};
doc.addEventListener("focus",_2f5,true);
var _2f6=function(evt){
_2f1._onBlurNode(_2f0||evt.target);
};
doc.addEventListener("blur",_2f6,true);
return {remove:function(){
doc.body.removeEventListener("mousedown",_2f2,true);
doc.body.removeEventListener("touchstart",_2f2,true);
doc.removeEventListener("focus",_2f5,true);
doc.removeEventListener("blur",_2f6,true);
doc=null;
}};
}
}
},_onBlurNode:function(node){
if(this._clearFocusTimer){
clearTimeout(this._clearFocusTimer);
}
this._clearFocusTimer=setTimeout(lang.hitch(this,function(){
this.set("prevNode",this.curNode);
this.set("curNode",null);
}),0);
if(this._justMouseDowned){
return;
}
if(this._clearActiveWidgetsTimer){
clearTimeout(this._clearActiveWidgetsTimer);
}
this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){
delete this._clearActiveWidgetsTimer;
this._setStack([]);
}),0);
},_onTouchNode:function(node,by){
if(this._clearActiveWidgetsTimer){
clearTimeout(this._clearActiveWidgetsTimer);
delete this._clearActiveWidgetsTimer;
}
var _2f7=[];
try{
while(node){
var _2f8=_2e3.get(node,"dijitPopupParent");
if(_2f8){
node=_2ea.byId(_2f8).domNode;
}else{
if(node.tagName&&node.tagName.toLowerCase()=="body"){
if(node===win.body()){
break;
}
node=_2e9.get(node.ownerDocument).frameElement;
}else{
var id=node.getAttribute&&node.getAttribute("widgetId"),_2f9=id&&_2ea.byId(id);
if(_2f9&&!(by=="mouse"&&_2f9.get("disabled"))){
_2f7.unshift(id);
}
node=node.parentNode;
}
}
}
}
catch(e){
}
this._setStack(_2f7,by);
},_onFocusNode:function(node){
if(!node){
return;
}
if(node.nodeType==9){
return;
}
if(this._clearFocusTimer){
clearTimeout(this._clearFocusTimer);
delete this._clearFocusTimer;
}
this._onTouchNode(node);
if(node==this.curNode){
return;
}
this.set("prevNode",this.curNode);
this.set("curNode",node);
},_setStack:function(_2fa,by){
var _2fb=this.activeStack;
this.set("activeStack",_2fa);
for(var _2fc=0;_2fc<Math.min(_2fb.length,_2fa.length);_2fc++){
if(_2fb[_2fc]!=_2fa[_2fc]){
break;
}
}
var _2fd;
for(var i=_2fb.length-1;i>=_2fc;i--){
_2fd=_2ea.byId(_2fb[i]);
if(_2fd){
_2fd._hasBeenBlurred=true;
_2fd.set("focused",false);
if(_2fd._focusManager==this){
_2fd._onBlur(by);
}
this.emit("widget-blur",_2fd,by);
}
}
for(i=_2fc;i<_2fa.length;i++){
_2fd=_2ea.byId(_2fa[i]);
if(_2fd){
_2fd.set("focused",true);
if(_2fd._focusManager==this){
_2fd._onFocus(by);
}
this.emit("widget-focus",_2fd,by);
}
}
},focus:function(node){
if(node){
try{
node.focus();
}
catch(e){
}
}
}});
var _2fe=new _2ec();
_2e6(function(){
var _2ff=_2fe.registerWin(_2e9.get(win.doc));
if(has("ie")){
_2e8.addOnWindowUnload(function(){
if(_2ff){
_2ff.remove();
_2ff=null;
}
});
}
});
_2eb.focus=function(node){
_2fe.focus(node);
};
for(var attr in _2fe){
if(!/^_/.test(attr)){
_2eb.focus[attr]=typeof _2fe[attr]=="function"?lang.hitch(_2fe,attr):_2fe[attr];
}
}
_2fe.watch(function(attr,_300,_301){
_2eb.focus[attr]=_301;
});
return _2fe;
});
},"dijit/_Contained":function(){
define("dijit/_Contained",["dojo/_base/declare","./registry"],function(_302,_303){
return _302("dijit._Contained",null,{_getSibling:function(_304){
var node=this.domNode;
do{
node=node[_304+"Sibling"];
}while(node&&node.nodeType!=1);
return node&&_303.byNode(node);
},getPreviousSibling:function(){
return this._getSibling("previous");
},getNextSibling:function(){
return this._getSibling("next");
},getIndexInParent:function(){
var p=this.getParent();
if(!p||!p.getIndexOfChild){
return -1;
}
return p.getIndexOfChild(this);
}});
});
},"dijit/_base/scroll":function(){
define("dijit/_base/scroll",["dojo/window","../main"],function(_305,_306){
_306.scrollIntoView=function(node,pos){
_305.scrollIntoView(node,pos);
};
});
},"dijit/main":function(){
define("dijit/main",["dojo/_base/kernel"],function(dojo){
return dojo.dijit;
});
},"dijit/Destroyable":function(){
define("dijit/Destroyable",["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_307,_308,_309){
return _309("dijit.Destroyable",null,{destroy:function(_30a){
this._destroyed=true;
},own:function(){
_307.forEach(arguments,function(_30b){
var _30c="destroyRecursive" in _30b?"destroyRecursive":"destroy" in _30b?"destroy":"remove";
var odh=_308.before(this,"destroy",function(_30d){
_30b[_30c](_30d);
});
var hdh=_308.after(_30b,_30c,function(){
odh.remove();
hdh.remove();
},true);
},this);
return arguments;
}});
});
},"dojo/cache":function(){
define(["./_base/kernel","./text"],function(dojo){
return dojo.cache;
});
},"dijit/_base/window":function(){
define("dijit/_base/window",["dojo/window","../main"],function(_30e,_30f){
_30f.getDocumentWindow=function(doc){
return _30e.get(doc);
};
});
},"dijit/_base/typematic":function(){
define(["../typematic"],function(){
});
},"dijit/_base/popup":function(){
define("dijit/_base/popup",["dojo/dom-class","dojo/_base/window","../popup","../BackgroundIframe"],function(_310,win,_311){
var _312=_311._createWrapper;
_311._createWrapper=function(_313){
if(!_313.declaredClass){
_313={_popupWrapper:(_313.parentNode&&_310.contains(_313.parentNode,"dijitPopup"))?_313.parentNode:null,domNode:_313,destroy:function(){
},ownerDocument:_313.ownerDocument,ownerDocumentBody:win.body(_313.ownerDocument)};
}
return _312.call(this,_313);
};
var _314=_311.open;
_311.open=function(args){
if(args.orient&&typeof args.orient!="string"&&!("length" in args.orient)){
var ary=[];
for(var key in args.orient){
ary.push({aroundCorner:key,corner:args.orient[key]});
}
args.orient=ary;
}
return _314.call(this,args);
};
return _311;
});
},"dijit/_Container":function(){
define("dijit/_Container",["dojo/_base/array","dojo/_base/declare","dojo/dom-construct"],function(_315,_316,_317){
return _316("dijit._Container",null,{buildRendering:function(){
this.inherited(arguments);
if(!this.containerNode){
this.containerNode=this.domNode;
}
},addChild:function(_318,_319){
var _31a=this.containerNode;
if(_319&&typeof _319=="number"){
var _31b=this.getChildren();
if(_31b&&_31b.length>=_319){
_31a=_31b[_319-1].domNode;
_319="after";
}
}
_317.place(_318.domNode,_31a,_319);
if(this._started&&!_318._started){
_318.startup();
}
},removeChild:function(_31c){
if(typeof _31c=="number"){
_31c=this.getChildren()[_31c];
}
if(_31c){
var node=_31c.domNode;
if(node&&node.parentNode){
node.parentNode.removeChild(node);
}
}
},hasChildren:function(){
return this.getChildren().length>0;
},_getSiblingOfChild:function(_31d,dir){
var _31e=this.getChildren(),idx=_315.indexOf(this.getChildren(),_31d);
return _31e[idx+dir];
},getIndexOfChild:function(_31f){
return _315.indexOf(this.getChildren(),_31f);
}});
});
}}});
define("dijit/dijit",["./main","./_base","dojo/parser","./_Widget","./_TemplatedMixin","./_Container","./layout/_LayoutWidget","./form/_FormWidget","./form/_FormValueWidget"],function(_320){
return _320;
});
